/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractXMLRenderer
extends PrintRenderer {
    public static final String NS = "";
    public static final String CDATA = "CDATA";
    public static final Attributes EMPTY_ATTS = new AttributesImpl();
    protected AttributesImpl atts = new AttributesImpl();
    protected ContentHandler handler;
    protected OutputStream out;
    protected RendererContext context;
    protected List extensionAttachments;

    public AbstractXMLRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    protected void handleSAXException(SAXException sAXException) {
        throw new RuntimeException(sAXException.getMessage());
    }

    protected void handlePageExtensionAttachments(PageViewport pageViewport) {
        this.handleExtensionAttachments(pageViewport.getExtensionAttachments());
    }

    protected void comment(String string) {
        if (this.handler instanceof LexicalHandler) {
            try {
                ((LexicalHandler)((Object)this.handler)).comment(string.toCharArray(), 0, string.length());
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
    }

    protected void startElement(String string) {
        this.startElement(string, EMPTY_ATTS);
    }

    protected void startElement(String string, Attributes attributes) {
        try {
            this.handler.startElement(NS, string, string, attributes);
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    protected void endElement(String string) {
        try {
            this.handler.endElement(NS, string, string);
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    protected void characters(String string) {
        try {
            char[] cArray = string.toCharArray();
            this.handler.characters(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    protected void addAttribute(String string, String string2) {
        this.atts.addAttribute(NS, string, string, CDATA, string2);
    }

    protected void addAttribute(QName qName, String string) {
        this.atts.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), qName.getQName(), CDATA, string);
    }

    protected void addAttribute(String string, int n) {
        this.addAttribute(string, Integer.toString(n));
    }

    private String createString(Rectangle2D rectangle2D) {
        return NS + (int)rectangle2D.getX() + " " + (int)rectangle2D.getY() + " " + (int)rectangle2D.getWidth() + " " + (int)rectangle2D.getHeight();
    }

    protected void addAttribute(String string, Rectangle2D rectangle2D) {
        this.addAttribute(string, this.createString(rectangle2D));
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        if (this.handler == null) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            try {
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
                this.setContentHandler(transformerHandler);
                StreamResult streamResult = new StreamResult(outputStream);
                transformerHandler.setResult(streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(transformerConfigurationException.getMessage());
            }
            this.out = outputStream;
        }
        try {
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void stopRenderer() throws IOException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void processOffDocumentItem(OffDocumentItem offDocumentItem) {
        if (offDocumentItem instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)offDocumentItem);
        } else if (offDocumentItem instanceof OffDocumentExtensionAttachment) {
            ExtensionAttachment extensionAttachment = ((OffDocumentExtensionAttachment)offDocumentItem).getAttachment();
            if (this.extensionAttachments == null) {
                this.extensionAttachments = new ArrayList();
            }
            this.extensionAttachments.add(extensionAttachment);
        } else {
            String string = "Ignoring OffDocumentItem: " + offDocumentItem;
            log.warn((Object)string);
        }
    }

    protected void handleDocumentExtensionAttachments() {
        if (this.extensionAttachments != null && this.extensionAttachments.size() > 0) {
            this.handleExtensionAttachments(this.extensionAttachments);
            this.extensionAttachments.clear();
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    protected abstract void handleExtensionAttachments(List var1);

    protected abstract void renderBookmarkTree(BookmarkData var1);
}

