/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.servlet.FopServlet;

public class FopPrintServlet
extends FopServlet {
    private static final long serialVersionUID = 1645706757391617935L;

    protected void render(Source source, Transformer transformer, HttpServletResponse httpServletResponse) throws FOPException, TransformerException, IOException {
        FOUserAgent fOUserAgent = this.getFOUserAgent();
        Fop fop = this.fopFactory.newFop("application/X-fop-print", fOUserAgent);
        SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
        transformer.transform(source, sAXResult);
        this.reportOK(httpServletResponse);
    }

    private void reportOK(HttpServletResponse httpServletResponse) throws IOException {
        String string = "<html><title>Success</title>\n<body><h1>FopPrintServlet: </h1><h3>The requested data was printed to the default printer.</h3></body></html>";
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setContentLength(string.length());
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(string);
        printWriter.flush();
    }
}

