/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

public final class ACIUtils {
    private static final Log LOG = LogFactory.getLog(ACIUtils.class);

    private ACIUtils() {
    }

    public static Font[] findFontsForBatikACI(AttributedCharacterIterator attributedCharacterIterator, FontInfo fontInfo) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = (List)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        Float f = (Float)attributedCharacterIterator.getAttribute(TextAttribute.POSTURE);
        Float f2 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT);
        Float f3 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
        String string = ACIUtils.toStyle(f);
        int n = ACIUtils.toCSSWeight(f2);
        int n2 = (int)(f3.floatValue() * 1000.0f);
        String string2 = null;
        GVTFont gVTFont = (GVTFont)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gVTFont != null) {
            object2 = gVTFont.getFamilyName();
            if (fontInfo.hasFont((String)object2, string, n)) {
                object = fontInfo.fontLookup((String)object2, string, n);
                Object object3 = fontInfo.getFontInstance((FontTriplet)object, n2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found a font that matches the GVT font: " + (String)object2 + ", " + n + ", " + string + " -> " + object3));
                }
                arrayList.add(object3);
            }
            string2 = object2;
        }
        if (list != null) {
            boolean bl = false;
            for (Object object3 : list) {
                String string3;
                if (object3 instanceof SVGFontFamily) {
                    bl = true;
                }
                if (fontInfo.hasFont(string3 = object3.getFamilyName(), string, n)) {
                    FontTriplet fontTriplet = fontInfo.fontLookup(string3, string, n);
                    Font font = fontInfo.getFontInstance(fontTriplet, n2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found a font that matches the GVT font family: " + string3 + ", " + n + ", " + string + " -> " + font));
                    }
                    arrayList.add(font);
                }
                if (string2 != null) continue;
                string2 = string3;
            }
            if (arrayList.isEmpty() && bl) {
                fontInfo.notifyStrokingSVGTextAsShapes(string2);
                return null;
            }
        }
        if (arrayList.isEmpty()) {
            if (string2 == null) {
                string2 = "any";
            }
            object2 = fontInfo.fontLookup(string2, string, n);
            object = fontInfo.getFontInstance((FontTriplet)object2, n2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Falling back to adjustable font lookup up for: " + string2 + ", " + n + ", " + string + " -> " + object));
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new Font[arrayList.size()]);
    }

    private static int toCSSWeight(Float f) {
        if (f == null) {
            return 400;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_EXTRA_LIGHT.floatValue()) {
            return 100;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_LIGHT.floatValue()) {
            return 200;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_DEMILIGHT.floatValue()) {
            return 300;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_REGULAR.floatValue()) {
            return 400;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_SEMIBOLD.floatValue()) {
            return 500;
        }
        if (f.floatValue() < TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 600;
        }
        if (f.floatValue() == TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 700;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_HEAVY.floatValue()) {
            return 800;
        }
        if (f.floatValue() <= TextAttribute.WEIGHT_EXTRABOLD.floatValue()) {
            return 900;
        }
        return 900;
    }

    private static String toStyle(Float f) {
        return f != null && (double)f.floatValue() > 0.0 ? "italic" : "normal";
    }

    public static void dumpAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        Set<Map.Entry<AttributedCharacterIterator.Attribute, Object>> set = attributedCharacterIterator.getAttributes().entrySet();
        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : set) {
            if (entry.getValue() == null) continue;
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        int n = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n2 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n2 - n) + ", ");
            attributedCharacterIterator.setIndex(n2);
            if (n == n2) break;
            n = n2;
        }
        System.out.println("");
    }
}

