/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.fontlist;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.tools.fontlist.FontSpec;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FontListSerializer {
    private static final String FONTS = "fonts";
    private static final String FAMILY = "family";
    private static final String FONT = "font";
    private static final String TRIPLETS = "triplets";
    private static final String TRIPLET = "triplet";
    private static final String NAME = "name";
    private static final String STRIPPED_NAME = "stripped-name";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String STYLE = "style";
    private static final String WEIGHT = "weight";
    private static final String CDATA = "CDATA";
    private final Pattern quotePattern = Pattern.compile("'");

    public void generateSAX(SortedMap sortedMap, GenerationHelperContentHandler generationHelperContentHandler) throws SAXException {
        this.generateSAX(sortedMap, null, generationHelperContentHandler);
    }

    public void generateSAX(SortedMap sortedMap, String string, GenerationHelperContentHandler generationHelperContentHandler) throws SAXException {
        generationHelperContentHandler.startDocument();
        AttributesImpl attributesImpl = new AttributesImpl();
        generationHelperContentHandler.startElement(FONTS, (Attributes)attributesImpl);
        for (Map.Entry entry : sortedMap.entrySet()) {
            String string2 = (String)entry.getKey();
            if (string != null && string2 != string) continue;
            attributesImpl.clear();
            attributesImpl.addAttribute(null, NAME, NAME, CDATA, string2);
            attributesImpl.addAttribute(null, STRIPPED_NAME, STRIPPED_NAME, CDATA, this.stripQuotes(string2));
            generationHelperContentHandler.startElement(FAMILY, (Attributes)attributesImpl);
            List list = (List)entry.getValue();
            this.generateXMLForFontContainers(generationHelperContentHandler, list);
            generationHelperContentHandler.endElement(FAMILY);
        }
        generationHelperContentHandler.endElement(FONTS);
        generationHelperContentHandler.endDocument();
    }

    private String stripQuotes(String string) {
        return this.quotePattern.matcher(string).replaceAll("");
    }

    private void generateXMLForFontContainers(GenerationHelperContentHandler generationHelperContentHandler, List list) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        for (FontSpec fontSpec : list) {
            attributesImpl.clear();
            attributesImpl.addAttribute(null, KEY, KEY, CDATA, fontSpec.getKey());
            attributesImpl.addAttribute(null, TYPE, TYPE, CDATA, fontSpec.getFontMetrics().getFontType().getName());
            generationHelperContentHandler.startElement(FONT, (Attributes)attributesImpl);
            this.generateXMLForTriplets(generationHelperContentHandler, fontSpec.getTriplets());
            generationHelperContentHandler.endElement(FONT);
        }
    }

    private void generateXMLForTriplets(GenerationHelperContentHandler generationHelperContentHandler, Collection collection) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.clear();
        generationHelperContentHandler.startElement(TRIPLETS, (Attributes)attributesImpl);
        for (FontTriplet fontTriplet : collection) {
            attributesImpl.clear();
            attributesImpl.addAttribute(null, NAME, NAME, CDATA, fontTriplet.getName());
            attributesImpl.addAttribute(null, STYLE, STYLE, CDATA, fontTriplet.getStyle());
            attributesImpl.addAttribute(null, WEIGHT, WEIGHT, CDATA, Integer.toString(fontTriplet.getWeight()));
            generationHelperContentHandler.element(TRIPLET, (Attributes)attributesImpl);
        }
        generationHelperContentHandler.endElement(TRIPLETS);
    }
}

