/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Arrays;

@Deprecated
public final class ColorExt
extends Color {
    private static final long serialVersionUID = 1L;
    private float rgbReplacementRed;
    private float rgbReplacementGreen;
    private float rgbReplacementBlue;
    private String iccProfileName;
    private String iccProfileSrc;
    private ColorSpace colorSpace;
    private float[] colorValues;

    private ColorExt(ColorSpace colorSpace, float[] fArray, float f) {
        super(colorSpace, fArray, f);
    }

    private ColorExt(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public static ColorExt createFromFoRgbIcc(float f, float f2, float f3, String string, String string2, ColorSpace colorSpace, float[] fArray) {
        ColorExt colorExt = new ColorExt(colorSpace, fArray, 1.0f);
        colorExt.rgbReplacementRed = f;
        colorExt.rgbReplacementGreen = f2;
        colorExt.rgbReplacementBlue = f3;
        colorExt.iccProfileName = string;
        colorExt.iccProfileSrc = string2;
        colorExt.colorSpace = colorSpace;
        colorExt.colorValues = fArray;
        return colorExt;
    }

    public static ColorExt createFromSvgIccColor(float f, float f2, float f3, float f4, String string, String string2, ColorSpace colorSpace, float[] fArray) {
        ColorExt colorExt = new ColorExt(f, f2, f3, f4);
        colorExt.rgbReplacementRed = -1.0f;
        colorExt.rgbReplacementGreen = -1.0f;
        colorExt.rgbReplacementBlue = -1.0f;
        colorExt.iccProfileName = string;
        colorExt.iccProfileSrc = string2;
        colorExt.colorSpace = colorSpace;
        colorExt.colorValues = fArray;
        return colorExt;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorExt colorExt = (ColorExt)object;
        if (!Arrays.equals(this.colorValues, colorExt.colorValues)) {
            return false;
        }
        if (this.iccProfileName == null ? colorExt.iccProfileName != null : !this.iccProfileName.equals(colorExt.iccProfileName)) {
            return false;
        }
        if (this.iccProfileSrc == null ? colorExt.iccProfileSrc != null : !this.iccProfileSrc.equals(colorExt.iccProfileSrc)) {
            return false;
        }
        if (Float.floatToIntBits(this.rgbReplacementBlue) != Float.floatToIntBits(colorExt.rgbReplacementBlue)) {
            return false;
        }
        if (Float.floatToIntBits(this.rgbReplacementGreen) != Float.floatToIntBits(colorExt.rgbReplacementGreen)) {
            return false;
        }
        return Float.floatToIntBits(this.rgbReplacementRed) == Float.floatToIntBits(colorExt.rgbReplacementRed);
    }

    public String getIccProfileName() {
        return this.iccProfileName;
    }

    public String getIccProfileSrc() {
        return this.iccProfileSrc;
    }

    public ColorSpace getOrigColorSpace() {
        return this.colorSpace;
    }

    public float[] getOriginalColorComponents() {
        float[] fArray = new float[this.colorValues.length];
        System.arraycopy(this.colorValues, 0, fArray, 0, fArray.length);
        return fArray;
    }

    public String toFunctionCall() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("fop-rgb-icc(");
        stringBuffer.append(this.rgbReplacementRed + ",");
        stringBuffer.append(this.rgbReplacementGreen + ",");
        stringBuffer.append(this.rgbReplacementBlue + ",");
        stringBuffer.append(this.iccProfileName + ",");
        if (this.iccProfileSrc != null) {
            stringBuffer.append("\"" + this.iccProfileSrc + "\"");
        }
        float[] fArray = this.getColorComponents(null);
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(fArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

