/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import java.rmi.RemoteException;

public abstract class InvocationNewUser
extends AbstractInvocationWithAuth<Object> {
    public InvocationNewUser(UserIdentity userIdentity) {
        super(userIdentity);
    }

    @Override
    public Object makeInvocation(CredentialStore<AuthenticationToken> credentialStore, RemoteAuthorisationModule remoteAuthorisationModule) throws AuthorisationFailedException, RemoteException, MJSException {
        CredentialProviderImpl credentialProviderImpl = this.makeCredentialProvider();
        this.setCredentialProvider(credentialProviderImpl.getProxy());
        NewPasswordReturn newPasswordReturn = null;
        while (true) {
            try {
                Object t = this.invoke();
                return t;
            }
            catch (NoCredentialsException noCredentialsException) {
                newPasswordReturn = remoteAuthorisationModule.promptForNewPassword(this.getUserIdentity());
                credentialProviderImpl.getCredentialStore().putCredentials(newPasswordReturn.getNewCredentials());
                continue;
            }
            break;
        }
        finally {
            if (newPasswordReturn != null) {
                credentialStore.putCredentials(newPasswordReturn.getNewToken(), newPasswordReturn.getRememberChoice());
                newPasswordReturn.getNewCredentials().erase();
            }
            credentialProviderImpl.unexport();
        }
    }
}

