/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer.view;

import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.TextualCredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModel;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.AuthorizationModelFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.Choice;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.ChoiceInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.Input;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.InputField;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.PasswordInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.StringInput;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.view.AuthorizationView;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TextualView
implements AuthorizationView {
    private static final ResourceBundleUtilities RESOURCE_BUNDLE_UTILITIES = ResourceBundleUtilities.getInstance(TextualView.class);
    private static final int LINE_WIDTH = 80;
    private final TextualCredentialConsumer.Prompt fPrompt;
    private final AuthorizationModelFactory fFactory;
    private final AuthorizationModelFactory.ModelSpec fSpec;
    private final WordwrapPrinter fOut;
    private final WordwrapPrinter fErr;
    private AuthorizationModel fModel;
    private boolean fApproved = false;

    public TextualView(TextualCredentialConsumer.Prompt prompt, AuthorizationModelFactory authorizationModelFactory, AuthorizationModelFactory.ModelSpec modelSpec) {
        assert (authorizationModelFactory != null) : "factory must not be null.";
        assert (modelSpec != null) : "spec must not be null.";
        this.fPrompt = prompt;
        this.fFactory = authorizationModelFactory;
        this.fSpec = modelSpec;
        this.fOut = new WordwrapPrinter(this.fPrompt.getOutputStream(), 80);
        this.fErr = new WordwrapPrinter(this.fPrompt.getErrorStream(), 80);
    }

    @Override
    public AuthorizationModel getModel() {
        return this.fModel;
    }

    @Override
    public boolean isApproved() {
        return this.fApproved;
    }

    @Override
    public void showDialog(Throwable throwable) {
        this.fModel = this.fFactory.createModel(this.fSpec);
        if (throwable == null) {
            this.fOut.println("\n*** " + RESOURCE_BUNDLE_UTILITIES.getString("Dialog.Title." + (Object)((Object)this.fSpec), new Object[0]) + " ***");
            this.fOut.println(RESOURCE_BUNDLE_UTILITIES.getString(this.fModel.getBlurbMessenger()));
            this.fOut.flush();
        } else {
            this.fErr.println(throwable.getMessage());
            this.fErr.println(RESOURCE_BUNDLE_UTILITIES.getString("Message.TryAgain", new Object[0]));
            this.fErr.flush();
        }
        try {
            Map<InputField, Input<?>> map = this.fModel.getInputs();
            ListIterator listIterator = new LinkedList<InputField>(map.keySet()).listIterator();
            if (!listIterator.hasNext()) {
                String string = RESOURCE_BUNDLE_UTILITIES.getString("Remember.Textual.Key.YES", new Object[0]).substring(0, 1);
                String string2 = RESOURCE_BUNDLE_UTILITIES.getString("Remember.Textual.Label.YES", new Object[0]);
                String string3 = RESOURCE_BUNDLE_UTILITIES.getString("Remember.Textual.Key.NO", new Object[0]).substring(0, 1);
                String string4 = RESOURCE_BUNDLE_UTILITIES.getString("Remember.Textual.Label.NO", new Object[0]);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(RESOURCE_BUNDLE_UTILITIES.getString("Message.Continue", new Object[0]));
                stringBuilder.append(" (");
                stringBuilder.append(String.format("%s <%s>", string2, string));
                stringBuilder.append("|");
                stringBuilder.append(String.format("%s <%s>", string4, string3));
                stringBuilder.append(")");
                String string5 = new String(this.prompt(stringBuilder.toString(), string3, false));
                this.fApproved = string.equals(string5);
            } else {
                while (listIterator.hasNext()) {
                    InputField inputField = (InputField)((Object)listIterator.next());
                    this.addInputComponent(map.get((Object)inputField));
                    try {
                        this.getModel().validateInputField(inputField);
                    }
                    catch (AuthorizationModel.ValidationException validationException) {
                        this.fErr.println(RESOURCE_BUNDLE_UTILITIES.getString(validationException.getResourceKey(), new Object[0]));
                        this.fErr.println(RESOURCE_BUNDLE_UTILITIES.getString("Message.TryAgain", new Object[0]));
                        this.fErr.flush();
                        listIterator.previous();
                        if (inputField != InputField.CONFIRM_NEW) continue;
                        listIterator.previous();
                    }
                }
                this.fApproved = true;
            }
            this.fModel.commit();
        }
        catch (NoCredentialsEnteredException noCredentialsEnteredException) {
            this.fApproved = false;
        }
    }

    private void addInputComponent(Input<?> input) throws NoCredentialsEnteredException {
        String string = RESOURCE_BUNDLE_UTILITIES.getString(input.getLabelMessenger());
        if (input instanceof StringInput) {
            StringInput stringInput = (StringInput)input;
            String string2 = stringInput.getValue() != null ? (String)stringInput.getValue() : "";
            boolean bl = false;
            stringInput.setValue(new String(this.prompt(string, string2, bl)));
            return;
        }
        if (input instanceof PasswordInput) {
            PasswordInput passwordInput = (PasswordInput)input;
            char[] cArray = new char[]{};
            boolean bl = true;
            passwordInput.setValue(this.prompt(string, new String(cArray), bl));
            return;
        }
        if (input instanceof ChoiceInput) {
            ChoiceInput<Choice> choiceInput = TextualView.castToChoiceInput(input);
            Character c = null;
            HashMap<Character, RememberChoice> hashMap = new HashMap<Character, RememberChoice>();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(" (");
            Iterator<Choice> iterator = choiceInput.getAvailableChoices().iterator();
            while (iterator.hasNext()) {
                Choice choice = iterator.next();
                Character c2 = Character.valueOf(RESOURCE_BUNDLE_UTILITIES.getString("Remember.Textual.Key." + choice.toString(), new Object[0]).charAt(0));
                hashMap.put(c2, (RememberChoice)choice);
                String string3 = RESOURCE_BUNDLE_UTILITIES.getString("Remember.Textual.Label." + choice.toString(), new Object[0]);
                stringBuffer.append(String.format("%s <%c>", string3, c2));
                stringBuffer.append(iterator.hasNext() ? "|" : ")");
                if (!choice.equals(choiceInput.getValue())) continue;
                c = c2;
            }
            choiceInput.setValue(this.rememberPrompt(hashMap, stringBuffer.toString(), c));
            return;
        }
        assert (false) : "Input was of an unexpected type.";
    }

    private static ChoiceInput<Choice> castToChoiceInput(Input<?> input) {
        return (ChoiceInput)input;
    }

    private RememberChoice rememberPrompt(Map<Character, RememberChoice> map, String string, Character c) {
        try {
            while (true) {
                char[] cArray;
                if (map.containsKey(Character.valueOf((cArray = this.prompt(string, c.toString(), false))[0]))) {
                    return map.get(Character.valueOf(cArray[0]));
                }
                this.fErr.println(RESOURCE_BUNDLE_UTILITIES.getString("Message.InvalidOption", new String(cArray)));
                this.fErr.flush();
            }
        }
        catch (NoCredentialsEnteredException noCredentialsEnteredException) {
            return null;
        }
    }

    private char[] prompt(String string, String string2, boolean bl) throws NoCredentialsEnteredException {
        if (string2 != null && string2.length() > 0) {
            string = string + " [" + string2 + "]";
        }
        string = string + ": ";
        char[] cArray = null;
        while (cArray == null) {
            char[] cArray2 = this.fPrompt.prompt(string, bl);
            if (cArray2 == null) {
                throw new NoCredentialsEnteredException(null);
            }
            if (cArray2.length > 0) {
                cArray = cArray2;
                continue;
            }
            if (string2 != null) {
                cArray = string2.toCharArray();
                continue;
            }
            this.fErr.println(RESOURCE_BUNDLE_UTILITIES.getString("Message.EmptyReply", new Object[0]));
            this.fErr.flush();
        }
        return cArray;
    }

    private static final class WordwrapPrinter {
        private final PrintStream fPrintStream;
        private final int fLineWidth;

        public WordwrapPrinter(PrintStream printStream, int n) {
            this.fPrintStream = printStream;
            this.fLineWidth = n;
        }

        public void println(String string) {
            for (String string2 : WordwrapPrinter.wrap(string, this.fLineWidth)) {
                this.fPrintStream.println(string2);
            }
        }

        public void close() {
            this.fPrintStream.close();
        }

        public void flush() {
            this.fPrintStream.flush();
        }

        private static List<String> wrap(String string, int n) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string2 : string.split("\n")) {
                int n2;
                do {
                    int n3;
                    if ((n2 = string2.length()) >= n && (n3 = string2.lastIndexOf(" ", n)) >= 0) {
                        n2 = n3;
                    }
                    linkedList.add(string2.substring(0, n2));
                } while ((string2 = string2.substring(n2).trim()).length() > 0);
            }
            return linkedList;
        }
    }
}

