/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.EOFException;
import java.util.concurrent.ConcurrentLinkedQueue;

class NonFatalErrorHandler
implements ErrorHandler {
    private ConcurrentLinkedQueue<Throwable> fErrors = new ConcurrentLinkedQueue();

    NonFatalErrorHandler() {
    }

    @Override
    public void readError(Instance instance, Throwable throwable) {
        this.addThrowable(throwable);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "NonFatalErrorHandler: readError from " + instance, throwable);
    }

    @Override
    public void writeError(Instance instance, Throwable throwable) {
        this.addThrowable(throwable);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "NonFatalErrorHandler: writeError to " + instance, throwable);
    }

    @Override
    public void lostCommunication(Instance instance, Throwable throwable) {
        this.addThrowable(throwable);
        if (throwable instanceof EOFException) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "NonFatalErrorHandler: lostCommunication to " + instance + " due to EOF");
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "NonFatalErrorHandler: lostCommunication to " + instance, throwable);
        }
    }

    @Override
    public void executorError(Throwable throwable) {
        this.addThrowable(throwable);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "NonFatalErrorHandler: executorError.", throwable);
    }

    @Override
    public void communicationError(Error error) {
        this.addThrowable(error);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "NonFatalErrorHandler: communicationError.", error);
    }

    @Override
    public void activate(ShutdownHandler shutdownHandler) {
    }

    @Override
    public void deactivate() {
    }

    public Throwable hasErrored() {
        return this.fErrors.peek();
    }

    private void addThrowable(Throwable throwable) {
        this.fErrors.add(throwable);
    }
}

