/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.service.PersistentServiceConfiguration;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class PersistentJobManagerConfiguration
extends PersistentServiceConfiguration {
    private long fMaxJobManagerHeapMemory;
    private int fMaxNumWorkers;
    private int fMaxNumClients;
    private int fMaxConcurrentResultSubmissions;
    private long fInvocationRetryIntervalMillis;
    private long fWorkerTimeoutIntervalMillis;
    private long fWorkerRenewalIntervalMillis;
    private int fJobManagerState;
    private String fDatabaseToUse;
    private String fDatabaseDirectory;
    private boolean fUseGDSStorage;
    private String fGDSEndPoint;
    private String fGDSLoginToken;
    private String fGDSQueueID;
    private boolean fAllowGlobalPasswordlessLogon;
    private boolean fAllowClientPasswordCache;
    private String fAdminUser;
    private String fAllowedUsers;
    private boolean fAllServerSocketsInCluster;
    private int fPeerSessionPort;
    private boolean fWorkerProxiesPoolConnections;
    private int fWorkerMatlabPoolMinPort;
    private int fWorkerMatlabPoolMaxPort;
    private boolean fSendActivityNotifications;
    private String fScriptRoot;
    private boolean fCancelRunningTasksOnStart;

    public PersistentJobManagerConfiguration(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        super(configuration, string);
    }

    @Override
    protected synchronized void initServiceInfo(Configuration configuration, String string) throws ConfigurationException {
        try {
            super.initServiceInfo(configuration, string);
            this.setMaxJobManagerHeapMemory(configuration, string);
            this.fMaxNumWorkers = (Integer)configuration.getEntry(string, "maxNumWorkers", Integer.TYPE);
            this.fMaxNumClients = (Integer)configuration.getEntry(string, "maxNumClients", Integer.TYPE);
            this.fInvocationRetryIntervalMillis = (Long)configuration.getEntry(string, "invocationRetryIntervalSecs", Long.TYPE) * 1000L;
            this.fWorkerTimeoutIntervalMillis = (Long)configuration.getEntry(string, "workerTimeoutIntervalSecs", Long.TYPE) * 1000L;
            this.fWorkerRenewalIntervalMillis = (Long)configuration.getEntry(string, "workerRenewalIntervalSecs", Long.TYPE) * 1000L;
            this.fMaxConcurrentResultSubmissions = (Integer)configuration.getEntry(string, "maxConcurrentResultSubmissions", Integer.TYPE);
            this.fJobManagerState = 0;
            this.fDatabaseToUse = (String)configuration.getEntry(string, "databaseToUse", String.class);
            this.fDatabaseDirectory = (String)configuration.getEntry(string, "databaseDirectory", String.class);
            this.fUseGDSStorage = (Boolean)configuration.getEntry(string, "useGDSStorage", Boolean.TYPE);
            this.fGDSEndPoint = (String)configuration.getEntry(string, "GDSEndPoint", String.class);
            this.fGDSLoginToken = (String)configuration.getEntry(string, "GDSLoginToken", String.class);
            this.fGDSQueueID = (String)configuration.getEntry(string, "GDSQueueID", String.class);
            this.fAllowGlobalPasswordlessLogon = Boolean.valueOf((String)configuration.getEntry(string, "mdceAllowGlobalPasswordlessLogon", String.class));
            this.fAllowClientPasswordCache = Boolean.valueOf((String)configuration.getEntry(string, "allowClientPasswordCache", String.class));
            this.fAdminUser = (String)configuration.getEntry(string, "adminUser", String.class);
            this.fAllowedUsers = (String)configuration.getEntry(string, "allowedUsers", String.class);
            this.fAllServerSocketsInCluster = (Boolean)configuration.getEntry(string, "allServerSocketsInCluster", Boolean.TYPE);
            this.fPeerSessionPort = (Integer)configuration.getEntry(string, "peerSessionPort", Integer.TYPE);
            this.fWorkerProxiesPoolConnections = (Boolean)configuration.getEntry(string, "workerProxiesPoolConnections", Boolean.TYPE);
            this.fWorkerMatlabPoolMinPort = (Integer)configuration.getEntry(string, "workerMatlabPoolMinPort", Integer.TYPE);
            this.fWorkerMatlabPoolMaxPort = (Integer)configuration.getEntry(string, "workerMatlabPoolMaxPort", Integer.TYPE);
            this.fSendActivityNotifications = (Boolean)configuration.getEntry(string, "sendActivityNotifications", Boolean.TYPE);
            this.fScriptRoot = (String)configuration.getEntry(string, "scriptRoot", String.class);
            this.fCancelRunningTasksOnStart = (Boolean)configuration.getEntry(string, "cancelRunningTasks", Boolean.TYPE);
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationException("Invalid job manager configuration. Check the mdce_def file and the \ncommand line flags.", (Throwable)configurationException);
        }
    }

    synchronized int getJobManagerState() {
        return this.fJobManagerState;
    }

    synchronized long getInvocationRetryInterval() {
        return this.fInvocationRetryIntervalMillis;
    }

    synchronized long getMaxJobManagerHeapMemory() {
        return this.fMaxJobManagerHeapMemory;
    }

    synchronized int getMaxNumberOfCallers() {
        return this.fMaxNumClients + this.fMaxNumWorkers;
    }

    synchronized long getWorkerTimeoutIntervalMillis() {
        return this.fWorkerTimeoutIntervalMillis;
    }

    synchronized long getWorkerRenewalIntervalMillis() {
        return this.fWorkerRenewalIntervalMillis;
    }

    synchronized int getMaxConcurrentResultSubmissions() {
        return this.fMaxConcurrentResultSubmissions;
    }

    synchronized String getDatabaseToUse() {
        return this.fDatabaseToUse;
    }

    synchronized String getDatabaseDirectory() {
        return this.fDatabaseDirectory;
    }

    synchronized boolean useGDSStorage() {
        return this.fUseGDSStorage;
    }

    synchronized String getGDSEndPoint() {
        return this.fGDSEndPoint;
    }

    synchronized String getGDSLoginToken() {
        return this.fGDSLoginToken;
    }

    synchronized String getGDSQueueID() {
        return this.fGDSQueueID;
    }

    synchronized boolean allowGlobalPasswordlessLogon() {
        return this.fAllowGlobalPasswordlessLogon;
    }

    synchronized boolean allowClientPasswordCache() {
        return this.fAllowClientPasswordCache;
    }

    synchronized String getAdminUser() {
        return this.fAdminUser;
    }

    synchronized String getAllowedUsers() {
        return this.fAllowedUsers;
    }

    synchronized void setJobManagerState(int n) throws PersistenceDirException {
        this.fJobManagerState = n;
        this.snapshot();
    }

    synchronized boolean allServerSocketsInCluster() {
        return this.fAllServerSocketsInCluster;
    }

    synchronized int getPeerSessionPort() {
        return this.fPeerSessionPort;
    }

    boolean getWorkerProxiesPoolConnections() {
        return this.fWorkerProxiesPoolConnections;
    }

    synchronized int getWorkerMatlabPoolMinPort() {
        return this.fWorkerMatlabPoolMinPort;
    }

    synchronized int getWorkerMatlabPoolMaxPort() {
        return this.fWorkerMatlabPoolMaxPort;
    }

    synchronized boolean isSendingActivityNotifications() {
        return this.fSendActivityNotifications;
    }

    synchronized String getScriptRoot() {
        return this.fScriptRoot;
    }

    synchronized boolean getCancelRunningTasksOnStart() {
        return this.fCancelRunningTasksOnStart;
    }

    @Override
    public synchronized void recover(InputStream inputStream) throws Exception {
        super.recover(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.fMaxJobManagerHeapMemory = (Long)objectInputStream.readObject();
        this.fMaxNumWorkers = (Integer)objectInputStream.readObject();
        this.fMaxNumClients = (Integer)objectInputStream.readObject();
        this.fInvocationRetryIntervalMillis = (Long)objectInputStream.readObject();
        this.fWorkerTimeoutIntervalMillis = (Long)objectInputStream.readObject();
        this.fWorkerRenewalIntervalMillis = (Long)objectInputStream.readObject();
        this.fJobManagerState = (Integer)objectInputStream.readObject();
        this.fMaxConcurrentResultSubmissions = (Integer)objectInputStream.readObject();
        this.fDatabaseToUse = (String)objectInputStream.readObject();
        this.fDatabaseDirectory = (String)objectInputStream.readObject();
        this.fUseGDSStorage = (Boolean)objectInputStream.readObject();
        this.fGDSEndPoint = (String)objectInputStream.readObject();
        this.fGDSLoginToken = (String)objectInputStream.readObject();
        this.fGDSQueueID = (String)objectInputStream.readObject();
        this.fAllowGlobalPasswordlessLogon = (Boolean)objectInputStream.readObject();
        this.fAllowClientPasswordCache = (Boolean)objectInputStream.readObject();
        this.fAdminUser = (String)objectInputStream.readObject();
        this.fAllowedUsers = (String)objectInputStream.readObject();
        this.fAllServerSocketsInCluster = (Boolean)objectInputStream.readObject();
        this.fPeerSessionPort = (Integer)objectInputStream.readObject();
        this.fWorkerProxiesPoolConnections = (Boolean)objectInputStream.readObject();
        this.fWorkerMatlabPoolMinPort = (Integer)objectInputStream.readObject();
        this.fWorkerMatlabPoolMaxPort = (Integer)objectInputStream.readObject();
        this.fSendActivityNotifications = (Boolean)objectInputStream.readObject();
        this.fScriptRoot = (String)objectInputStream.readObject();
        this.fCancelRunningTasksOnStart = (Boolean)objectInputStream.readObject();
    }

    @Override
    public synchronized void snapshot(OutputStream outputStream) throws Exception {
        super.snapshot(outputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this.fMaxJobManagerHeapMemory);
        objectOutputStream.writeObject(this.fMaxNumWorkers);
        objectOutputStream.writeObject(this.fMaxNumClients);
        objectOutputStream.writeObject(this.fInvocationRetryIntervalMillis);
        objectOutputStream.writeObject(this.fWorkerTimeoutIntervalMillis);
        objectOutputStream.writeObject(this.fWorkerRenewalIntervalMillis);
        objectOutputStream.writeObject(this.fJobManagerState);
        objectOutputStream.writeObject(this.fMaxConcurrentResultSubmissions);
        objectOutputStream.writeObject(this.fDatabaseToUse);
        objectOutputStream.writeObject(this.fDatabaseDirectory);
        objectOutputStream.writeObject(this.fUseGDSStorage);
        objectOutputStream.writeObject(this.fGDSEndPoint);
        objectOutputStream.writeObject(this.fGDSLoginToken);
        objectOutputStream.writeObject(this.fGDSQueueID);
        objectOutputStream.writeObject(this.fAllowGlobalPasswordlessLogon);
        objectOutputStream.writeObject(this.fAllowClientPasswordCache);
        objectOutputStream.writeObject(this.fAdminUser);
        objectOutputStream.writeObject(this.fAllowedUsers);
        objectOutputStream.writeObject(this.fAllServerSocketsInCluster);
        objectOutputStream.writeObject(this.fPeerSessionPort);
        objectOutputStream.writeObject(this.fWorkerProxiesPoolConnections);
        objectOutputStream.writeObject(this.fWorkerMatlabPoolMinPort);
        objectOutputStream.writeObject(this.fWorkerMatlabPoolMaxPort);
        objectOutputStream.writeObject(this.fSendActivityNotifications);
        objectOutputStream.writeObject(this.fScriptRoot);
        objectOutputStream.writeObject(this.fCancelRunningTasksOnStart);
        objectOutputStream.flush();
    }

    private void setMaxJobManagerHeapMemory(Configuration configuration, String string) throws ConfigurationException {
        String string2 = (String)configuration.getEntry(string, "maxJobManagerHeapMemory", String.class);
        long l = this.isMemoryOfLargeUnit(string2 = string2.trim(), 'K') ? this.convertLargeUnitToBytes(string2, 10L) : (this.isMemoryOfLargeUnit(string2, 'M') ? this.convertLargeUnitToBytes(string2, 20L) : (this.isMemoryOfLargeUnit(string2, 'G') ? this.convertLargeUnitToBytes(string2, 30L) : Long.parseLong(string2)));
        this.fMaxJobManagerHeapMemory = l;
    }

    private boolean isMemoryOfLargeUnit(String string, char c) {
        return string.indexOf(Character.toLowerCase(c)) == string.length() - 1 || string.indexOf(Character.toUpperCase(c)) == string.length() - 1;
    }

    private long convertLargeUnitToBytes(String string, long l) {
        string = string.substring(0, string.length() - 1);
        return Long.parseLong(string) * (long)StrictMath.pow(2.0, l);
    }
}

