/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorage;
import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.messages.SimpleCancelMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.jini.id.Uuid;

public final class WorkUnitTimeoutChecker {
    private static WorkUnitTimeoutChecker sWorkUnitTimeoutChecker = null;
    private static Thread sCheckerThread = null;
    private final WorkUnitStorage fStorage;
    private final TimeProvider fTimeProvider;
    private final ReentrantLock fLock = new ReentrantLock();
    private final Condition fWorkUnitAddedOrTerminated = this.fLock.newCondition();
    private boolean fTerminated = false;
    private final HashMap<Uuid, WorkUnitTimeout> fWorkUnitTimeouts = new HashMap();

    public WorkUnitTimeoutChecker(WorkUnitStorage workUnitStorage) {
        this.fStorage = workUnitStorage;
        this.fTimeProvider = new SystemTimeProvider();
    }

    public WorkUnitTimeoutChecker(WorkUnitStorage workUnitStorage, TimeProvider timeProvider) {
        this.fStorage = workUnitStorage;
        this.fTimeProvider = timeProvider;
    }

    static synchronized void init(WorkUnitStorage workUnitStorage) {
        if (sWorkUnitTimeoutChecker == null) {
            sWorkUnitTimeoutChecker = new WorkUnitTimeoutChecker(workUnitStorage);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    sWorkUnitTimeoutChecker.check();
                }
            };
            sCheckerThread = new Thread(runnable, "WorkUnitTimeoutChecker");
            sCheckerThread.setDaemon(true);
            sCheckerThread.start();
        }
    }

    static synchronized void clear() {
        if (sWorkUnitTimeoutChecker != null) {
            sWorkUnitTimeoutChecker.terminate();
            try {
                sCheckerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sWorkUnitTimeoutChecker = null;
        }
    }

    public static synchronized WorkUnitTimeoutChecker instance() {
        return sWorkUnitTimeoutChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkUnit(Uuid uuid, long l) {
        this.fLock.lock();
        try {
            if (l != Long.MAX_VALUE) {
                this.fWorkUnitTimeouts.put(uuid, new WorkUnitTimeout(uuid, l));
            }
            this.fWorkUnitAddedOrTerminated.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkUnit(Uuid uuid) {
        this.fLock.lock();
        try {
            this.fWorkUnitTimeouts.remove(uuid);
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void check() {
        boolean bl = false;
        while (!bl) {
            bl = this.removeExpiredRegistrationsAndThenWaitOrCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeExpiredRegistrationsAndThenWaitOrCancel() {
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        this.fLock.lock();
        try {
            if (this.fTerminated) {
                boolean bl = true;
                return bl;
            }
            long l = Long.MAX_VALUE;
            long l2 = this.fTimeProvider.currentTimeMillis();
            long l3 = this.removeExpiredRegistrations(l2, arrayList);
            if (l3 < l) {
                l = l3;
            }
            if (arrayList.isEmpty()) {
                this.fWorkUnitAddedOrTerminated.await(l, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(Level.WARNING, "WorkUnitTimeoutChecker thread interrupted.", interruptedException);
            Thread.currentThread().interrupt();
        }
        finally {
            this.fLock.unlock();
        }
        for (Uuid uuid : arrayList) {
            try {
                this.cancelWorkUnit(uuid);
            }
            catch (MJSException mJSException) {
                PackageInfo.LOGGER.log(DistcompLevel.SEVERE, "Failed to cancel work unit", mJSException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        this.fLock.lock();
        try {
            this.fTerminated = true;
            this.fWorkUnitAddedOrTerminated.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private long removeExpiredRegistrations(long l, List<Uuid> list) {
        long l2 = Long.MAX_VALUE;
        Collection<WorkUnitTimeout> collection = this.fWorkUnitTimeouts.values();
        Iterator<WorkUnitTimeout> iterator = collection.iterator();
        while (iterator.hasNext()) {
            WorkUnitTimeout workUnitTimeout = iterator.next();
            if (workUnitTimeout.isExpired(l)) {
                list.add(workUnitTimeout.iWorkUnitID);
                iterator.remove();
                continue;
            }
            long l3 = workUnitTimeout.iStartTimeMillis + workUnitTimeout.iTimeoutMillis - l + 1L;
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    private void cancelWorkUnit(Uuid uuid) throws MJSException {
        try {
            WorkUnitImpl workUnitImpl = this.fStorage.readWorkUnit(uuid);
            long l = workUnitImpl.getTimeout() / 1000L;
            String string = workUnitImpl.workUnitTypeForPrinting();
            if (workUnitImpl instanceof TaskImpl) {
                workUnitImpl.rerunOrCancel(new WorkUnitTimeoutMessage(string, l));
            } else {
                workUnitImpl.cancel(new WorkUnitTimeoutMessage(string, l));
            }
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            // empty catch block
        }
    }

    private class WorkUnitTimeout {
        private Uuid iWorkUnitID;
        private long iTimeoutMillis;
        private long iStartTimeMillis;

        WorkUnitTimeout(Uuid uuid, long l) {
            this.iWorkUnitID = uuid;
            this.iTimeoutMillis = l;
            this.iStartTimeMillis = WorkUnitTimeoutChecker.this.fTimeProvider.currentTimeMillis();
        }

        public boolean isExpired(long l) {
            long l2 = l - this.iStartTimeMillis;
            return l2 > this.iTimeoutMillis;
        }
    }

    private static class WorkUnitTimeoutMessage
    extends SimpleCancelMessage {
        WorkUnitTimeoutMessage(String string, long l) {
            super((BaseMsgID)new mjs.WorkUnitTimeout(string, string, Long.toString(l)));
        }
    }
}

