/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractLocalCommand;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.distcomp.local.TokenChangeCommand;
import com.mathworks.toolbox.distcomp.local.TokenManager;
import com.mathworks.toolbox.distcomp.util.PausableThreadPoolExecutor;
import com.mathworks.toolbox.distcomp.util.ProcessBuilderUtils;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.concurrent.WaitForTurnQueue;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class LocalScheduler {
    private static LocalScheduler sLocalScheduler = null;
    private static int sFACTORY_MAX_NUM_WORKERS = 512;
    private final TokenManager fTokenManager = new TokenManager(512);
    private final CommandDelayer fCommandDelayer = new CommandDelayer();
    private final PausableThreadPoolExecutor fDispatchExecutor = new PausableThreadPoolExecutor(512, 512, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)LocalScheduler.class.getSimpleName(), (Logger)PackageInfo.LOGGER));
    private ConcurrentHashMap<UUID, AbstractLocalCommand> fCommandMap = new ConcurrentHashMap();
    private int fMaximumNumberOfWorkers;
    private final WaitForTurnQueue<Callable<Object>> fTurnQueue = new WaitForTurnQueue();

    public static void setFactoryMaxNumWorkers(int n) {
        if (n > 512 || n < 1) {
            throw new IllegalStateException("Incorrect number of licenses requested");
        }
        sFACTORY_MAX_NUM_WORKERS = n;
    }

    public static synchronized LocalScheduler getInstance() {
        if (sLocalScheduler == null) {
            sLocalScheduler = new LocalScheduler();
            sLocalScheduler.setMaximumNumberOfWorkers(sFACTORY_MAX_NUM_WORKERS);
        }
        return sLocalScheduler;
    }

    public int getMaximumNumberOfWorkers() {
        return this.fMaximumNumberOfWorkers;
    }

    public void setMaximumNumberOfWorkers(int n) {
        if (n > 512) {
            throw new IllegalStateException("Too many licenses requested");
        }
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "LocalScheduler.setMaximumNumberOfWorkers from " + this.fMaximumNumberOfWorkers + " to " + n);
        this.fMaximumNumberOfWorkers = n;
        this.submitInOrder(new TokenChangeCommand(this.fTokenManager, n, this));
    }

    public int getNumberOfAvailableLicenses() {
        return this.fTokenManager.getNumberOfAvailableTokens();
    }

    public TokenManager.SemaphoreToken acquire(AbstractLocalCommand abstractLocalCommand, int n) throws InterruptedException, WaitForTurnQueue.TurnAbandonedException {
        return this.acquire(abstractLocalCommand, n, n);
    }

    public TokenManager.SemaphoreToken acquire(AbstractLocalCommand abstractLocalCommand, int n, int n2) throws InterruptedException, WaitForTurnQueue.TurnAbandonedException {
        try (WaitForTurnQueue.TurnCloser turnCloser = this.fTurnQueue.getTurn((Object)abstractLocalCommand);){
            TokenManager.SemaphoreToken semaphoreToken = this.fTokenManager.acquire(n, n2);
            return semaphoreToken;
        }
    }

    public WaitForTurnQueue.TurnCloser acquireTokenManagerLock(Callable<Object> callable) throws WaitForTurnQueue.TurnAbandonedException {
        return this.fTurnQueue.getTurn(callable);
    }

    public void pause() {
        this.fDispatchExecutor.pause();
    }

    public synchronized void resume() {
        this.fDispatchExecutor.resume();
    }

    public void cancel(Callable<Object> callable) {
        this.fTurnQueue.turnAbandoned(callable);
    }

    Future<Object> submit(AbstractLocalCommand abstractLocalCommand) {
        return this.submitInOrder(abstractLocalCommand);
    }

    private Future<Object> submitInOrder(Callable<Object> callable) {
        this.fTurnQueue.reserveTurn(callable);
        return this.fDispatchExecutor.submit(callable);
    }

    void addCommand(UUID uUID, AbstractLocalCommand abstractLocalCommand) {
        this.fCommandMap.put(uUID, abstractLocalCommand);
    }

    public AbstractLocalCommand getCommand(UUID uUID) {
        return this.fCommandMap.get(uUID);
    }

    boolean removeCommand(UUID uUID) {
        return this.fCommandMap.remove(uUID) != null;
    }

    private CommandDelayer getDelayer() {
        return this.fCommandDelayer;
    }

    public void delayBeforeStart() throws InterruptedException {
        this.getDelayer().delayBeforeStart();
    }

    public void setCommandDelay(long l) {
        this.getDelayer().setDelay(l);
    }

    public long getCommandDelay() {
        return this.getDelayer().getDelay();
    }

    public ProcessBuilderUtils.Delayer getDelayerForProcessConstruction() {
        return this.getDelayer();
    }

    private static class CommandDelayer
    implements ProcessBuilderUtils.Delayer {
        private long fDelay = 0L;
        private long fLastCommandTime = -1L;
        private ReentrantLock fLock = new ReentrantLock();

        private CommandDelayer() {
        }

        @Override
        public void delay() throws InterruptedException {
            this.delayBeforeStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delayBeforeStart() throws InterruptedException {
            block9: {
                if (this.fDelay == 0L) {
                    return;
                }
                this.fLock.lockInterruptibly();
                try {
                    if (this.fLastCommandTime <= 0L) break block9;
                    Object object = new Object();
                    long l = this.fDelay;
                    long l2 = this.fLastCommandTime;
                    Object object2 = object;
                    synchronized (object2) {
                        long l3 = l - (System.currentTimeMillis() - l2);
                        while (l3 > 0L) {
                            if (l3 > 0L) {
                                object.wait(l3);
                            }
                            l3 = l - (System.currentTimeMillis() - l2);
                        }
                    }
                }
                finally {
                    this.fLastCommandTime = System.currentTimeMillis();
                    this.fLock.unlock();
                }
            }
        }

        void setDelay(long l) {
            this.fDelay = l;
        }

        long getDelay() {
            return this.fDelay;
        }
    }
}

