/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractExecutableCommand;
import com.mathworks.toolbox.distcomp.local.AbstractLocalCommand;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.distcomp.local.ProcessUtilities;
import com.mathworks.toolbox.distcomp.local.SmpdDaemonManager;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.util.PlatformInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public final class MpiexecJobCommand
extends AbstractExecutableCommand {
    private static final String sCONFIGFILE_OPTION = "-configfile";
    private static final String sHOST_LOCATION_OPTION = "-hosts 1 127.0.0.1";
    private static final String sPORT_ARGUMENT = "-port";
    private Process fProcess;
    private List<String> fMpiexecArgs = new Vector<String>();
    private List<String> fCommandArgs = new Vector<String>();
    private File fMpiexecConfigFile;

    public static MpiexecJobCommand getNewInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, String string2, int[] nArray) throws IOException {
        if (nArray == null || nArray.length != 2) {
            throw new IllegalStateException("Invalid number of workers argument supplied");
        }
        MpiexecJobCommand mpiexecJobCommand = new MpiexecJobCommand(stringArray, stringArray2, stringArray3, stringArray4, string, string2, nArray[0], nArray[1]);
        MpiexecJobCommand.addCommandToScheduler(mpiexecJobCommand);
        return mpiexecJobCommand;
    }

    private MpiexecJobCommand(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, String string2, int n, int n2) throws IOException {
        super(new String[]{stringArray[0]}, stringArray3, stringArray4, string2, n, n2);
        this.fMpiexecArgs.addAll(Arrays.asList(stringArray).subList(1, stringArray.length));
        Collections.addAll(this.fCommandArgs, stringArray2);
        this.fMpiexecConfigFile = new File(string, "mpiexecconfig");
        boolean bl = this.fMpiexecConfigFile.createNewFile();
        assert (bl) : "Unexpectedly found mpiexecconfig file already existing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigFile(int n, int n2) throws IOException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "MpiexecJobCommand.writeConfigFile() entry");
        assert (n2 > 0);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fMpiexecConfigFile), Charset.forName("US-ASCII")));
        try {
            bufferedWriter.write("-port " + n + " ");
            for (String string : this.fMpiexecArgs) {
                bufferedWriter.write(string);
                bufferedWriter.write(" ");
            }
            bufferedWriter.write("-hosts 1 127.0.0.1 " + n2 + " ");
            for (String string : this.fCommandArgs) {
                if (string.matches(".*\\s+.*")) {
                    bufferedWriter.write("\"" + string + "\" ");
                } else {
                    bufferedWriter.write(string);
                }
                bufferedWriter.write(" ");
            }
        }
        finally {
            bufferedWriter.close();
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "MpiexecJobCommand.writeConfigFile() exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndRunProcess() throws IOException, InterruptedException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.fLogFile, true);
        try {
            this.fProcess = this.createProcessFromBuilderWithRetry();
            try {
                if (PlatformInfo.isWindows()) {
                    this.fProcess.getOutputStream().close();
                }
                ProcessUtilities.waitForProcessWithRedirection(this.fProcess, this.getStreamRedirector(), fileOutputStream, "");
            }
            finally {
                this.fProcess.destroy();
            }
        }
        finally {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    @Override
    public Object onRun(int n) throws Exception {
        SmpdDaemonManager smpdDaemonManager = SmpdDaemonManager.getManager();
        int n2 = smpdDaemonManager.getPortAndIncrementUsage();
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "MpiexecJobCommand.onRun() got spmd port: " + n2);
        try {
            this.writeConfigFile(n2, n);
            List<String> list = this.fProcessBuilder.command();
            list.add(sCONFIGFILE_OPTION);
            list.add(this.fMpiexecConfigFile.getPath());
            this.createAndRunProcess();
            Object var5_8 = null;
            return var5_8;
        }
        catch (InterruptedException interruptedException) {
            Object var5_9 = null;
            return var5_9;
        }
        catch (Exception exception) {
            if (this.isDestroyed() || Thread.currentThread().isInterrupted()) {
                Object var5_10 = null;
                return var5_10;
            }
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Unexpected exception running job.", exception);
            throw exception;
        }
        catch (Error error) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Unexpected error running job.", error);
            throw error;
        }
        finally {
            smpdDaemonManager.releaseUsage();
        }
    }

    @Override
    protected synchronized AbstractLocalCommand.State getStateEnum() {
        if (this.isDone()) {
            if (this.isCancelled()) {
                return AbstractLocalCommand.State.CANCELLED_STATE;
            }
            if (this.fProcess == null || this.fProcess.exitValue() != 0) {
                return AbstractLocalCommand.State.FAILED_STATE;
            }
            return AbstractLocalCommand.State.FINISHED_STATE;
        }
        return super.getStateEnum();
    }
}

