/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerlookupservice;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerConnectorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.JobManagerLookupRequest;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.Log;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.PeerLookupService;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupExceptionResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupRequest;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.ServiceLookupSucceededResponse;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.WorkerLookupRequest;
import com.mathworks.toolbox.distcomp.pmode.FatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.io.DirectCommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageFuture;
import com.mathworks.toolbox.distcomp.pmode.shared.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.UnresolvableLookupURLException;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.AccessorException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;

public final class PeerLookupAccessor
implements Accessor {
    private static final AtomicLong SEQUENCE_NUMBER_SOURCE = new AtomicLong(0L);
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private final PeerInstance fLocalInstance;
    private final InetSocketAddress fLookupServiceAddress;
    private final ServerSocketConnectInfo fConnectInfo;
    private long fLookupTimeoutSeconds = 30L;

    public PeerLookupAccessor(String string, int n) throws AccessorException {
        this(new InetSocketAddress(string, n), true);
    }

    public PeerLookupAccessor(InetSocketAddress inetSocketAddress, boolean bl) throws PeerLookupAccessorException {
        ConnectorSecurityDescription connectorSecurityDescription;
        this.fLookupServiceAddress = inetSocketAddress;
        this.fLocalInstance = new PeerInstance(ProtocolId.MJS, PeerLookupService.LOOKUP_SERVICE_GROUP_UUID, UUID.randomUUID());
        if (bl) {
            boolean bl2 = true;
            connectorSecurityDescription = new JobManagerConnectorSSLSecurityDescription(bl2);
        } else {
            connectorSecurityDescription = new ConnectorPlainSecurityDescription();
        }
        this.fConnectInfo = ServerSocketConnectInfo.createServerSocketConnectInfo(DirectCommunicationGroup.class, this.fLookupServiceAddress, this.fLocalInstance.getGroupUuid(), connectorSecurityDescription, 60000L, Long.MAX_VALUE, 5);
    }

    public PeerLookupAccessor(String string) throws PeerLookupAccessorException {
        this(PeerLookupAccessor.urlToInetSocketAddress(string), true);
    }

    private static InetSocketAddress urlToInetSocketAddress(String string) throws BadLookupServiceURI {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new BadLookupServiceURI(string, uRISyntaxException);
        }
        if (uRI.getHost() == null) {
            throw new BadLookupServiceURI(string);
        }
        if (uRI.getPort() == -1) {
            throw new BadLookupServiceURI(string);
        }
        if (uRI.getScheme() == null || !PeerLookupService.isPeerLookupScheme(uRI)) {
            throw new BadLookupServiceURI(string);
        }
        return new InetSocketAddress(uRI.getHost(), uRI.getPort());
    }

    public void setLookupTimeoutSeconds(long l) {
        this.fLookupTimeoutSeconds = l;
    }

    private PeerSession createSession(PeerInstance peerInstance) {
        List<Connection> list = Collections.emptyList();
        Set<PeerDispatcher<? extends Message>> set = Collections.emptySet();
        return new PeerSession(this.fConnectInfo, peerInstance, new FatalErrorHandler(false), set, list);
    }

    private Connection connectToLookupService() throws HandShake.HandShakeException, PeerConnector.CouldNotConnectException {
        PeerConnector peerConnector = new PeerConnector();
        return peerConnector.activelyConnectTo(this.fConnectInfo, this.fLocalInstance);
    }

    private Instance connectToLookupServiceInstance(PeerSession peerSession) throws PeerLookupAccessorException, UnresolvableLookupURLException {
        Connection connection;
        try {
            connection = this.connectToLookupService();
        }
        catch (PeerConnector.CouldNotConnectUnknownHostException couldNotConnectUnknownHostException) {
            throw new UnresolvableLookupURLException(this.getLookupServiceURI().toString(), this.getLookupServiceURI().getHost(), couldNotConnectUnknownHostException);
        }
        catch (HandShake.VersionMismatchException versionMismatchException) {
            throw new PeerLookupVersionMismatchException(this.getLookupServiceURI(), versionMismatchException);
        }
        catch (PeerMessagingException peerMessagingException) {
            if (peerMessagingException.getCause() instanceof SSLException) {
                throw new RequiredCertificateNotProvidedException(this.getLookupServiceURI(), (Throwable)peerMessagingException);
            }
            throw new CannotConnectToLookupServiceException(this.getLookupServiceURI(), (Throwable)peerMessagingException);
        }
        try {
            peerSession.addConnection(connection);
        }
        catch (RuntimeException runtimeException) {
            this.safeCloseConnection(connection);
            throw new CannotConnectToLookupServiceException(this.getLookupServiceURI(), (Throwable)runtimeException);
        }
        return connection.getRemoteInstance();
    }

    private void safeCloseConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (IOException iOException) {
            Log.LOGGER.log(DistcompLevel.TWO, "Failed to close connection to lookup service", iOException);
        }
    }

    @Override
    public Object[] getJobManagers(String string) throws AccessorException {
        JobManagerLookupRequest jobManagerLookupRequest = new JobManagerLookupRequest(SEQUENCE_NUMBER_SOURCE.getAndIncrement(), string);
        return this.makeRequest(jobManagerLookupRequest);
    }

    @Override
    public Object[] getMLWorkers(String string) throws AccessorException {
        WorkerLookupRequest workerLookupRequest = new WorkerLookupRequest(SEQUENCE_NUMBER_SOURCE.getAndIncrement(), string);
        return this.makeRequest(workerLookupRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] makeRequest(ServiceLookupRequest serviceLookupRequest) throws PeerLookupAccessorException, UnresolvableLookupURLException {
        PeerSession peerSession = this.createSession(this.fLocalInstance);
        try {
            Object[] objectArray = this.connectSendAndWait(peerSession, serviceLookupRequest);
            return objectArray;
        }
        finally {
            peerSession.normalShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] connectSendAndWait(PeerSession peerSession, ServiceLookupRequest serviceLookupRequest) throws PeerLookupAccessorException, UnresolvableLookupURLException {
        Instance instance = this.connectToLookupServiceInstance(peerSession);
        try {
            Object[] objectArray = this.sendRequestAndWaitForResponse(peerSession, instance, serviceLookupRequest);
            return objectArray;
        }
        finally {
            peerSession.removeInstance(instance);
        }
    }

    private Object[] sendRequestAndWaitForResponse(PeerSession peerSession, Instance instance, ServiceLookupRequest serviceLookupRequest) throws PeerLookupAccessorException {
        ObservableMessageFuture<ServiceLookupResponse> observableMessageFuture = new ObservableMessageFuture<ServiceLookupResponse>(ServiceLookupResponse.class);
        peerSession.getOutputGroup().sendTo(instance, (ObservableMessage)serviceLookupRequest, observableMessageFuture);
        try {
            ServiceLookupResponse serviceLookupResponse = (ServiceLookupResponse)observableMessageFuture.get(this.fLookupTimeoutSeconds, TimeUnit.SECONDS);
            if (serviceLookupResponse instanceof ServiceLookupSucceededResponse) {
                ServiceLookupSucceededResponse serviceLookupSucceededResponse = (ServiceLookupSucceededResponse)serviceLookupResponse;
                return serviceLookupSucceededResponse.getServices();
            }
            if (serviceLookupResponse instanceof ServiceLookupExceptionResponse) {
                ServiceLookupExceptionResponse serviceLookupExceptionResponse = (ServiceLookupExceptionResponse)serviceLookupResponse;
                throw new RemoteLookupServiceException(this.getLookupServiceURI(), serviceLookupExceptionResponse.getAccessorException());
            }
            Log.LOGGER.log(DistcompLevel.ONE, "Unexpected response type: " + serviceLookupResponse.getClass());
            throw new IllegalStateException("Unexpected response type: " + serviceLookupResponse.getClass());
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupAccessor: Interrupted while waiting for response.");
            return EMPTY_OBJ_ARRAY;
        }
        catch (ExecutionException executionException) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupAccessor: ExecutionException while handling response.", executionException);
            return EMPTY_OBJ_ARRAY;
        }
        catch (TimeoutException timeoutException) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupAccessor: Timed out while waiting for response.");
            throw new LookupTimedOutException(this.getLookupServiceURI());
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PeerLookupAccessor peerLookupAccessor = (PeerLookupAccessor)object;
        boolean bl2 = this.fLookupServiceAddress != null;
        boolean bl3 = bl = peerLookupAccessor.fLookupServiceAddress != null;
        return bl2 ? this.fLookupServiceAddress.equals(peerLookupAccessor.fLookupServiceAddress) : !bl;
    }

    public int hashCode() {
        return this.fLookupServiceAddress != null ? this.fLookupServiceAddress.hashCode() : 0;
    }

    public String toString() {
        return "PeerLookupAccessor{" + this.getLookupServiceURI() + '}';
    }

    private URI getLookupServiceURI() {
        return PeerLookupService.createLookupServiceURI(this.fLookupServiceAddress.getHostName(), this.fLookupServiceAddress.getPort());
    }

    public static boolean isPeerLookupUrl(String string) {
        try {
            URI uRI = new URI(string);
            return PeerLookupService.isPeerLookupScheme(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private static final class LookupTimedOutException
    extends PeerLookupAccessorException {
        private final BaseMsgID fMessage;

        LookupTimedOutException(URI uRI) {
            this.fMessage = new mjs.LookupTimedOut(uRI.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessage;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessage;
        }
    }

    public static final class RemoteLookupServiceException
    extends PeerLookupAccessorException {
        private final URI fLookupServiceURI;

        public RemoteLookupServiceException(URI uRI, AccessorException accessorException) {
            this.fLookupServiceURI = uRI;
            this.initCause(accessorException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.ExceptionFromRemoteLookupService(this.fLookupServiceURI.toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.ExceptionFromRemoteLookupService(this.fLookupServiceURI.toString(), this.getCause().getLocalizedMessage());
        }
    }

    public static final class CannotConnectToLookupServiceException
    extends PeerLookupAccessorException {
        private final BaseMsgID fMessage;

        public CannotConnectToLookupServiceException(URI uRI, Throwable throwable) {
            this.fMessage = new mjs.CannotConnectToLookupService(uRI.toString(), uRI.getHost());
            this.initCause(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessage;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessage;
        }
    }

    public static final class BadLookupServiceURI
    extends PeerLookupAccessorException {
        private final BaseMsgID fMessage;

        public BadLookupServiceURI(String string) {
            this.fMessage = new mjs.InvalidLookupServiceURI(string);
        }

        public BadLookupServiceURI(String string, Throwable throwable) {
            this.fMessage = new mjs.InvalidLookupServiceURI(string);
            this.initCause(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessage;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessage;
        }
    }

    public static final class RequiredCertificateNotProvidedException
    extends PeerLookupAccessorException {
        private final BaseMsgID fMessage;

        public RequiredCertificateNotProvidedException(URI uRI, Throwable throwable) {
            this.fMessage = new mjs.RequiredCertificateNotProvided(uRI.toString());
            this.initCause(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessage;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessage;
        }
    }

    private static final class PeerLookupVersionMismatchException
    extends PeerLookupAccessorException {
        private final BaseMsgID fMessage;

        private PeerLookupVersionMismatchException(URI uRI, HandShake.VersionMismatchException versionMismatchException) {
            this.fMessage = new mjs.VersionMismatch(uRI.toString(), versionMismatchException.getLocalVersion(), versionMismatchException.getRemoteVersion());
            this.initCause(versionMismatchException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessage;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessage;
        }
    }

    private static abstract class PeerLookupAccessorException
    extends AccessorException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();

        protected abstract BaseMsgID getFilledMessage();

        protected abstract BaseMsgID getFilledLocalizedMessage();

        protected PeerLookupAccessorException() {
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.getFilledLocalizedMessage());
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.getFilledMessage());
        }

        public String getMessageID() {
            return this.getFilledMessage().getCatalogId() + ":" + this.getFilledMessage().getMessageId();
        }
    }
}

