/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.lang.pool;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.EOFException;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

abstract class AbstractErrorHandler
implements SessionErrorHandler {
    private boolean fHasError;
    private FatalError fError;
    private boolean fHasBeenDeactivated;
    private ShutdownHandler fShutdownHandler;
    private final boolean fIsClient;
    private final SessionRoleMapping fMapping;
    private final AtomicBoolean fIsShuttingDown = new AtomicBoolean(false);
    private final ExecutorService fShutdownExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fShutdownExecutor-"), (Logger)PackageInfo.LOGGER));

    AbstractErrorHandler(boolean bl, @Nullable SessionRoleMapping sessionRoleMapping) {
        this.fIsClient = bl;
        this.fMapping = sessionRoleMapping;
    }

    @Override
    public final synchronized void deactivate() {
        this.fShutdownHandler = null;
        this.fHasBeenDeactivated = true;
    }

    private synchronized boolean setHandlerIfNoErrorSet(ShutdownHandler shutdownHandler) {
        boolean bl = this.fHasError;
        if (!bl) {
            assert (!this.fHasBeenDeactivated) : "Attempt to activate a handler after it has been deactivated";
            this.fShutdownHandler = shutdownHandler;
        }
        return bl;
    }

    @Override
    public final void activate(ShutdownHandler shutdownHandler) {
        boolean bl = this.setHandlerIfNoErrorSet(shutdownHandler);
        if (bl) {
            this.tryShutdown(shutdownHandler);
        }
    }

    protected FatalError buildExecutorError(Throwable throwable) {
        return AbstractErrorHandler.msgRuntimeError(throwable);
    }

    protected FatalError buildCommunicationError(Error error) {
        return AbstractErrorHandler.msgRuntimeError(error);
    }

    protected FatalError buildReadError(Instance instance, Throwable throwable) {
        ProcessInstance processInstance = this.maybeMapInstance(instance);
        FatalError fatalError = this.fIsClient ? (throwable instanceof EOFException ? AbstractErrorHandler.msgLostConnectionToLab(processInstance, throwable) : AbstractErrorHandler.msgReadErrorFromLab(processInstance, throwable)) : (throwable instanceof EOFException ? AbstractErrorHandler.msgLostConnectionToClient(throwable) : AbstractErrorHandler.msgReadErrorFromClient(throwable));
        return fatalError;
    }

    protected FatalError buildWriteError(Instance instance, Throwable throwable) {
        ProcessInstance processInstance = this.maybeMapInstance(instance);
        FatalError fatalError = this.fIsClient ? AbstractErrorHandler.msgWriteErrorToLab(processInstance, throwable) : AbstractErrorHandler.msgWriteErrorToClient(throwable);
        return fatalError;
    }

    protected FatalError buildLostCommunicationError(Instance instance, Throwable throwable) {
        ProcessInstance processInstance = this.maybeMapInstance(instance);
        FatalError fatalError = this.fIsClient ? AbstractErrorHandler.msgLostConnectionToLab(processInstance, throwable) : AbstractErrorHandler.msgLostConnectionToClient(throwable);
        return fatalError;
    }

    private synchronized ShutdownHandler setErrorAndGetHandler(FatalError fatalError) {
        if (this.fHasError || this.fHasBeenDeactivated) {
            return null;
        }
        this.fHasError = true;
        this.fError = fatalError;
        return this.fShutdownHandler;
    }

    protected void maybeShutDown(FatalError fatalError) {
        ShutdownHandler shutdownHandler = this.setErrorAndGetHandler(fatalError);
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "AbstractErrorHandler.maybeShutDown called with: " + fatalError.getMessage());
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Fatal Error, forcing a shutdown.", fatalError.getCause());
            this.tryShutdown(shutdownHandler);
        }
    }

    private ProcessInstance maybeMapInstance(Instance instance) {
        try {
            return this.fMapping == null ? null : this.fMapping.instanceToRole(instance);
        }
        catch (NoSuchDestinationException noSuchDestinationException) {
            return null;
        }
    }

    private synchronized FatalError getError() {
        if (this.fHasError) {
            return this.fError;
        }
        return null;
    }

    private void tryShutdown(final ShutdownHandler shutdownHandler) {
        assert (shutdownHandler != null) : "Shutdown handler was null during a call to tryShutdown";
        if (this.fIsShuttingDown.getAndSet(true)) {
            return;
        }
        final FatalError fatalError = this.getError();
        assert (fatalError != null) : "tryShutdown was called without an error";
        this.fShutdownExecutor.execute(new Runnable(){

            @Override
            public void run() {
                shutdownHandler.forceShutdown(fatalError);
            }
        });
        this.fShutdownExecutor.shutdown();
    }

    private static FatalError msgLostConnectionToLab(ProcessInstance processInstance, Throwable throwable) {
        if (null == processInstance) {
            return new LostConnectionToAnUnknownLab(throwable);
        }
        return new LostConnectionToLab(processInstance.getLabIndex(), throwable);
    }

    private static FatalError msgReadErrorFromLab(ProcessInstance processInstance, Throwable throwable) {
        return new ReadErrorLostConnectionToLab(processInstance.getLabIndex(), throwable);
    }

    private static FatalError msgLostConnectionToClient(Throwable throwable) {
        return new LostConnectionToClient(throwable);
    }

    private static FatalError msgReadErrorFromClient(Throwable throwable) {
        return new ReadErrorLostConnectionToClient(throwable);
    }

    private static FatalError msgWriteErrorToLab(ProcessInstance processInstance, Throwable throwable) {
        return new WriteErrorLostConnectionToLab(processInstance.getLabIndex(), throwable);
    }

    private static FatalError msgWriteErrorToClient(Throwable throwable) {
        return new WriteErrorLostConnectionToClient(throwable);
    }

    private static FatalError msgRuntimeError(Throwable throwable) {
        return new InternalRuntimeError(throwable);
    }

    private static boolean isValidI18nMatlabIdentifiedException(Throwable throwable) {
        return throwable != null && throwable instanceof I18nMatlabIdentifiedException;
    }

    private static final class LostConnectionToLab
    extends FatalError {
        private final int fWorkerIndex;

        private LostConnectionToLab(int n, Throwable throwable) {
            super(throwable);
            this.fWorkerIndex = n;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.LostWorkerWithCause(Integer.toString(this.fWorkerIndex), throwable.getMessage()) : new pool.LostWorker(Integer.toString(this.fWorkerIndex));
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.LostWorkerWithCause(Integer.toString(this.fWorkerIndex), throwable.getLocalizedMessage()) : new pool.LostWorker(Integer.toString(this.fWorkerIndex));
        }
    }

    private static final class LostConnectionToAnUnknownLab
    extends FatalError {
        private LostConnectionToAnUnknownLab(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.LostAnUnknownWorkerWithCause(throwable.getMessage()) : new pool.LostAnUnknownWorker();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.LostAnUnknownWorkerWithCause(throwable.getLocalizedMessage()) : new pool.LostAnUnknownWorker();
        }
    }

    private static final class LostConnectionToClient
    extends FatalError {
        private LostConnectionToClient(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.LostClientWithCause(throwable.getMessage()) : new pool.LostClient();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.LostClientWithCause(throwable.getLocalizedMessage()) : new pool.LostClient();
        }
    }

    private static final class WriteErrorLostConnectionToClient
    extends FatalError {
        private WriteErrorLostConnectionToClient(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.WriteToClientErrorWithCause(throwable.getMessage()) : new pool.WriteToClientError();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.WriteToClientErrorWithCause(throwable.getLocalizedMessage()) : new pool.WriteToClientError();
        }
    }

    private static final class ReadErrorLostConnectionToClient
    extends FatalError {
        private ReadErrorLostConnectionToClient(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.ReadFromClientErrorWithCause(throwable.getMessage()) : new pool.ReadFromClientError();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.ReadFromClientErrorWithCause(throwable.getLocalizedMessage()) : new pool.ReadFromClientError();
        }
    }

    private static final class ReadErrorLostConnectionToLab
    extends FatalError {
        private final int fWorkerIndex;

        private ReadErrorLostConnectionToLab(int n, Throwable throwable) {
            super(throwable);
            this.fWorkerIndex = n;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.ReadFromWorkerErrorWithCause(Integer.toString(this.fWorkerIndex), throwable.getMessage()) : new pool.ReadFromWorkerError(Integer.toString(this.fWorkerIndex));
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.ReadFromWorkerErrorWithCause(Integer.toString(this.fWorkerIndex), throwable.getLocalizedMessage()) : new pool.ReadFromWorkerError(Integer.toString(this.fWorkerIndex));
        }
    }

    private static final class WriteErrorLostConnectionToLab
    extends FatalError {
        private final int fWorkerIndex;

        private WriteErrorLostConnectionToLab(int n, Throwable throwable) {
            super(throwable);
            this.fWorkerIndex = n;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.WriteToWorkerErrorWithCause(Integer.toString(this.fWorkerIndex), throwable.getMessage()) : new pool.WriteToWorkerError(Integer.toString(this.fWorkerIndex));
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.WriteToWorkerErrorWithCause(Integer.toString(this.fWorkerIndex), throwable.getLocalizedMessage()) : new pool.WriteToWorkerError(Integer.toString(this.fWorkerIndex));
        }
    }

    private static final class InternalRuntimeError
    extends FatalError {
        private InternalRuntimeError(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.InternalRuntimeWithCause(throwable.getMessage()) : new pool.InternalRuntime();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            Throwable throwable = this.getCause();
            return AbstractErrorHandler.isValidI18nMatlabIdentifiedException(throwable) ? new pool.InternalRuntimeWithCause(throwable.getLocalizedMessage()) : new pool.InternalRuntime();
        }
    }

    protected static abstract class FatalError
    implements HasI18nMatlabIdentifiedMessage,
    Serializable {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final Throwable fCause;

        FatalError(Throwable throwable) {
            this.fCause = throwable;
        }

        protected abstract BaseMsgID getFilledMessage();

        protected abstract BaseMsgID getFilledLocalizedMessage();

        protected Throwable getCause() {
            return this.fCause;
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.getFilledLocalizedMessage());
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.getFilledMessage());
        }

        public String getMessageID() {
            return this.getFilledMessage().getCatalogId() + ":" + this.getFilledMessage().getMessageId();
        }
    }
}

