/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.lang.pool;
import com.mathworks.toolbox.distcomp.pmode.SessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionListener;
import com.mathworks.toolbox.distcomp.pmode.UserVisibleMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

class ClientShutdownInvoker
implements SessionListener {
    private final ScheduledExecutorService fClientShutdownScheduledExecutorService;
    private final Callable<Boolean> fClientShutDownTask;
    private final Callable<Boolean> fClientTimeoutShutDownTask;
    private final Lock fShutdownLock = new ReentrantLock();
    private Future<Boolean> fClientShutdownFuture = null;
    private boolean fHasShutDownNowCalled;

    private ClientShutdownInvoker(final ShutdownHandler shutdownHandler, final SessionInfo sessionInfo) {
        this.fClientShutDownTask = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                String string = ClientShutdownInvoker.this.getLocalizedShutDownMessageString(sessionInfo);
                System.out.println(string);
                return shutdownHandler.normalShutdown();
            }
        };
        this.fClientTimeoutShutDownTask = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                UserVisibleMessage userVisibleMessage = new UserVisibleMessage((BaseMsgID)new pool.PoolTimeout());
                String string = ClientShutdownInvoker.this.getLocalizedShutDownMessageString(sessionInfo);
                System.out.println(userVisibleMessage.getLocalizedMessage() + "\n" + string);
                return shutdownHandler.normalShutdown();
            }
        };
        this.fClientShutdownScheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fClientShutdownScheduledExecutorService-"), (Logger)PackageInfo.LOGGER));
        this.fHasShutDownNowCalled = false;
    }

    public static ClientShutdownInvoker buildClientShutdownInvoker(ShutdownHandler shutdownHandler, SessionInfo sessionInfo) {
        ClientShutdownInvoker clientShutdownInvoker = new ClientShutdownInvoker(shutdownHandler, sessionInfo);
        clientShutdownInvoker.scheduleShutDown(sessionInfo.getIdleShutdownTimeout(), clientShutdownInvoker.fClientTimeoutShutDownTask);
        return clientShutdownInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Boolean> shutDownNow() {
        this.fShutdownLock.lock();
        try {
            if (this.fHasShutDownNowCalled) {
                Future<Boolean> future = this.fClientShutdownFuture;
                return future;
            }
            this.scheduleShutDown(0L, this.fClientShutDownTask);
            this.fHasShutDownNowCalled = true;
            Future<Boolean> future = this.fClientShutdownFuture;
            return future;
        }
        finally {
            this.fShutdownLock.unlock();
        }
    }

    private String getLocalizedShutDownMessageString(SessionInfo sessionInfo) {
        String string;
        String string2 = sessionInfo.getProfileName();
        if (string2.isEmpty()) {
            UserVisibleMessage userVisibleMessage = new UserVisibleMessage((BaseMsgID)new pool.PoolShutDownNoProfile());
            string = userVisibleMessage.getLocalizedMessage();
        } else {
            UserVisibleMessage userVisibleMessage = new UserVisibleMessage((BaseMsgID)new pool.PoolShutDownWithProfile(string2));
            string = userVisibleMessage.getLocalizedMessage();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleShutDown(long l, Callable<Boolean> callable) {
        this.fShutdownLock.lock();
        try {
            if (this.fHasShutDownNowCalled) {
                return;
            }
            this.cancelScheduledShutDown();
            if (!this.fClientShutdownScheduledExecutorService.isShutdown() && l < Integer.MAX_VALUE) {
                this.fClientShutdownFuture = this.fClientShutdownScheduledExecutorService.schedule(callable, l, TimeUnit.SECONDS);
            }
        }
        finally {
            this.fShutdownLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelScheduledShutDown() {
        this.fShutdownLock.lock();
        try {
            if (this.fHasShutDownNowCalled) {
                return;
            }
            if (this.fClientShutdownFuture != null) {
                this.fClientShutdownFuture.cancel(true);
            }
            this.fClientShutdownFuture = null;
        }
        finally {
            this.fShutdownLock.unlock();
        }
    }

    @Override
    public void sessionClosed(SessionEndedEvent sessionEndedEvent) {
        sessionEndedEvent.getSessionService().removeSessionListener(this);
        this.fClientShutdownScheduledExecutorService.shutdown();
    }

    @Override
    public void sessionErrored(SessionEndedEvent sessionEndedEvent) {
        sessionEndedEvent.getSessionService().removeSessionListener(this);
        this.cancelScheduledShutDown();
        this.fClientShutdownScheduledExecutorService.shutdown();
    }

    @Override
    public void sessionChangedSize(SessionEvent sessionEvent) {
    }

    @Override
    public void sessionChangedRestartOnClusterChange(SessionEvent sessionEvent) {
    }

    @Override
    public void sessionChangedIdleTimeout(SessionEvent sessionEvent) {
        this.scheduleShutDown(sessionEvent.getSessionInfo().getIdleShutdownTimeout(), this.fClientTimeoutShutDownTask);
    }

    @Override
    public void sessionBusy(SessionEvent sessionEvent) {
        this.cancelScheduledShutDown();
    }

    @Override
    public void sessionIdle(SessionEvent sessionEvent) {
        this.scheduleShutDown(sessionEvent.getSessionInfo().getIdleShutdownTimeout(), this.fClientTimeoutShutDownTask);
    }
}

