/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.ClearNotificationCommand;
import com.mathworks.toolbox.distcomp.pmode.ClearNotificationDispatcher;
import com.mathworks.toolbox.distcomp.pmode.Client;
import com.mathworks.toolbox.distcomp.pmode.ClientImpl;
import com.mathworks.toolbox.distcomp.pmode.ClientMExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.ClientShutdownHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.ClientShutdownInvoker;
import com.mathworks.toolbox.distcomp.pmode.ClientStartupSucceeded;
import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.DispatchableMessage;
import com.mathworks.toolbox.distcomp.pmode.DispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistantImpl;
import com.mathworks.toolbox.distcomp.pmode.LabMExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.LabShutdownHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.LabStartupSucceeded;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.LabsImpl;
import com.mathworks.toolbox.distcomp.pmode.LanguageControllerProvider;
import com.mathworks.toolbox.distcomp.pmode.MExecutor;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.PathNotificationCommand;
import com.mathworks.toolbox.distcomp.pmode.RemoteCompositeAssistant;
import com.mathworks.toolbox.distcomp.pmode.ResourceManagerImpl;
import com.mathworks.toolbox.distcomp.pmode.ReturnMessageDispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.SessionEndedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionListener;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.SessionWorkerNotifier;
import com.mathworks.toolbox.distcomp.pmode.SpmdController;
import com.mathworks.toolbox.distcomp.pmode.SpmdControllerImpl;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutor;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.StartupSucceeded;
import com.mathworks.toolbox.distcomp.pmode.TimeoutSettingDispatcherException;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.ResponseTracker;
import com.mathworks.toolbox.distcomp.pmode.matlabpool.attachedfiles.EditorListener;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.KeepAlive;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleCommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionServicesFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionStartupFailedException;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskDispatcherImpl;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskQueue;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskQueueImpl;
import com.mathworks.toolbox.distcomp.pmode.transfer.Transfer;
import com.mathworks.toolbox.distcomp.util.FutureWaiter;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.distcomp.util.PathNotificationGateway;
import com.mathworks.toolbox.distcomp.util.RunCallableOnce;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class Session
implements SessionService,
LanguageControllerProvider {
    private final boolean fIsClient;
    private final boolean fSpmdSupported;
    private final ProcessInstance fRole;
    private ExecutorService fListenerExec;
    private ObservableMessageRegistry fReturnMessageRegistry;
    private ErrorHandler fErrorHandler;
    private ResourceManager fResourceManager;
    private ExecutorService fDispatcherExec;
    private CommunicationGroup fCommGroup;
    private RoleCommunicationGroup fRoleCommGroup;
    private SessionRoleMapping fRoleMapping;
    private Dispatcher<Message> fDispatcher;
    private FutureWaiter fFutureWaiter;
    private MExecutor fMExec;
    private SpmdExecutor fSpmdExec;
    private ParforController.Factory fParforFactory;
    private SessionWorkerNotifier fSessionWorkerNotifier;
    private TaskQueue fTaskQueue;
    private ResponseTracker<Instance> fStartupSucceededCounter;
    private boolean fAllSupport64Bit = true;
    private RunCallableOnce<?> fOnSessionStartupComplete;
    private RemoteCompositeAssistant fRemoteCompositeAssistant;
    private FileDependenciesAssistant fFileDependenciesAssistant;
    private Transfer fTransfer;
    private Client fClient;
    private Labs fLabs = null;
    private ShutdownHandler fShutdownHandler;
    private KeepAlive fKeepAlive;
    private PathNotificationListener fPathNotificationListener;
    private final Set<SessionListener> fSessionListenerSet = Collections.synchronizedSet(new HashSet());
    private EditorListener fEditorListener;
    private SessionInfo fClientSessionInfo = SessionInfo.NULL_SESSION_INFO;
    private ClientShutdownInvoker fClientShutdownInvoker;

    static Session create(SessionServicesFactory sessionServicesFactory, List<Connection> list, int n, Instance instance) throws InterruptedException, SessionStartupFailedException {
        return Session.initCommon(new Session(n), sessionServicesFactory, list, instance);
    }

    static Session create(SessionServicesFactory sessionServicesFactory, List<Connection> list, Instance instance, boolean bl, SessionInfo sessionInfo) throws InterruptedException, SessionStartupFailedException {
        return Session.initCommon(new Session(bl, sessionInfo), sessionServicesFactory, list, instance);
    }

    private static Session initCommon(Session session, SessionServicesFactory sessionServicesFactory, List<Connection> list, Instance instance) throws InterruptedException, SessionStartupFailedException {
        Runnable runnable = session.initSessionServices(sessionServicesFactory);
        session.initCommunicationGroup(list, instance);
        runnable.run();
        session.initSession(instance, sessionServicesFactory);
        return session;
    }

    private Session(int n) {
        this.fIsClient = false;
        this.fSpmdSupported = false;
        this.fRole = ProcessInstance.getLabInstance(n);
    }

    private Session(boolean bl, SessionInfo sessionInfo) {
        this.fIsClient = true;
        this.fSpmdSupported = bl;
        this.fRole = ProcessInstance.getClientInstance();
        this.fClientSessionInfo = sessionInfo;
    }

    public boolean destroyClientSession() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Destroying the client session object.");
        Future<Boolean> future = this.shutdown();
        boolean bl = false;
        try {
            bl = future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Exception while shutting down of the client session object.", exception);
        }
        return bl;
    }

    @Override
    public Client getClient() {
        return this.fClient;
    }

    @Override
    public synchronized Labs getLabs() {
        if (this.fLabs == null) {
            LabsImpl labsImpl = LabsImpl.create(this);
            this.fCommGroup.addCommunicationObserver(labsImpl);
            this.fLabs = labsImpl;
        }
        return this.fLabs;
    }

    @Override
    public SessionRoleMapping getRoleMapping() {
        return this.fRoleMapping;
    }

    @Override
    public RoleCommunicationGroup getRoleCommGroup() {
        return this.fRoleCommGroup;
    }

    @Override
    public Transfer getTransfer() {
        return this.fTransfer;
    }

    @Override
    public int getPoolSize() {
        return this.fRoleCommGroup.getConnectedProcessInstances().size();
    }

    public Dispatcher<?> getDispatcherForDebugONLY() {
        return this.fDispatcher;
    }

    private synchronized FileDependenciesAssistant getFileDependenciesAssistantImpl() {
        if (this.fFileDependenciesAssistant == null) {
            this.fFileDependenciesAssistant = new FileDependenciesAssistantImpl(this);
        }
        return this.fFileDependenciesAssistant;
    }

    @Override
    public FileDependenciesAssistant getFileDependenciesAssistant() throws SessionDestroyedException {
        if (!this.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        assert (this.fRoleCommGroup != null) : "Unable to make FileDependenciesAssistant if there is no CommunicationGroup Available";
        return this.getFileDependenciesAssistantImpl();
    }

    @Override
    public boolean addSessionListener(SessionListener sessionListener) {
        return this.fSessionListenerSet.add(sessionListener);
    }

    @Override
    public boolean removeSessionListener(SessionListener sessionListener) {
        return this.fSessionListenerSet.remove(sessionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionListeners(SessionEventDispatcher sessionEventDispatcher) {
        HashSet<SessionListener> hashSet = new HashSet<SessionListener>();
        Set<SessionListener> set = this.fSessionListenerSet;
        synchronized (set) {
            hashSet.addAll(this.fSessionListenerSet);
        }
        for (SessionListener sessionListener : hashSet) {
            try {
                sessionEventDispatcher.dispatch(sessionListener);
            }
            catch (Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Listener threw exception.", throwable);
            }
        }
    }

    private void notifySessionClosed(SessionShutdownEvent sessionShutdownEvent) {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        switch (sessionShutdownEvent.getShutdownState()) {
            case NORMAL: {
                this.fClientSessionInfo = SessionInfo.close(this.fClientSessionInfo);
                final SessionEndedEvent sessionEndedEvent = new SessionEndedEvent(this.fClientSessionInfo, this);
                this.notifySessionListeners(new SessionEventDispatcher(){

                    @Override
                    public void dispatch(SessionListener sessionListener) {
                        sessionListener.sessionClosed(sessionEndedEvent);
                    }
                });
                break;
            }
            case ERROR: {
                this.fClientSessionInfo = SessionInfo.closeDueToError(this.fClientSessionInfo, sessionShutdownEvent.getErrorMsg().getLocalizedMessage());
                final SessionEndedEvent sessionEndedEvent = new SessionEndedEvent(this.fClientSessionInfo, this);
                this.notifySessionListeners(new SessionEventDispatcher(){

                    @Override
                    public void dispatch(SessionListener sessionListener) {
                        sessionListener.sessionErrored(sessionEndedEvent);
                    }
                });
            }
        }
    }

    private void notifySessionChangedSize() {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        if (this.fClientSessionInfo.getState().equals((Object)SessionInfo.SessionState.CLOSED)) {
            return;
        }
        int n = this.getPoolSize();
        SessionInfo sessionInfo = this.fClientSessionInfo;
        this.fClientSessionInfo = SessionInfo.sizeChanged(sessionInfo, n);
        final SessionEvent sessionEvent = new SessionEvent(this.fClientSessionInfo);
        this.notifySessionListeners(new SessionEventDispatcher(){

            @Override
            public void dispatch(SessionListener sessionListener) {
                sessionListener.sessionChangedSize(sessionEvent);
            }
        });
    }

    private void handleAcquiredWorkers(int n) {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        if (this.fClientSessionInfo.getState().equals((Object)SessionInfo.SessionState.CLOSED)) {
            return;
        }
        SessionInfo sessionInfo = this.fClientSessionInfo;
        this.fClientSessionInfo = SessionInfo.busy(sessionInfo, n);
        final SessionEvent sessionEvent = new SessionEvent(this.fClientSessionInfo);
        this.notifySessionListeners(new SessionEventDispatcher(){

            @Override
            public void dispatch(SessionListener sessionListener) {
                sessionListener.sessionBusy(sessionEvent);
            }
        });
    }

    private void handleReleasedWorkers(int n) {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        if (this.fClientSessionInfo.getState().equals((Object)SessionInfo.SessionState.CLOSED)) {
            return;
        }
        SessionInfo sessionInfo = this.fClientSessionInfo;
        int n2 = sessionInfo.getNumWorkersBusy();
        if (n < n2) {
            this.handleAcquiredWorkers(n2 - n);
            return;
        }
        this.fClientSessionInfo = SessionInfo.idle(sessionInfo);
        final SessionEvent sessionEvent = new SessionEvent(this.fClientSessionInfo);
        this.notifySessionListeners(new SessionEventDispatcher(){

            @Override
            public void dispatch(SessionListener sessionListener) {
                sessionListener.sessionIdle(sessionEvent);
            }
        });
    }

    private synchronized RemoteCompositeAssistant getCompositeAssistantImpl() {
        if (this.fRemoteCompositeAssistant == null) {
            this.fRemoteCompositeAssistant = new RemoteCompositeAssistant(this);
        }
        return this.fRemoteCompositeAssistant;
    }

    @Override
    public RemoteCompositeAssistant getCompositeAssistant() throws SessionDestroyedException {
        if (!this.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        assert (this.fRoleCommGroup != null) : "Unable to make RemoteCompositeAssistant if there is no CommunicationGroup Available";
        return this.getCompositeAssistantImpl();
    }

    @Override
    public FutureWaiter getFutureWaiter() {
        assert (this.fFutureWaiter != null) : "No FutureWaiter";
        return this.fFutureWaiter;
    }

    @Override
    public Future<ParforController> createParforController() {
        final Session session = this;
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " createParforController-"), (Logger)PackageInfo.LOGGER));
        Future<ParforController> future = executorService.submit(new Callable<ParforController>(){

            @Override
            public ParforController call() throws SessionDestroyedException, CannotAcquireLabsException {
                return Session.this.fParforFactory.build(session);
            }
        });
        executorService.shutdown();
        return future;
    }

    @Override
    public boolean isSpmdSupported() {
        return this.fSpmdSupported;
    }

    @Override
    public Future<SpmdController> createSpmdController() {
        assert (this.fSpmdSupported) : "SPMD not supported";
        if (!this.fSpmdSupported) {
            throw new IllegalStateException("Session does not support SPMD.");
        }
        final Session session = this;
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " createSpmdController-"), (Logger)PackageInfo.LOGGER));
        Future<SpmdController> future = executorService.submit(new Callable<SpmdController>(){

            @Override
            public SpmdController call() throws SessionDestroyedException, CannotAcquireLabsException {
                return SpmdControllerImpl.create(session, session);
            }
        });
        executorService.shutdown();
        return future;
    }

    @Override
    public synchronized TaskQueue getTaskQueue() throws SessionDestroyedException {
        if (this.fTaskQueue == null) {
            TaskQueueImpl taskQueueImpl = new TaskQueueImpl(this, this.fCommGroup);
            this.fTaskQueue = taskQueueImpl;
            this.fCommGroup.addCommunicationObserver(taskQueueImpl);
        }
        return this.fTaskQueue;
    }

    public boolean isPoolManagerSession() {
        return !this.fShutdownHandler.hasShutdownBegun() && this.fIsClient;
    }

    public void startSendPathAndClearNotificationToLabs() {
        if (this.fPathNotificationListener != null) {
            this.fPathNotificationListener.register();
        }
        if (this.fEditorListener != null) {
            this.fEditorListener.register();
        }
    }

    public void stopSendPathAndClearNotificationToLabs() {
        if (this.fPathNotificationListener != null) {
            this.fPathNotificationListener.unregister();
        }
        if (this.fEditorListener != null) {
            this.fEditorListener.unregister();
        }
    }

    @Override
    public ExecutorService getListenerExecutor() {
        return this.fListenerExec;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    @Override
    public boolean isSessionRunning() {
        return this.fShutdownHandler != null && !this.fShutdownHandler.hasShutdownBegun();
    }

    @Override
    public boolean hasSessionStarted() throws InterruptedException {
        return this.fStartupSucceededCounter.await(0L, TimeUnit.NANOSECONDS);
    }

    public boolean supports64BitSerialization() {
        return this.fAllSupport64Bit;
    }

    @Override
    public SessionWorkerNotifier getSessionWorkerNotifier() {
        return this.fSessionWorkerNotifier;
    }

    @Override
    public SessionInfo getClientSessionInfo() {
        assert (this.fIsClient) : "Client session info should only be used on the client";
        return this.fClientSessionInfo;
    }

    public boolean waitForSessionToStart(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (!this.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        return this.fStartupSucceededCounter.await(l, timeUnit);
    }

    private void startupSucceeded(Instance instance, StartupSucceeded startupSucceeded) throws InterruptedException {
        this.fStartupSucceededCounter.addResponder(instance);
        boolean bl = this.fAllSupport64Bit = this.fAllSupport64Bit && startupSucceeded.supports64Bit();
        if (this.hasSessionStarted()) {
            this.fOnSessionStartupComplete.run();
        }
    }

    private Runnable initSessionServices(SessionServicesFactory sessionServicesFactory) {
        this.fRoleMapping = new SessionRoleMapping();
        final SessionErrorHandler sessionErrorHandler = sessionServicesFactory.buildErrorHandler(this.fRoleMapping);
        this.fErrorHandler = sessionErrorHandler;
        this.fListenerExec = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fListenerExec-"), (Logger)PackageInfo.LOGGER));
        final ReturnMessageDispatcherImpl returnMessageDispatcherImpl = ReturnMessageDispatcherImpl.create(this.fListenerExec, this.fErrorHandler);
        this.fReturnMessageRegistry = returnMessageDispatcherImpl;
        this.fResourceManager = new ResourceManagerImpl();
        return new Runnable(){

            @Override
            public void run() {
                Session.this.fCommGroup.addCommunicationObserver(returnMessageDispatcherImpl);
                Session.this.fCommGroup.addCommunicationObserver(sessionErrorHandler);
                Session.this.fCommGroup.addCommunicationObserver(new CommunicationObserver(){

                    @Override
                    public void communicationLost(Instance instance, Throwable throwable) {
                        Session.this.notifySessionChangedSize();
                    }

                    @Override
                    public void communicationEstablished(Instance instance) {
                        Session.this.notifySessionChangedSize();
                    }
                });
            }
        };
    }

    private void initCommunicationGroup(List<Connection> list, Instance instance) {
        block3: {
            try {
                JoinInfo joinInfo = list.get(0).getJoinInfo();
                this.checkConnectionGroupConsistency(list);
                PackageInfo.LOGGER.info("pmode.Session building communication group with the following joinInfo: " + joinInfo);
                PackageInfo.LOGGER.info("pmode.Session about to build communication group type: " + joinInfo.getGroupImplementation().getSimpleName());
                this.fCommGroup = CommunicationGroup.CommunicationGroupBuilder.buildCommunicationGroup(joinInfo, this.fErrorHandler, this.fReturnMessageRegistry, list.toArray(new Connection[list.size()]), instance);
            }
            catch (Exception exception) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Failed to build DirectCommunicationGroup", exception);
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Failed to build comm group");
            }
        }
        this.fRoleMapping.registerProcess(this.fRole, instance);
        this.fRoleCommGroup = new RoleCommunicationGroup(this.fCommGroup, this.fRoleMapping);
        this.fCommGroup.addCommunicationObserver(this.fRoleCommGroup);
        for (Connection connection : list) {
            this.fRoleCommGroup.registerConnection(connection.getRemoteInstance());
        }
    }

    private static boolean areAssertionsEnabled() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl;
    }

    private void checkConnectionGroupConsistency(List<Connection> list) {
        if (Session.areAssertionsEnabled()) {
            HashSet<Class<? extends CommunicationGroup>> hashSet = new HashSet<Class<? extends CommunicationGroup>>();
            for (Connection connection : list) {
                hashSet.add(connection.getJoinInfo().getGroupImplementation());
            }
            assert (hashSet.size() == 1) : "Found multiple communication group classes: " + hashSet;
        }
    }

    private void initSession(final Instance instance, SessionServicesFactory sessionServicesFactory) throws InterruptedException, TimeoutSettingDispatcherException {
        Object object;
        DispatcherImpl dispatcherImpl;
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Initializing session.");
        Session session = this;
        ClosableSessionConnections closableSessionConnections = new ClosableSessionConnections(){

            @Override
            public void run(SessionShutdownEvent sessionShutdownEvent) {
                Session.this.closeIOStopExecutors(sessionShutdownEvent);
            }
        };
        this.fClient = null;
        this.fSpmdExec = null;
        this.fDispatcher = dispatcherImpl = DispatcherImpl.create(this.fRoleMapping);
        ArrayList<Dispatcher<Message>> arrayList = new ArrayList<Dispatcher<Message>>();
        arrayList.add(this.fReturnMessageRegistry.getDispatcher());
        arrayList.add(new DispatchableMessageDispatcherImpl());
        if (this.fIsClient) {
            object = this.fCommGroup.getConnectedInstances();
            this.fShutdownHandler = new ClientShutdownHandlerImpl(session, this.fCommGroup, closableSessionConnections, (List<Instance>)object);
            this.fMExec = new ClientMExecutorImpl();
            this.fParforFactory = sessionServicesFactory.getParforControllerFactory();
            this.fClientShutdownInvoker = ClientShutdownInvoker.buildClientShutdownInvoker(this.fShutdownHandler, this.fClientSessionInfo);
            this.addSessionListener(this.fClientShutdownInvoker);
        } else {
            object = LabShutdownHandlerImpl.create(this.fErrorHandler, this.fCommGroup, closableSessionConnections);
            arrayList.add((Dispatcher<Message>)object);
            this.fShutdownHandler = object;
            this.fFutureWaiter = new FutureWaiter(2);
            this.fMExec = new LabMExecutorImpl(this.fCommGroup);
            this.fClient = ClientImpl.create(this.fRole, this.fRoleCommGroup);
            this.fSpmdExec = new SpmdExecutorImpl(this.fCommGroup, this.fFutureWaiter);
            arrayList.add(this.fSpmdExec);
            arrayList.add(new TaskDispatcherImpl(this, this.fCommGroup));
            arrayList.add(new ClearNotificationDispatcher());
        }
        this.fSessionWorkerNotifier = new SessionWorkerNotifier(){

            @Override
            public void notifyAcquiredWorkers(int n) {
                Session.this.handleAcquiredWorkers(n);
            }

            @Override
            public void notifyReleasedWorkers(int n) {
                Session.this.handleReleasedWorkers(n);
            }
        };
        this.fStartupSucceededCounter = new ResponseTracker();
        arrayList.add(this.fMExec);
        this.fKeepAlive = sessionServicesFactory.buildKeepAlive(this.fCommGroup);
        arrayList.add(this.fKeepAlive.getDispatcher());
        this.fTransfer = new Transfer(session);
        dispatcherImpl.addDispatcher(this.fTransfer.getTransferManager());
        if (this.fIsClient) {
            arrayList.add(new Dispatcher<LabStartupSucceeded>(){

                @Override
                public void dispatch(LabStartupSucceeded labStartupSucceeded, Instance instance) {
                    try {
                        Session.this.startupSucceeded(instance, labStartupSucceeded);
                    }
                    catch (InterruptedException interruptedException) {
                        PackageInfo.LOGGER.log(Level.SEVERE, "Startup failed.", interruptedException);
                    }
                }
            });
        } else {
            arrayList.add(new Dispatcher<ClientStartupSucceeded>(){

                @Override
                public void dispatch(ClientStartupSucceeded clientStartupSucceeded, Instance instance) {
                    try {
                        PackageInfo.LOGGER.fine("Session got startup succeeded:" + clientStartupSucceeded);
                        Session.this.startupSucceeded(instance, clientStartupSucceeded);
                    }
                    catch (InterruptedException interruptedException) {
                        PackageInfo.LOGGER.log(Level.SEVERE, "Startup failed.", interruptedException);
                    }
                }
            });
        }
        for (Dispatcher dispatcher : arrayList) {
            dispatcherImpl.addDispatcher(dispatcher);
        }
        this.fPathNotificationListener = new PathNotificationListener(this.fCommGroup);
        this.fEditorListener = new EditorListener();
        this.fDispatcherExec = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + "fDispatcherExec-"), (Logger)PackageInfo.LOGGER));
        try {
            object = this.fCommGroup.setDispatcher(this.fDispatcher, this.fDispatcherExec);
            boolean bl = object.await(60000L, TimeUnit.MILLISECONDS);
            if (!bl) {
                PackageInfo.LOGGER.severe("Timed out setting dispatcher.");
                throw new TimeoutSettingDispatcherException();
            }
        }
        catch (InterruptedException | RuntimeException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Failed to set dispatcher for comm group", exception);
            throw exception;
        }
        this.fErrorHandler.activate(this.fShutdownHandler);
        this.fOnSessionStartupComplete = new RunCallableOnce(new Runnable(){

            @Override
            public void run() {
                PackageInfo.LOGGER.finer("fOnSessionStartupComplete() starting.");
                Session.this.fKeepAlive.start();
                Session.this.fShutdownHandler.sessionStartupComplete();
                PackageInfo.LOGGER.finer("fOnSessionStartupComplete() done.");
            }
        });
        if (this.fIsClient) {
            object = new ArrayList<Instance>(this.fCommGroup.getConnectedInstances());
            object.add(instance);
            this.fStartupSucceededCounter.setExpectedResponders((Collection<Instance>)object);
            ClientStartupSucceeded clientStartupSucceeded = new ClientStartupSucceeded();
            this.fCommGroup.sendTo(this.fCommGroup.getConnectedInstances(), (Message)clientStartupSucceeded);
            this.startupSucceeded(instance, clientStartupSucceeded);
        } else {
            object = new ArrayList<Instance>(this.fRoleMapping.roleToInstance(Collections.singletonList(ProcessInstance.getClientInstance())));
            object.add(instance);
            this.fStartupSucceededCounter.setExpectedResponders((Collection<Instance>)object);
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            CompletionObserver completionObserver = new CompletionObserver(){

                public void completed(int n, Object object) {
                    if (Session.this.isSessionRunning()) {
                        LabStartupSucceeded labStartupSucceeded = new LabStartupSucceeded();
                        Session.this.fRoleCommGroup.sendTo(ProcessInstance.getClientInstance(), (Message)labStartupSucceeded);
                        try {
                            Session.this.startupSucceeded(instance, labStartupSucceeded);
                        }
                        catch (InterruptedException interruptedException) {
                            PackageInfo.LOGGER.log(Level.SEVERE, "Startup failed.", interruptedException);
                        }
                    }
                }
            };
            matlabMCR.eval(";", completionObserver);
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Initialization complete.");
    }

    private void closeIOStopExecutors(SessionShutdownEvent sessionShutdownEvent) {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "In closeIOStopExecutors with event data: " + (Object)((Object)sessionShutdownEvent.getShutdownState()));
        try {
            this.fKeepAlive.shutdownNow();
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Problem shutting down KeepAlive ", runtimeException);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Unregister PathNotificationListener.");
            this.fPathNotificationListener.unregister();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when unregistering fPathNotificationListener.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "Unregister EditorListener.");
            this.fEditorListener.unregister();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when unregistering fEditorListener.", throwable);
        }
        try {
            if (this.fListenerExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Stopping fListenerExec.");
                this.fListenerExec.shutdown();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when stopping fInputExec.", throwable);
        }
        try {
            if (this.fDispatcherExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Stopping fDispatcherExec.");
                this.fDispatcherExec.shutdown();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when stopping fDispatcherExec.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fCommGroup.");
            this.fCommGroup.closeStreams();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing fCommGroup.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fMExec.");
            this.fMExec.destroy();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing M executor.", throwable);
        }
        try {
            if (this.fFutureWaiter != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fFutureWaiter.");
                this.fFutureWaiter.destroy();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing FutureWaiter.", throwable);
        }
        try {
            if (this.fSpmdExec != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fSpmdExec.");
                this.fSpmdExec.destroy();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing SPMD executor.", throwable);
        }
        try {
            if (this.fTaskQueue != null) {
                PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fTaskQueue.");
                this.fTaskQueue.shutdown();
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing Task Queue.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fTransfer.");
            this.fTransfer.destroy();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing transfer object.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Closing fReturnMessageRegistry.");
            this.fReturnMessageRegistry.destroy();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when closing ReturnMessageRegistry object.", throwable);
        }
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Firing SessionEndedEvent listeners.");
            this.notifySessionClosed(sessionShutdownEvent);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Caught a Throwable when Firing SessionEndedEvent listeners.", throwable);
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closed IO, Executors and MExecutor.");
    }

    public void assertStartupWasSuccessful() throws InterruptedException {
        assert (this.fShutdownHandler != null);
        if (this.fShutdownHandler instanceof LabShutdownHandlerImpl) {
            LabShutdownHandlerImpl labShutdownHandlerImpl = (LabShutdownHandlerImpl)this.fShutdownHandler;
            assert (labShutdownHandlerImpl.sessionStartupIsComplete());
        }
    }

    @Override
    public Future<Boolean> shutdown() {
        return this.fClientShutdownInvoker.shutDownNow();
    }

    @Override
    public void setShutdownIdleTimeout(long l) {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        SessionInfo sessionInfo = this.fClientSessionInfo;
        this.fClientSessionInfo = SessionInfo.timeoutChanged(sessionInfo, l);
        final SessionEvent sessionEvent = new SessionEvent(this.fClientSessionInfo);
        this.notifySessionListeners(new SessionEventDispatcher(){

            @Override
            public void dispatch(SessionListener sessionListener) {
                sessionListener.sessionChangedIdleTimeout(sessionEvent);
            }
        });
    }

    @Override
    public void setRestartOnClusterChange(boolean bl) {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        SessionInfo sessionInfo = this.fClientSessionInfo;
        this.fClientSessionInfo = SessionInfo.restartOnClusterChanged(sessionInfo, bl);
        final SessionEvent sessionEvent = new SessionEvent(this.fClientSessionInfo);
        this.notifySessionListeners(new SessionEventDispatcher(){

            @Override
            public void dispatch(SessionListener sessionListener) {
                sessionListener.sessionChangedRestartOnClusterChange(sessionEvent);
            }
        });
    }

    @Override
    public void extendShutDownTimeout() {
        if (this.fClientSessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            return;
        }
        SessionInfo sessionInfo = this.fClientSessionInfo;
        this.fClientSessionInfo = SessionInfo.resetIdleAtTime(sessionInfo);
        final SessionEvent sessionEvent = new SessionEvent(this.fClientSessionInfo);
        this.notifySessionListeners(new SessionEventDispatcher(){

            @Override
            public void dispatch(SessionListener sessionListener) {
                sessionListener.sessionIdle(sessionEvent);
            }
        });
    }

    private static class PathNotificationListener
    implements PathNotificationGateway.Listener {
        private boolean fRegistered = false;
        private final OutputGroup fOutputGroup;

        PathNotificationListener(OutputGroup outputGroup) {
            this.fOutputGroup = outputGroup;
        }

        synchronized void register() {
            if (!this.fRegistered) {
                PathNotificationGateway.addListener(this);
                this.fRegistered = true;
            }
        }

        synchronized void unregister() {
            if (this.fRegistered) {
                PathNotificationGateway.removeListener(this);
                this.fRegistered = false;
            }
        }

        @Override
        public void addpath(String[] stringArray, String string) {
            PathNotificationCommand pathNotificationCommand = new PathNotificationCommand(PathNotificationCommand.PathNotificationType.ADDPATH, stringArray, string);
            this.sendCommand(pathNotificationCommand);
        }

        @Override
        public void rmpath(String[] stringArray) {
            PathNotificationCommand pathNotificationCommand = new PathNotificationCommand(PathNotificationCommand.PathNotificationType.RMPATH, stringArray);
            this.sendCommand(pathNotificationCommand);
        }

        @Override
        public void cd(String string) {
            PathNotificationCommand pathNotificationCommand = new PathNotificationCommand(PathNotificationCommand.PathNotificationType.CD, string);
            this.sendCommand(pathNotificationCommand);
        }

        @Override
        public void clear(String[] stringArray) {
            ClearNotificationCommand clearNotificationCommand = new ClearNotificationCommand(stringArray);
            this.sendCommand(clearNotificationCommand);
        }

        private void sendCommand(Message message) {
            this.fOutputGroup.sendTo(this.fOutputGroup.getConnectedInstances(), message);
        }
    }

    private class DispatchableMessageDispatcherImpl
    implements Dispatcher<DispatchableMessage> {
        private DispatchableMessageDispatcherImpl() {
        }

        @Override
        public void dispatch(DispatchableMessage dispatchableMessage, Instance instance) {
            dispatchableMessage.dispatch(Session.this.fCommGroup, instance, Session.this);
        }
    }

    private static interface SessionEventDispatcher {
        public void dispatch(SessionListener var1);
    }
}

