/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerClientInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import java.util.UUID;

public final class BrokeredAcceptInfo
implements AcceptInfo {
    private final Class<? extends CommunicationGroup> fCommunicationGroupClass;
    private final UUID fGroupUuid;
    private final BrokerClientInfo fBrokerClientInfo;
    private final long fJoinTimeLimit;
    private final long fBrokeredConnectAcceptorTimeout;
    private final long fDeadline;
    private final int fBrokeredConnectAttempts;
    private final ServerSocketAcceptInfo fRemoteAcceptInfo;

    private BrokeredAcceptInfo(Class<? extends CommunicationGroup> clazz, UUID uUID, BrokerClientInfo brokerClientInfo, long l, long l2, long l3, int n, ServerSocketAcceptInfo serverSocketAcceptInfo) {
        assert (serverSocketAcceptInfo.getDeadline() == Long.MAX_VALUE) : "remoteAcceptInfo should have no deadline, not " + serverSocketAcceptInfo.getDeadline();
        this.fCommunicationGroupClass = clazz;
        this.fGroupUuid = uUID;
        this.fBrokerClientInfo = brokerClientInfo;
        this.fJoinTimeLimit = l;
        this.fBrokeredConnectAcceptorTimeout = l2;
        this.fDeadline = l3;
        this.fBrokeredConnectAttempts = n;
        this.fRemoteAcceptInfo = serverSocketAcceptInfo;
    }

    @Override
    public UUID getGroupUUID() {
        return this.fGroupUuid;
    }

    @Override
    public Class<? extends CommunicationGroup> getGroupImplementation() {
        return this.fCommunicationGroupClass;
    }

    @Override
    public boolean hasExpired() {
        return JoinInfo.DeadlineHelper.hasExpired(this);
    }

    @Override
    public long getRemainingTime() {
        return JoinInfo.DeadlineHelper.getRemainingTime(this);
    }

    @Override
    public AcceptorSecurityDescription getAcceptorSecurityDescription() {
        return this.fRemoteAcceptInfo.getAcceptorSecurityDescription();
    }

    @Override
    public long getDeadline() {
        return this.fDeadline;
    }

    @Override
    public long getHandShakeDeadline() {
        return JoinInfo.DeadlineHelper.getReasonableHandShakeDeadline(this);
    }

    @Override
    public long getJoinTimeLimit() {
        return this.fJoinTimeLimit;
    }

    @Override
    public BrokeredAcceptInfo createCopyWithReasonableDeadline() {
        return (BrokeredAcceptInfo)JoinInfo.DeadlineHelper.createCopyWithReasonableDeadline(this);
    }

    @Override
    public int getNumberOfAttempts() {
        return this.fBrokeredConnectAttempts;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " using " + this.fBrokerClientInfo.getLogString() + " for group " + this.fGroupUuid;
    }

    @Override
    public boolean peersConnectingAsGroupShareBarrier() {
        return true;
    }

    BrokerClientInfo getBrokerClientInfo() {
        return this.fBrokerClientInfo;
    }

    public long getBrokeredConnectAcceptorTimeout() {
        return this.fBrokeredConnectAcceptorTimeout;
    }

    public ServerSocketAcceptInfo getRemoteAcceptInfo() {
        return this.fRemoteAcceptInfo;
    }

    @Override
    public BrokeredAcceptInfo createCopyReplaceDeadline(long l) {
        return BrokeredAcceptInfo.createBrokeredAcceptInfo(this.fCommunicationGroupClass, this.fGroupUuid, this.fBrokerClientInfo, this.fJoinTimeLimit, this.fBrokeredConnectAcceptorTimeout, l, this.fBrokeredConnectAttempts, this.fRemoteAcceptInfo);
    }

    public static BrokeredAcceptInfo createBrokeredAcceptInfo(Class<? extends CommunicationGroup> clazz, UUID uUID, BrokerClientInfo brokerClientInfo, long l, long l2, long l3, int n, ServerSocketAcceptInfo serverSocketAcceptInfo) {
        return new BrokeredAcceptInfo(clazz, uUID, brokerClientInfo, l, l2, l3, n, serverSocketAcceptInfo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BrokeredAcceptInfo brokeredAcceptInfo = (BrokeredAcceptInfo)object;
        if (this.fBrokeredConnectAcceptorTimeout != brokeredAcceptInfo.fBrokeredConnectAcceptorTimeout) {
            return false;
        }
        if (this.fBrokeredConnectAttempts != brokeredAcceptInfo.fBrokeredConnectAttempts) {
            return false;
        }
        if (this.fDeadline != brokeredAcceptInfo.fDeadline) {
            return false;
        }
        if (this.fJoinTimeLimit != brokeredAcceptInfo.fJoinTimeLimit) {
            return false;
        }
        if (this.fBrokerClientInfo != null ? !this.fBrokerClientInfo.equals(brokeredAcceptInfo.fBrokerClientInfo) : brokeredAcceptInfo.fBrokerClientInfo != null) {
            return false;
        }
        if (this.fGroupUuid != null ? !this.fGroupUuid.equals(brokeredAcceptInfo.fGroupUuid) : brokeredAcceptInfo.fGroupUuid != null) {
            return false;
        }
        return !(this.fRemoteAcceptInfo != null ? !this.fRemoteAcceptInfo.equals(brokeredAcceptInfo.fRemoteAcceptInfo) : brokeredAcceptInfo.fRemoteAcceptInfo != null);
    }

    public int hashCode() {
        int n = this.fGroupUuid != null ? this.fGroupUuid.hashCode() : 0;
        n = 31 * n + (this.fBrokerClientInfo != null ? this.fBrokerClientInfo.hashCode() : 0);
        n = 31 * n + (int)(this.fJoinTimeLimit ^ this.fJoinTimeLimit >>> 32);
        n = 31 * n + (int)(this.fBrokeredConnectAcceptorTimeout ^ this.fBrokeredConnectAcceptorTimeout >>> 32);
        n = 31 * n + (int)(this.fDeadline ^ this.fDeadline >>> 32);
        n = 31 * n + this.fBrokeredConnectAttempts;
        n = 31 * n + (this.fRemoteAcceptInfo != null ? this.fRemoteAcceptInfo.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "BrokeredAcceptInfo{fGroupUuid=" + this.fGroupUuid + ", fBrokerClientInfo=" + this.fBrokerClientInfo + ", fJoinTimeLimit=" + this.fJoinTimeLimit + ", fBrokeredConnectAcceptorTimeout=" + this.fBrokeredConnectAcceptorTimeout + ", fDeadline=" + this.fDeadline + ", fBrokeredConnectAttempts=" + this.fBrokeredConnectAttempts + ", fRemoteAcceptInfo=" + this.fRemoteAcceptInfo + '}';
    }
}

