/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ProtocolId;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class PeerInstance
implements Instance {
    private final ProtocolId fProtocolId;
    private final UUID fUuid;
    private final UUID fGroupUuid;
    private static final int BYTE_LENGTH_OF_UUID = 16;

    public PeerInstance(ProtocolId protocolId, UUID uUID, UUID uUID2) {
        assert (protocolId != null) : "protocolId cannot be null";
        assert (uUID != null) : "groupUuid cannot be null";
        assert (uUID2 != null) : "Uuid cannot be null";
        this.fProtocolId = protocolId;
        this.fUuid = uUID2;
        this.fGroupUuid = uUID;
    }

    @Override
    public UUID getUuid() {
        return this.fUuid;
    }

    @Override
    public UUID getGroupUuid() {
        return this.fGroupUuid;
    }

    @Override
    public ProtocolId getProtocolId() {
        return this.fProtocolId;
    }

    @Override
    public int getByteLengthOfInstanceBootstrap() {
        return 32;
    }

    @Override
    public void encodeInstanceBootstrap(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.getGroupUuid().getMostSignificantBits());
        byteBuffer.putLong(this.getGroupUuid().getLeastSignificantBits());
        byteBuffer.putLong(this.getUuid().getMostSignificantBits());
        byteBuffer.putLong(this.getUuid().getLeastSignificantBits());
    }

    @Override
    public Instance decodeRemoteInstanceBootstrap(ByteBuffer byteBuffer) {
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        long l4 = byteBuffer.getLong();
        UUID uUID = new UUID(l, l2);
        UUID uUID2 = new UUID(l3, l4);
        return new PeerInstance(this.fProtocolId, uUID, uUID2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PeerInstance peerInstance = (PeerInstance)object;
        if (!this.fGroupUuid.equals(peerInstance.fGroupUuid)) {
            return false;
        }
        if (this.fProtocolId != peerInstance.fProtocolId) {
            return false;
        }
        return this.fUuid.equals(peerInstance.fUuid);
    }

    public int hashCode() {
        int n = this.fProtocolId.hashCode();
        n = 31 * n + this.fUuid.hashCode();
        n = 31 * n + this.fGroupUuid.hashCode();
        return n;
    }

    public String toString() {
        return "PeerInstance{fProtocolId=" + (Object)((Object)this.fProtocolId) + ", fUuid=" + this.fUuid + ", fGroupUuid=" + this.fGroupUuid + '}';
    }
}

