/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerClientInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredAcceptorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.Log;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolAcceptor;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolBrokeredAcceptor;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolBrokeredConnector;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolConnector;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolServerSocketAcceptor;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolSocketConnector;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.UUID;

public final class ConnectionManager {
    private ConnectionManager() {
    }

    public static Connector buildLabConnManager(int n, int n2, int n3, String string, ConnectInfo connectInfo, ProcessInstance processInstance) throws PeerMessagingException {
        try {
            Log.LOGGER.log(DistcompLevel.SIX, "buildLabConnManager connectInfo is " + connectInfo);
            UUID uUID = UUID.randomUUID();
            MatlabPoolPeerInstance matlabPoolPeerInstance = new MatlabPoolPeerInstance(connectInfo.getGroupUUID(), uUID, n, n2);
            MatlabPoolConnector matlabPoolConnector = connectInfo instanceof BrokeredSocketConnectInfo ? new MatlabPoolBrokeredConnector(matlabPoolPeerInstance, string, connectInfo.getGroupUUID(), n3) : new MatlabPoolSocketConnector(matlabPoolPeerInstance);
            Connector connector = new Connector(matlabPoolConnector);
            connector.registerConnectInfo(connectInfo, processInstance);
            return connector;
        }
        catch (PeerMessagingException | RuntimeException exception) {
            ConnectionManager.handleTrappedThrowable(exception);
            throw exception;
        }
    }

    public static Acceptor buildLabOneAcceptor(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws PeerMessagingException {
        Log.LOGGER.log(DistcompLevel.FIVE, "ConnectionManager.buildLabOneAcceptor()");
        try {
            MatlabPoolServerSocketAcceptor matlabPoolServerSocketAcceptor = new MatlabPoolServerSocketAcceptor(string, matlabPoolPeerInstance, serverSocketAcceptInfo);
            return new Acceptor(matlabPoolServerSocketAcceptor);
        }
        catch (PeerMessagingException peerMessagingException) {
            ConnectionManager.handleTrappedThrowable(peerMessagingException);
            throw peerMessagingException;
        }
    }

    public static Acceptor buildClientConnManager(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, AcceptInfo acceptInfo) throws PeerMessagingException, InterruptedException {
        Log.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager acceptInfo is " + acceptInfo);
        try {
            MatlabPoolAcceptor matlabPoolAcceptor;
            if (acceptInfo instanceof BrokeredAcceptInfo) {
                BrokeredAcceptInfo brokeredAcceptInfo = (BrokeredAcceptInfo)acceptInfo;
                matlabPoolAcceptor = new MatlabPoolBrokeredAcceptor(matlabPoolPeerInstance, brokeredAcceptInfo);
            } else if (acceptInfo instanceof ServerSocketAcceptInfo) {
                ServerSocketAcceptInfo serverSocketAcceptInfo = (ServerSocketAcceptInfo)acceptInfo;
                matlabPoolAcceptor = new MatlabPoolServerSocketAcceptor(string, matlabPoolPeerInstance, serverSocketAcceptInfo);
            } else {
                throw new IllegalArgumentException("acceptInfo is a " + acceptInfo.getClass() + ", not a BrokeredAcceptInfo or a ServerSocketAcceptInfo");
            }
            return new Acceptor(matlabPoolAcceptor);
        }
        catch (PeerMessagingException | InterruptedException | RuntimeException exception) {
            ConnectionManager.handleTrappedThrowable(exception);
            throw exception;
        }
    }

    public static MatlabPoolPeerInstance createClientPeerInstance() {
        UUID uUID = UUID.randomUUID();
        UUID uUID2 = UUID.randomUUID();
        return new MatlabPoolPeerInstance(uUID, uUID2, -1, -1);
    }

    private static Class<? extends CommunicationGroup> communicationGroupClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            throw new IllegalArgumentException("communicationGroupClassName -- " + string + " -- must be a class that implements " + CommunicationGroup.class.getSimpleName(), exception);
        }
    }

    public static AcceptInfo createAcceptInfo(MatlabPoolPeerInstance matlabPoolPeerInstance, String string, int n, int n2, int n3, ServerSocketConnectInfo serverSocketConnectInfo, ServerSocketAcceptInfo serverSocketAcceptInfo, boolean bl, long l, long l2, int n4) {
        AcceptorSecurityDescription acceptorSecurityDescription = bl ? BrokeredAcceptorSSLSecurityDescription.createAcceptorSSLSecurityDescription(matlabPoolPeerInstance.getGroupUuid(), "MATLABPOOL-") : new AcceptorPlainSecurityDescription();
        if (serverSocketConnectInfo != null) {
            Log.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager brokerServerSocketConnectInfo is " + serverSocketConnectInfo);
            ServerSocketAcceptInfo serverSocketAcceptInfo2 = serverSocketAcceptInfo.createFromTemplate(matlabPoolPeerInstance.getGroupUuid(), acceptorSecurityDescription, l2, l, Long.MAX_VALUE);
            BrokerClientInfo brokerClientInfo = new BrokerClientInfo(serverSocketConnectInfo, l, l2);
            return BrokeredAcceptInfo.createBrokeredAcceptInfo(ConnectionManager.communicationGroupClassForName(string), matlabPoolPeerInstance.getGroupUuid(), brokerClientInfo, l2, l2, Long.MAX_VALUE, n4, serverSocketAcceptInfo2);
        }
        Log.LOGGER.log(DistcompLevel.SIX, "buildClientConnManager using new code path");
        AcceptorPlainSecurityDescription acceptorPlainSecurityDescription = new AcceptorPlainSecurityDescription();
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(ConnectionManager.communicationGroupClassForName(string), matlabPoolPeerInstance.getGroupUuid(), n, n2, 0, 1, n3, acceptorPlainSecurityDescription, l2, l, n4, Long.MAX_VALUE);
    }

    public static AcceptInfo createAcceptInfo(MatlabPoolPeerInstance matlabPoolPeerInstance, String string, int n, int n2, int n3, long l, long l2, int n4) {
        AcceptorPlainSecurityDescription acceptorPlainSecurityDescription = new AcceptorPlainSecurityDescription();
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(ConnectionManager.communicationGroupClassForName(string), matlabPoolPeerInstance.getGroupUuid(), n, n2, 0, 1, n3, acceptorPlainSecurityDescription, l2, l, n4, Long.MAX_VALUE);
    }

    private static void handleTrappedThrowable(Throwable throwable) {
        Log.LOGGER.log(DistcompLevel.TWO, "Throwable thrown to Matlab.", throwable);
    }

    public static final class Connector
    implements AutoCloseable {
        private final MatlabPoolConnector fMatlabPoolConnector;

        private Connector(MatlabPoolConnector matlabPoolConnector) {
            this.fMatlabPoolConnector = matlabPoolConnector;
        }

        public void registerConnectInfo(ConnectInfo connectInfo, ProcessInstance processInstance) {
            this.fMatlabPoolConnector.registerConnectInfo(connectInfo, processInstance);
        }

        public Connection activelyConnectTo(ProcessInstance processInstance) throws PeerMessagingException, InterruptedException {
            try {
                Log.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo(" + processInstance + ")");
                Connection connection = this.fMatlabPoolConnector.activelyConnectTo(processInstance);
                Log.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo will return " + connection);
                return connection;
            }
            catch (PeerMessagingException | RuntimeException exception) {
                ConnectionManager.handleTrappedThrowable(exception);
                throw exception;
            }
        }

        @Override
        public void close() {
            this.fMatlabPoolConnector.close();
        }

        public MatlabPoolPeerInstance getLocalInstance() {
            return this.fMatlabPoolConnector.getLocalInstance();
        }

        public String toString() {
            return "Connector{fMatlabPoolConnector=" + this.fMatlabPoolConnector + '}';
        }
    }

    public static final class Acceptor
    implements AutoCloseable {
        private final MatlabPoolAcceptor fMatlabPoolAcceptor;

        private Acceptor(MatlabPoolAcceptor matlabPoolAcceptor) {
            this.fMatlabPoolAcceptor = matlabPoolAcceptor;
        }

        public ConnectInfo getInfoToConnect() {
            return this.fMatlabPoolAcceptor.getInfoToConnect();
        }

        public MatlabPoolPeerInstance getLocalInstance() {
            return this.fMatlabPoolAcceptor.getLocalInstance();
        }

        public Connection activelyAccept() throws InterruptedException {
            return this.fMatlabPoolAcceptor.activelyAccept();
        }

        @Override
        public void close() {
            this.fMatlabPoolAcceptor.close();
        }

        public String toString() {
            return "Acceptor{fMatlabPoolAcceptor=" + this.fMatlabPoolAcceptor + '}';
        }
    }
}

