/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerPassiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.Log;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolAcceptor;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

final class MatlabPoolServerSocketAcceptor
extends MatlabPoolAcceptor {
    private final PeerPassiveAcceptor fPeerAcceptor;
    private final BlockingDeque<Connection> fConnectionQueue = new LinkedBlockingDeque<Connection>();
    private final MatlabPoolPeerInstance fLocalPeer;

    MatlabPoolServerSocketAcceptor(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws PeerMessagingException {
        super(matlabPoolPeerInstance);
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fPeerAcceptor = new PeerPassiveAcceptor(string, matlabPoolPeerInstance, serverSocketAcceptInfo);
        this.fPeerAcceptor.startAccepting(new MatlabpoolConnectionHandler(this.fConnectionQueue));
        Log.LOGGER.log(DistcompLevel.THREE, "MatlabPoolServerSocketAcceptor (" + matlabPoolPeerInstance + ") constructed.");
    }

    @Override
    ConnectInfo getInfoToConnect() {
        return this.fPeerAcceptor.getInfoToConnect();
    }

    @Override
    Connection activelyAccept() throws InterruptedException {
        try {
            return this.fConnectionQueue.pollLast(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.TWO, "MatlabPoolServerSocketAcceptor for " + this.fLocalPeer + " interrupted during activelyAccept.", interruptedException);
            throw interruptedException;
        }
    }

    @Override
    void close() {
        this.fPeerAcceptor.close();
    }

    public String toString() {
        return "MatlabPoolServerSocketAcceptor{, fLocalPeer=" + this.fLocalPeer + ", fPeerAcceptor=" + this.fPeerAcceptor + '}';
    }

    private static final class MatlabpoolConnectionHandler
    implements PeerPassiveAcceptor.ConnectionHandler {
        private final BlockingDeque<Connection> fConnectionQueue;

        MatlabpoolConnectionHandler(BlockingDeque<Connection> blockingDeque) {
            this.fConnectionQueue = blockingDeque;
        }

        @Override
        public void newConnection(Connection connection) {
            this.fConnectionQueue.addFirst(connection);
        }
    }
}

