/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import java.util.UUID;

public final class ServerSocketAcceptInfo
implements AcceptInfo {
    public static final int DEFAULT_BACKLOG = 10;
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_STEP = 1;
    public static final int DEFAULT_CONNECT_ATTEMPTS = 5;
    public static final long DEFAULT_JOIN_TIME_LIMIT = 60000L;
    public static final long DEFAULT_ACCEPT_POLL_INTERVAL = 1000L;
    private final Class<? extends CommunicationGroup> fCommunicationGroupClass;
    private final UUID fGroupUuid;
    private final AcceptorSecurityDescription fSecurityDescription;
    private final long fAcceptPollInterval;
    private final int fMinPort;
    private final int fMaxPort;
    private final int fPortOffset;
    private final int fPortStep;
    private final int fBacklog;
    private final long fJoinTimeLimit;
    private final long fDeadline;
    private final int fConnectAttempts;
    private static final UUID TEMPLATE_UUID = new UUID(0L, 0L);
    private static final AcceptorSecurityDescription TEMPLATE_SECURITY_DESCRIPTION = null;

    private ServerSocketAcceptInfo(Class<? extends CommunicationGroup> clazz, UUID uUID, int n, int n2, int n3, int n4, int n5, AcceptorSecurityDescription acceptorSecurityDescription, long l, long l2, int n6, long l3) {
        if (n4 <= 0) {
            throw new IllegalArgumentException("portStep must be greater than zero but is " + n4);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("portOffset must be zero or greater but is " + n3);
        }
        if (n + n3 > n2) {
            throw new IllegalArgumentException("minPort " + n + " plus portOffset must be less than or equal to maxPort " + n2);
        }
        if (l <= l2) {
            throw new IllegalArgumentException("joinTimeLimit " + l + " must be greater than acceptPollInterval" + l2);
        }
        this.fCommunicationGroupClass = clazz;
        this.fGroupUuid = uUID;
        this.fSecurityDescription = acceptorSecurityDescription;
        this.fAcceptPollInterval = l2;
        this.fMinPort = n;
        this.fMaxPort = n2;
        this.fPortOffset = n3;
        this.fPortStep = n4;
        this.fBacklog = n5;
        this.fJoinTimeLimit = l;
        this.fDeadline = l3;
        this.fConnectAttempts = n6;
    }

    @Override
    public UUID getGroupUUID() {
        return this.fGroupUuid;
    }

    @Override
    public Class<? extends CommunicationGroup> getGroupImplementation() {
        return this.fCommunicationGroupClass;
    }

    @Override
    public boolean hasExpired() {
        return JoinInfo.DeadlineHelper.hasExpired(this);
    }

    @Override
    public long getRemainingTime() {
        return JoinInfo.DeadlineHelper.getRemainingTime(this);
    }

    @Override
    public AcceptorSecurityDescription getAcceptorSecurityDescription() {
        return this.fSecurityDescription;
    }

    @Override
    public long getDeadline() {
        return this.fDeadline;
    }

    @Override
    public long getHandShakeDeadline() {
        return JoinInfo.DeadlineHelper.getReasonableHandShakeDeadline(this);
    }

    @Override
    public long getJoinTimeLimit() {
        return this.fJoinTimeLimit;
    }

    @Override
    public ServerSocketAcceptInfo createCopyWithReasonableDeadline() {
        return (ServerSocketAcceptInfo)JoinInfo.DeadlineHelper.createCopyWithReasonableDeadline(this);
    }

    @Override
    public int getNumberOfAttempts() {
        return this.fConnectAttempts;
    }

    public long getAcceptTimeout() {
        return this.fAcceptPollInterval;
    }

    public int getMinPort() {
        return this.fMinPort;
    }

    public int getMaxPort() {
        return this.fMaxPort;
    }

    public int getPortOffset() {
        return this.fPortOffset;
    }

    public int getPortStep() {
        return this.fPortStep;
    }

    public int getBacklog() {
        return this.fBacklog;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " for group " + this.fGroupUuid;
    }

    @Override
    public boolean peersConnectingAsGroupShareBarrier() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerSocketAcceptInfo serverSocketAcceptInfo = (ServerSocketAcceptInfo)object;
        if (this.fBacklog != serverSocketAcceptInfo.fBacklog) {
            return false;
        }
        if (this.fConnectAttempts != serverSocketAcceptInfo.fConnectAttempts) {
            return false;
        }
        if (this.fDeadline != serverSocketAcceptInfo.fDeadline) {
            return false;
        }
        if (this.fJoinTimeLimit != serverSocketAcceptInfo.fJoinTimeLimit) {
            return false;
        }
        if (this.fMaxPort != serverSocketAcceptInfo.fMaxPort) {
            return false;
        }
        if (this.fMinPort != serverSocketAcceptInfo.fMinPort) {
            return false;
        }
        if (this.fPortOffset != serverSocketAcceptInfo.fPortOffset) {
            return false;
        }
        if (this.fPortStep != serverSocketAcceptInfo.fPortStep) {
            return false;
        }
        if (this.fGroupUuid != null ? !this.fGroupUuid.equals(serverSocketAcceptInfo.fGroupUuid) : serverSocketAcceptInfo.fGroupUuid != null) {
            return false;
        }
        return !(this.fSecurityDescription != null ? !this.fSecurityDescription.equals(serverSocketAcceptInfo.fSecurityDescription) : serverSocketAcceptInfo.fSecurityDescription != null);
    }

    public int hashCode() {
        int n = this.fGroupUuid != null ? this.fGroupUuid.hashCode() : 0;
        n = 31 * n + (this.fSecurityDescription != null ? this.fSecurityDescription.hashCode() : 0);
        n = 31 * n + this.fMinPort;
        n = 31 * n + this.fMaxPort;
        n = 31 * n + this.fPortOffset;
        n = 31 * n + this.fPortStep;
        n = 31 * n + this.fBacklog;
        n = 31 * n + (int)(this.fJoinTimeLimit ^ this.fJoinTimeLimit >>> 32);
        n = 31 * n + (int)(this.fDeadline ^ this.fDeadline >>> 32);
        n = 31 * n + this.fConnectAttempts;
        return n;
    }

    public String toString() {
        return "ServerSocketAcceptInfo{fGroupUuid=" + this.fGroupUuid + ", fSecurityDescription=" + this.fSecurityDescription + ", fMinPort=" + this.fMinPort + ", fMaxPort=" + this.fMaxPort + ", fPortOffset=" + this.fPortOffset + ", fPortStep=" + this.fPortStep + ", fBacklog=" + this.fBacklog + ", fJoinTimeLimit=" + this.fJoinTimeLimit + ", fDeadline=" + this.fDeadline + ", fConnectAttempts=" + this.fConnectAttempts + '}';
    }

    public static ServerSocketAcceptInfo createTemplate(Class<? extends CommunicationGroup> clazz, int n, int n2, long l, int n3) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(clazz, TEMPLATE_UUID, n, n2, 0, 1, n3, TEMPLATE_SECURITY_DESCRIPTION, l, 1000L, 5, 0L);
    }

    public ServerSocketAcceptInfo createFromTemplate(UUID uUID, AcceptorSecurityDescription acceptorSecurityDescription, long l, long l2, long l3) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(this.fCommunicationGroupClass, uUID, this.fMinPort, this.fMaxPort, this.fPortOffset, this.fPortStep, this.fBacklog, acceptorSecurityDescription, l, l2, this.fConnectAttempts, l3);
    }

    public ServerSocketAcceptInfo createWithNewPortOffsetAndStep(int n, int n2) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(this.fCommunicationGroupClass, this.fGroupUuid, this.fMinPort, this.fMaxPort, n, n2, this.fBacklog, this.fSecurityDescription, this.fJoinTimeLimit, this.fAcceptPollInterval, this.fConnectAttempts, this.fDeadline);
    }

    @Override
    public ServerSocketAcceptInfo createCopyReplaceDeadline(long l) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(this.fCommunicationGroupClass, this.fGroupUuid, this.fMinPort, this.fMaxPort, this.fPortOffset, this.fPortStep, this.fBacklog, this.fSecurityDescription, this.fJoinTimeLimit, this.fAcceptPollInterval, this.fConnectAttempts, l);
    }

    public ServerSocketAcceptInfo createCopyReplaceGroupImplementation(Class<? extends CommunicationGroup> clazz) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(clazz, this.fGroupUuid, this.fMinPort, this.fMaxPort, this.fPortOffset, this.fPortStep, this.fBacklog, this.fSecurityDescription, this.fJoinTimeLimit, this.fAcceptPollInterval, this.fConnectAttempts, this.fDeadline);
    }

    public static ServerSocketAcceptInfo createServerSocketAcceptInfo(Class<? extends CommunicationGroup> clazz, UUID uUID, int n, int n2, int n3, int n4, int n5, AcceptorSecurityDescription acceptorSecurityDescription, long l, long l2, int n6, long l3) {
        return new ServerSocketAcceptInfo(clazz, uUID, n, n2, n3, n4, n5, acceptorSecurityDescription, l, l2, n6, l3);
    }

    public static ServerSocketAcceptInfo createServerSocketAcceptInfo(Class<? extends CommunicationGroup> clazz, UUID uUID, int n, int n2, AcceptorSecurityDescription acceptorSecurityDescription, long l, long l2, int n3, long l3) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(clazz, uUID, n, n, 0, 1, n2, acceptorSecurityDescription, l, l2, n3, l3);
    }

    public static ServerSocketAcceptInfo createServerSocketAcceptInfo(Class<? extends CommunicationGroup> clazz, UUID uUID, int n, int n2, AcceptorSecurityDescription acceptorSecurityDescription) {
        return ServerSocketAcceptInfo.createServerSocketAcceptInfo(clazz, uUID, n, n, 0, 1, n2, acceptorSecurityDescription, 60000L, 1000L, 5, Long.MAX_VALUE);
    }
}

