/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.DefaultTaskEvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.DefaultTaskQueueRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Log;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FevalEvaluationRequest
extends DefaultTaskQueueRequest {
    private static final String TASK_EVALUATION_FUNCTION = "parallel.internal.queue.evaluateRequest";
    private static final int TASK_EVALUATION_FUNCTION_NARGSOUT = 2;
    private static final String REQUEST_ADDITIONAL_SOURCES_FUNCTION = "parallel.internal.queue.addSources";
    private static final String CLASS = "FevalEvaluationRequest";

    FevalEvaluationRequest(long l, Object object) {
        super(l, object);
    }

    @Override
    public Future<Object> evaluate(SessionService sessionService, Writer writer, Writer writer2) {
        Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequest about to invoke parallel.internal.queue.evaluateRequest for task with ID " + this.getTaskID());
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)("FevalEvaluationRequest TASK_EXECUTOR(" + this.getTaskID() + ")-"), (Logger)Log.LOGGER));
        FutureTask<Object> futureTask = new FutureTask<Object>(new EvaluationWithRetry(sessionService, writer, writer2));
        executorService.execute(futureTask);
        executorService.shutdown();
        return futureTask;
    }

    public synchronized ByteBufferHandle[] getBuffersForDeserialization() {
        ByteBufferHandle[] byteBufferHandleArray = this.getByteBuffers();
        ByteBufferHandle[] byteBufferHandleArray2 = new ByteBufferHandle[byteBufferHandleArray.length];
        for (int i = 0; i < byteBufferHandleArray.length; ++i) {
            byteBufferHandleArray2[i] = byteBufferHandleArray[i].duplicate();
        }
        return byteBufferHandleArray2;
    }

    @Override
    public EvaluationResult buildResult(long l, long l2, Object object, Throwable throwable) {
        return new DefaultTaskEvaluationResult(l, l2, object, throwable);
    }

    private final class EvaluationWithRetry
    implements Callable<Object> {
        private final SessionService fService;
        private final Writer fOutWriter;
        private final Writer fErrWriter;

        private EvaluationWithRetry(SessionService sessionService, Writer writer, Writer writer2) {
            this.fService = sessionService;
            this.fOutWriter = writer;
            this.fErrWriter = writer2;
        }

        private boolean isMissingSourceProblem(Object object) {
            Object[] objectArray;
            Log.LOGGER.log(DistcompLevel.THREE, "FevalEvaluationRequest entering isMissingSourceProblem()");
            if (object instanceof Object[] && (objectArray = (Object[])object).length == 2 && objectArray[0] instanceof double[]) {
                double[] dArray = (double[])objectArray[0];
                int n = dArray.length == 1 ? (int)dArray[0] : 1;
                Log.LOGGER.log(DistcompLevel.THREE, "FevalEvaluationRequest in isMissingSourceProblem() - found return code: " + n);
                return n == 2 || n == 3;
            }
            Log.LOGGER.log(DistcompLevel.THREE, "FevalEvaluationRequest isMissingSourceProblem() failed to interpret return from MATLAB.");
            return false;
        }

        private Future<Object> initiate() {
            return MatlabRefStore.getMVMRef().getExecutor().submit(new MatlabFevalRequest(FevalEvaluationRequest.TASK_EVALUATION_FUNCTION, Integer.valueOf(2), this.fOutWriter, this.fErrWriter, new Object[]{FevalEvaluationRequest.this.getAllData()}));
        }

        private void requestMissingSourcesAndAwaitTheirArrival(Object object) throws InterruptedException {
            final Semaphore semaphore = new Semaphore(0);
            this.fService.getRoleCommGroup().sendTo(ProcessInstance.getClientInstance(), (ObservableMessage)new RequestAdditionalSources(FevalEvaluationRequest.this.getTaskID(), object), new RoleMessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                    Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequest, in requestMissingSourcesAndAwaitTheirArrival .... completed()");
                    EvaluationWithRetry.this.logDetailsOfReturnMessage(returnMessage);
                    semaphore.release();
                }

                @Override
                public void aborted(long l, ProcessInstance processInstance) {
                    Log.LOGGER.log(DistcompLevel.ONE, "FevalEvaluationRequest, in requestMissingSourcesAndAwaitTheirArrival .... aborted()");
                    semaphore.release();
                }

                @Override
                public void expectReturnsFrom(long l, List<ProcessInstance> list) {
                    if (list.isEmpty()) {
                        Log.LOGGER.log(DistcompLevel.ONE, "FevalEvaluationRequest, in requestMissingSourcesAndAwaitTheirArrival .... no source processes!");
                        semaphore.release();
                    }
                }
            });
            semaphore.acquire();
        }

        private void logDetailsOfReturnMessage(ReturnMessage returnMessage) {
            if (returnMessage instanceof TrivialReturnMessage) {
                TrivialReturnMessage trivialReturnMessage = (TrivialReturnMessage)returnMessage;
                if (trivialReturnMessage.getProblem() == null) {
                    Log.LOGGER.info("requestMissingSourcesAndAwaitTheirArrival appeared to complete normally.");
                } else {
                    Log.LOGGER.log(Level.WARNING, "requestMissingSourcesAndAwaitTheirArrival encountered a problem.", trivialReturnMessage.getProblem());
                }
            } else {
                Log.LOGGER.info("requestMissingSourcesAndAwaitTheirArrival received: " + returnMessage);
            }
        }

        private Object invokeAndGet() throws ExecutionException, InterruptedException {
            Future<Object> future = this.initiate();
            try {
                return future.get();
            }
            catch (InterruptedException interruptedException) {
                future.cancel(true);
                throw interruptedException;
            }
        }

        @Override
        public Object call() throws Exception {
            Log.LOGGER.log(DistcompLevel.ONE, "FevalEvaluationRequest, In EvaluationWithRetry.call()");
            try {
                Object object = this.invokeAndGet();
                if (this.isMissingSourceProblem(object)) {
                    this.requestMissingSourcesAndAwaitTheirArrival(object);
                    Object object2 = this.invokeAndGet();
                    return object2;
                }
                Object object3 = object;
                return object3;
            }
            catch (Error | Exception throwable) {
                Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequestEvaluationWithRetry.call() for task " + FevalEvaluationRequest.this.getTaskID() + " caught an error.", throwable);
                throw throwable;
            }
            finally {
                ByteBufferHandle.freeBuffers(FevalEvaluationRequest.this.getBuffersForDeserialization());
            }
        }
    }

    private static final class RequestAdditionalSources
    extends MDispatchableCommand {
        private final long fTaskID;
        private final Object fEvaluationResult;

        private RequestAdditionalSources(long l, Object object) {
            this.fTaskID = l;
            this.fEvaluationResult = object;
        }

        @Override
        public void dispatch(final ReturnGroup returnGroup, final Instance instance, SessionService sessionService) {
            Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequest.dispatch(), about to request sources for: " + this.fTaskID);
            final TrivialReturnMessage trivialReturnMessage = new TrivialReturnMessage(this.getSequenceNumber(), null);
            MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

                public Object runOnMatlabThread() {
                    Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequest.runOnMatlabThread() about to feval.");
                    try {
                        1.feval((String)FevalEvaluationRequest.REQUEST_ADDITIONAL_SOURCES_FUNCTION, (Object[])new Object[]{RequestAdditionalSources.this.fTaskID, RequestAdditionalSources.this.fEvaluationResult}, (int)0);
                    }
                    catch (Exception exception) {
                        Log.LOGGER.log(DistcompLevel.ZERO, "FevalEvaluationRequest.runOnMatlabThread() failed to feval.", exception);
                        trivialReturnMessage.setProblem(exception);
                    }
                    Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequest.runOnMatlabThread() did feval.");
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    Log.LOGGER.log(DistcompLevel.TWO, "FevalEvaluationRequest.runOnAWTEventDispatchThread() about to return a message.");
                    returnGroup.returnTo(instance, (ReturnMessage)trivialReturnMessage);
                }
            };
            matlabWorker.start();
        }
    }

    private static final class TrivialReturnMessage
    implements ReturnMessage {
        private final long fSequence;
        private Exception fProblem;

        private TrivialReturnMessage(long l, Exception exception) {
            this.fSequence = l;
            this.fProblem = exception;
        }

        @Override
        public long getOriginalSequenceNumber() {
            return this.fSequence;
        }

        public Exception getProblem() {
            return this.fProblem;
        }

        private void setProblem(Exception exception) {
            this.fProblem = exception;
        }
    }
}

