/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.taskqueue.PlainTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskCompletionWaiter;
import com.mathworks.toolbox.parallel.util.resourcemanagement.DisposableObjectWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TaskFetchNextHelper {
    private final List<Long> fTaskIDs;
    private final List<PlainTask> fRawTasks;
    private final TaskCompletionWaiter fWaiter;
    private static final int NOTHING_AVAILABLE = -1;

    public static TaskFetchNextHelper build(TaskCompletionWaiter taskCompletionWaiter, DisposableObjectWrapper<PlainTask>[] disposableObjectWrapperArray) {
        return new TaskFetchNextHelper(taskCompletionWaiter, Arrays.asList(disposableObjectWrapperArray));
    }

    public static TaskFetchNextHelper build(TaskCompletionWaiter taskCompletionWaiter, DisposableObjectWrapper<PlainTask> disposableObjectWrapper) {
        return new TaskFetchNextHelper(taskCompletionWaiter, Arrays.asList(disposableObjectWrapper));
    }

    private TaskFetchNextHelper(TaskCompletionWaiter taskCompletionWaiter, List<DisposableObjectWrapper<PlainTask>> list) {
        this.fWaiter = taskCompletionWaiter;
        this.fTaskIDs = new ArrayList<Long>(list.size());
        this.fRawTasks = new ArrayList<PlainTask>(list.size());
        for (DisposableObjectWrapper<PlainTask> disposableObjectWrapper : list) {
            if (disposableObjectWrapper.isDisposed()) {
                this.fTaskIDs.add(-1L);
                this.fRawTasks.add(null);
                continue;
            }
            this.fTaskIDs.add(((PlainTask)disposableObjectWrapper.getResource()).getID());
            this.fRawTasks.add((PlainTask)disposableObjectWrapper.getResource());
        }
    }

    public boolean anyCandidatesToAwait() {
        for (PlainTask plainTask : this.fRawTasks) {
            if (plainTask == null || plainTask.getState() == Task.State.PENDING || plainTask.getReadFlag().get()) continue;
            return true;
        }
        return false;
    }

    private int getIndexIfPossible() {
        for (int i = 0; i < this.fRawTasks.size(); ++i) {
            PlainTask plainTask = this.fRawTasks.get(i);
            if (plainTask == null || plainTask.getState() != Task.State.FINISHED || plainTask.getReadFlag().get()) continue;
            return i;
        }
        return -1;
    }

    public int awaitNextCompletion(long l) throws InterruptedException {
        int n = this.getIndexIfPossible();
        if (n != -1) {
            return n;
        }
        if (l == 0L) {
            return -1;
        }
        long l2 = this.fWaiter.awaitTaskCompletion(l, TimeUnit.MILLISECONDS);
        if (l2 == -1L) {
            return -1;
        }
        int n2 = this.fTaskIDs.indexOf(l2);
        if (n2 == -1) {
            return this.getIndexIfPossible();
        }
        return this.fRawTasks.get(n2).getReadFlag().get() ? this.getIndexIfPossible() : n2;
    }
}

