/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.BroadcastTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.CancellationRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.DefaultTaskEvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Log;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.PlainTask;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.RemoteBroadcastFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.RemotePlainFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.ResourcesUnavailableException;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskCompletionListener;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskDiaryMessage;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskQueue;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import com.mathworks.toolbox.parallel.util.resourcemanagement.DisposableObjectWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class TaskQueueImpl
implements TaskQueue,
CommunicationObserver {
    private static final String CLASS = TaskQueueImpl.class.getSimpleName();
    private final ReentrantLock fSubmissionLock = new ReentrantLock();
    private final Map<Long, Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor>> fIncompleteRequests = new HashMap<Long, Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor>>();
    private final ReentrantLock fWorkerListsLock = new ReentrantLock();
    private final List<Instance> fAcquiredWorkers = new LinkedList<Instance>();
    private final BlockingQueue<Instance> fAvailableWorkers = new LinkedBlockingQueue<Instance>();
    private int fNumLabsNotified = 0;
    private final ExecutorService fQueueExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(CLASS + " fQueueExecutor-"), (Logger)Log.LOGGER));
    private final Set<TaskCompletionListener> fTaskCompletionListeners = Collections.synchronizedSet(new HashSet());
    private final CommunicationGroup fCommGroup;
    private final SessionService fSession;
    private static final long DEFAULT_WORKER_ACQUISITION_TIMEOUT_MILLIS = 30000L;
    private long fWorkerAcquisitionTimeoutMillis = 30000L;

    public TaskQueueImpl(SessionService sessionService, CommunicationGroup communicationGroup) {
        this.fSession = sessionService;
        this.fCommGroup = communicationGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumWorkers() {
        this.fWorkerListsLock.lock();
        try {
            int n = this.fAcquiredWorkers.size();
            return n;
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    @Override
    public void submit(DisposableObjectWrapper<PlainTask> disposableObjectWrapper) throws CancellationException {
        DisposableObjectWrapper disposableObjectWrapper2 = disposableObjectWrapper.duplicate();
        this.addTaskToQueue((DisposableObjectWrapper<PlainTask>)disposableObjectWrapper2);
    }

    @Override
    public void broadcast(DisposableObjectWrapper<BroadcastTask> disposableObjectWrapper) throws CancellationException {
        DisposableObjectWrapper disposableObjectWrapper2 = disposableObjectWrapper.duplicate();
        this.addBroadcastTaskToQueue((DisposableObjectWrapper<BroadcastTask>)disposableObjectWrapper2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DisposableObjectWrapper<? extends Task>> getOutstandingTasks() {
        this.fSubmissionLock.lock();
        try {
            Collection<Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor>> collection = this.fIncompleteRequests.values();
            ArrayList<DisposableObjectWrapper> arrayList = new ArrayList<DisposableObjectWrapper>();
            for (Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor> pair : collection) {
                arrayList.add(pair.getFirst().duplicate());
            }
            ArrayList<DisposableObjectWrapper> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisposableObjectWrapper<? extends Task> getOutstandingTask(long l) {
        this.fSubmissionLock.lock();
        try {
            if (this.fIncompleteRequests.containsKey(l)) {
                Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor> pair = this.fIncompleteRequests.get(l);
                DisposableObjectWrapper disposableObjectWrapper = pair.getFirst().duplicate();
                return disposableObjectWrapper;
            }
            DisposableObjectWrapper<? extends Task> disposableObjectWrapper = null;
            return disposableObjectWrapper;
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    @Override
    public boolean isValid() {
        return !this.fQueueExecutor.isShutdown() && this.fSession.isSessionRunning();
    }

    @Override
    public void addTaskCompletionListener(TaskCompletionListener taskCompletionListener) {
        this.fTaskCompletionListeners.add(taskCompletionListener);
    }

    @Override
    public void removeTaskCompletionListener(TaskCompletionListener taskCompletionListener) {
        this.fTaskCompletionListeners.remove(taskCompletionListener);
    }

    public long setWorkerAcquisitionTimeout(long l) {
        long l2 = this.fWorkerAcquisitionTimeoutMillis;
        this.fWorkerAcquisitionTimeoutMillis = l;
        return l2;
    }

    private void fireTaskCompleted(Task task) {
        HashSet<TaskCompletionListener> hashSet = new HashSet<TaskCompletionListener>(this.fTaskCompletionListeners);
        for (TaskCompletionListener taskCompletionListener : hashSet) {
            taskCompletionListener.completed(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Log.LOGGER.log(DistcompLevel.TWO, CLASS + ".shutdown()");
        this.fQueueExecutor.shutdownNow();
        this.fSubmissionLock.lock();
        try {
            this.failAllOutstandingTasks();
            for (Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor> pair : this.fIncompleteRequests.values()) {
                pair.getFirst().dispose();
            }
            this.fIncompleteRequests.clear();
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    private void sendCancellationIfNecessary(long l, long l2, Instance instance) {
        if (instance != null) {
            this.fCommGroup.sendTo(instance, (Message)new CancellationRequest(l, l2));
        }
    }

    private void handleCancellation(long l) {
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + " cancellation of task ID " + l);
        this.handleTaskCleanup(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskReturn(long l, ReturnMessage returnMessage, Instance instance) {
        Log.LOGGER.log(DistcompLevel.FIVE, CLASS + ".handleTaskReturn(" + l + ", " + returnMessage.getClass() + ", " + instance + ")");
        if (!this.isValid()) {
            return;
        }
        this.fSubmissionLock.lock();
        try {
            if (!this.fIncompleteRequests.containsKey(l)) {
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + ".handleTaskReturn() ignoring message to dropped task.");
                return;
            }
            if (returnMessage instanceof EvaluationResult) {
                this.handleTaskResult(l, (EvaluationResult)returnMessage, instance);
            } else if (returnMessage instanceof TaskDiaryMessage) {
                this.handleTaskDiary(l, (TaskDiaryMessage)returnMessage, instance);
            } else {
                Log.LOGGER.log(DistcompLevel.ONE, CLASS + ".handleTaskReturn() got unexpected type of message!");
                assert (false);
            }
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWorkerRejectedTask(long l) {
        Log.LOGGER.log(DistcompLevel.FOUR, CLASS + ".handleWorkerRejectedTask(" + l + ")");
        this.fSubmissionLock.lock();
        try {
            assert (this.fIncompleteRequests.containsKey(l));
            DisposableObjectWrapper<? extends Task> disposableObjectWrapper = this.fIncompleteRequests.get(l).getFirst();
            if (disposableObjectWrapper.getResource() instanceof PlainTask) {
                DisposableObjectWrapper<? extends Task> disposableObjectWrapper2 = disposableObjectWrapper;
                this.addTaskToQueue(disposableObjectWrapper2);
            } else assert (false) : "Unexpectedly entered handleWorkerRejectedTask for non-PlainTask.";
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    private void handleWorkerRejectedBroadcastTask(long l, long l2, Instance instance) {
        Log.LOGGER.log(DistcompLevel.ONE, CLASS + ".handleWorkerRejectedBroadcastTask noticed rejection of ID " + l2 + " by " + instance);
        DefaultTaskEvaluationResult defaultTaskEvaluationResult = new DefaultTaskEvaluationResult(l, l2, null, new BroadcastRequestNotSentException());
        this.handleTaskResult(l2, defaultTaskEvaluationResult, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskDiary(long l, TaskDiaryMessage taskDiaryMessage, Instance instance) {
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + " got task diary output from " + instance + " for task " + l);
        this.fSubmissionLock.lock();
        try {
            RemoteFutureAdaptor remoteFutureAdaptor = this.fIncompleteRequests.get(l).getSecond();
            assert (remoteFutureAdaptor != null);
            remoteFutureAdaptor.appendDiary(taskDiaryMessage.getString(), instance);
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskResult(long l, EvaluationResult evaluationResult, Instance instance) {
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + " got task result for ID " + l + ", " + evaluationResult);
        this.fSubmissionLock.lock();
        try {
            assert (this.fIncompleteRequests.containsKey(l));
            RemoteFutureAdaptor remoteFutureAdaptor = this.fIncompleteRequests.get(l).getSecond();
            boolean bl = remoteFutureAdaptor.setResult(evaluationResult, instance);
            if (bl) {
                this.handleTaskCleanup(l, true);
            }
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskCleanup(long l, boolean bl) {
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + " Dropping references to " + l);
        this.fSubmissionLock.lock();
        try {
            boolean bl2;
            Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor> pair = this.fIncompleteRequests.remove(l);
            boolean bl3 = bl2 = pair != null;
            if (bl2) {
                this.makeWorkersAvailable(pair.getSecond().getWorkers());
                this.fireTaskCompleted((Task)pair.getFirst().getResource());
                Log.LOGGER.log(DistcompLevel.THREE, CLASS + ".handleTaskCleanup disposing task: " + pair.getFirst());
                pair.getFirst().dispose();
            } else {
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + ".handleTaskCleanup() for unknown task " + l);
            }
            int n = this.fIncompleteRequests.size();
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + " fIncompleteRequests now contains: " + n);
            if (n > 0) {
                Log.LOGGER.log(DistcompLevel.THREE, CLASS + " next to run is ID: " + this.fIncompleteRequests.keySet().iterator().next());
            }
            if (bl && n == 0) {
                Log.LOGGER.log(DistcompLevel.THREE, CLASS + " about to release workers.");
                this.releaseWorkers();
            }
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    private int acquireWorkers() throws InterruptedException, ResourcesUnavailableException {
        this.fWorkerListsLock.lock();
        try {
            int n = this.fAcquiredWorkers.size();
            if (n > 0) {
                int n2 = n;
                return n2;
            }
            Object object = this.fSession.getResourceManager().acquireCurrentHolderToken(this.fWorkerAcquisitionTimeoutMillis);
            if (object == null) {
                Log.LOGGER.log(DistcompLevel.ONE, CLASS + " failed to acquire the token.");
                throw new ResourcesUnavailableException();
            }
            this.fSession.getResourceManager().setCurrentHolder(this, object);
            List<Instance> list = this.fCommGroup.getConnectedInstances();
            if (list.isEmpty()) {
                Log.LOGGER.log(DistcompLevel.ONE, CLASS + " got the token, but there were no workers.");
                throw new ResourcesUnavailableException();
            }
            this.fAcquiredWorkers.addAll(list);
            this.fAvailableWorkers.addAll(this.fAcquiredWorkers);
            Log.LOGGER.info(CLASS + " acquired: " + this.fAcquiredWorkers.size() + " workers");
            int n3 = this.fAcquiredWorkers.size();
            this.notifyAcquiredWorkers(n3);
            int n4 = n3;
            return n4;
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(DistcompLevel.ONE, CLASS + " interrupted during acquireWorkers", interruptedException);
            throw interruptedException;
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWorkers() {
        boolean bl = false;
        this.fWorkerListsLock.lock();
        try {
            Log.LOGGER.info(CLASS + "releasing " + this.fAcquiredWorkers.size() + " workers.");
            bl = !this.fAcquiredWorkers.isEmpty();
            this.fAcquiredWorkers.clear();
            this.fAvailableWorkers.clear();
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
        this.notifyReleaseWorkers();
        if (bl) {
            this.fSession.getResourceManager().releaseCurrentHolder(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeWorkersAvailable(Collection<Instance> collection) {
        this.fWorkerListsLock.lock();
        try {
            HashSet<Instance> hashSet = new HashSet<Instance>(collection);
            boolean bl = hashSet.retainAll(this.fAcquiredWorkers);
            if (bl) {
                HashSet<Instance> hashSet2 = new HashSet<Instance>(collection);
                hashSet2.removeAll(this.fAcquiredWorkers);
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + ".makeWorkersAvailable() returning: " + hashSet);
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + ".makeWorkersAvailable() not returning: " + hashSet2);
            } else {
                Log.LOGGER.log(DistcompLevel.THREE, CLASS + ".makeWorkersAvailable() returning all " + collection);
            }
            this.fAvailableWorkers.addAll(hashSet);
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkGotAllWorkers(Collection<Instance> collection) {
        this.fWorkerListsLock.lock();
        try {
            boolean bl = collection.containsAll(this.fAcquiredWorkers);
            return bl;
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAcquiredWorkers(int n) {
        this.fWorkerListsLock.lock();
        try {
            if (n == 0 && this.fNumLabsNotified > 0) {
                this.notifyReleaseWorkers();
            } else {
                this.fNumLabsNotified = n;
                this.fSession.getSessionWorkerNotifier().notifyAcquiredWorkers(n);
            }
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReleaseWorkers() {
        this.fWorkerListsLock.lock();
        try {
            if (this.fNumLabsNotified > 0) {
                this.fSession.getSessionWorkerNotifier().notifyReleasedWorkers(this.fNumLabsNotified);
                this.fNumLabsNotified = 0;
            }
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void communicationLost(Instance instance, Throwable throwable) {
        this.fWorkerListsLock.lock();
        try {
            this.fAcquiredWorkers.remove(instance);
            if (this.fNumLabsNotified > 0) {
                int n = this.fNumLabsNotified;
                this.notifyAcquiredWorkers(n - 1);
            }
        }
        finally {
            this.fWorkerListsLock.unlock();
        }
    }

    @Override
    public void communicationEstablished(Instance instance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllOutstandingTasks() {
        this.fSubmissionLock.lock();
        try {
            ArrayList<Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor>> arrayList = new ArrayList<Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor>>(this.fIncompleteRequests.values());
            for (Pair pair : arrayList) {
                ((Task)((DisposableObjectWrapper)pair.getFirst()).getResource()).cancel(new ResourcesUnavailableException());
            }
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCommon(DisposableObjectWrapper<? extends Task> disposableObjectWrapper, RemoteFutureAdaptor remoteFutureAdaptor, Callable<TaskDispatchCompletionResult> callable) {
        this.fSubmissionLock.lock();
        try {
            final long l = ((Task)disposableObjectWrapper.getResource()).getID();
            this.fIncompleteRequests.put(l, new Pair<DisposableObjectWrapper<? extends Task>, RemoteFutureAdaptor>(disposableObjectWrapper, remoteFutureAdaptor));
            Log.LOGGER.log(DistcompLevel.TWO, CLASS + ".submitCommon added task with ID: " + l + ", size now: " + this.fIncompleteRequests.size());
            remoteFutureAdaptor.setQueued();
            final Future<TaskDispatchCompletionResult> future = this.fQueueExecutor.submit(callable);
            remoteFutureAdaptor.addCancelTask(new Runnable(){

                @Override
                public void run() {
                    Log.LOGGER.log(DistcompLevel.THREE, CLASS + ".submitCommon cancel task executing for ID: " + l);
                    future.cancel(true);
                    TaskQueueImpl.this.handleCancellation(l);
                }
            });
        }
        finally {
            this.fSubmissionLock.unlock();
        }
    }

    private void addTaskToQueue(DisposableObjectWrapper<PlainTask> disposableObjectWrapper) {
        DispatchPlainTaskToWorker dispatchPlainTaskToWorker = new DispatchPlainTaskToWorker(((PlainTask)disposableObjectWrapper.getResource()).getID());
        PlainFutureAdaptor plainFutureAdaptor = new PlainFutureAdaptor(((PlainTask)disposableObjectWrapper.getResource()).getRemoteFuture());
        this.submitCommon(disposableObjectWrapper, plainFutureAdaptor, dispatchPlainTaskToWorker);
    }

    private void addBroadcastTaskToQueue(DisposableObjectWrapper<BroadcastTask> disposableObjectWrapper) {
        DispatchBroadcastTaskToWorkers dispatchBroadcastTaskToWorkers = new DispatchBroadcastTaskToWorkers(((BroadcastTask)disposableObjectWrapper.getResource()).getID());
        BroadcastFutureAdaptor broadcastFutureAdaptor = new BroadcastFutureAdaptor(((BroadcastTask)disposableObjectWrapper.getResource()).getRemoteFuture());
        this.submitCommon(disposableObjectWrapper, broadcastFutureAdaptor, dispatchBroadcastTaskToWorkers);
    }

    private static class BroadcastFutureAdaptor
    implements RemoteFutureAdaptor {
        private final RemoteBroadcastFuture fUnderlying;

        private BroadcastFutureAdaptor(RemoteBroadcastFuture remoteBroadcastFuture) {
            this.fUnderlying = remoteBroadcastFuture;
        }

        @Override
        public void appendDiary(String string, Instance instance) {
            this.fUnderlying.appendDiary(string, instance);
        }

        @Override
        public boolean setResult(EvaluationResult evaluationResult, Instance instance) {
            return this.fUnderlying.setResult(evaluationResult, instance);
        }

        @Override
        public Collection<Instance> getWorkers() {
            return this.fUnderlying.getWorkers();
        }

        @Override
        public void startedRunning(List<Instance> list) {
            this.fUnderlying.startedRunning(list);
        }

        @Override
        public void addCancelTask(Runnable runnable) {
            this.fUnderlying.addCancelTask(runnable);
        }

        @Override
        public void setQueued() {
            this.fUnderlying.setQueued();
        }
    }

    private static class PlainFutureAdaptor
    implements RemoteFutureAdaptor {
        private final RemotePlainFuture fUnderlying;

        private PlainFutureAdaptor(RemotePlainFuture remotePlainFuture) {
            this.fUnderlying = remotePlainFuture;
        }

        @Override
        public void appendDiary(String string, Instance instance) {
            assert (instance.equals(this.fUnderlying.getWorker()));
            this.fUnderlying.appendDiary(string);
        }

        @Override
        public boolean setResult(EvaluationResult evaluationResult, Instance instance) {
            assert (instance.equals(this.fUnderlying.getWorker()));
            return this.fUnderlying.setResult(evaluationResult);
        }

        @Override
        public Collection<Instance> getWorkers() {
            return Arrays.asList(this.fUnderlying.getWorker());
        }

        @Override
        public void startedRunning(List<Instance> list) {
            assert (list.size() == 1);
            this.fUnderlying.startedRunning(list.get(0));
        }

        @Override
        public void addCancelTask(Runnable runnable) {
            this.fUnderlying.addCancelTask(runnable);
        }

        @Override
        public void setQueued() {
            this.fUnderlying.setQueued();
        }
    }

    private final class DispatchPlainTaskToWorker
    extends DispatchTaskToWorker {
        private DispatchPlainTaskToWorker(long l) {
            super(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TaskDispatchCompletionResult doDispatch() {
            Log.LOGGER.log(DistcompLevel.FIVE, "DispatchOneTaskToIdleWorker.doDispatch() about to chooseWorker");
            final Instance instance = this.chooseWorkerOrNullIfCancelled();
            Log.LOGGER.log(DistcompLevel.FIVE, "DispatchOneTaskToIdleWorker.doDispatch() chose worker: " + instance);
            if (instance == null) {
                return TaskDispatchCompletionResult.CANCELLED_WHILE_GETTING_WORKERS;
            }
            TaskQueueImpl.this.fSubmissionLock.lock();
            try {
                if (!this.workIsStillQueued()) {
                    TaskQueueImpl.this.makeWorkersAvailable(Arrays.asList(instance));
                    TaskDispatchCompletionResult taskDispatchCompletionResult = TaskDispatchCompletionResult.CANCELLED_AFTER_GETTING_WORKERS;
                    return taskDispatchCompletionResult;
                }
                Pair pair = (Pair)TaskQueueImpl.this.fIncompleteRequests.get(this.fID);
                final EvaluationRequest evaluationRequest = ((Task)((DisposableObjectWrapper)pair.getFirst()).getResource()).getEvaluationRequest();
                RemoteFutureAdaptor remoteFutureAdaptor = (RemoteFutureAdaptor)pair.getSecond();
                remoteFutureAdaptor.startedRunning(Arrays.asList(instance));
                TaskQueueImpl.this.fCommGroup.sendTo(instance, (ObservableMessage)evaluationRequest, new MessageObserver(){

                    @Override
                    public void completed(ReturnMessage returnMessage, Instance instance2) {
                        TaskQueueImpl.this.handleTaskReturn(DispatchPlainTaskToWorker.this.fID, returnMessage, instance2);
                    }

                    @Override
                    public void aborted(long l, Instance instance2) {
                        TaskQueueImpl.this.handleWorkerRejectedTask(DispatchPlainTaskToWorker.this.fID);
                    }

                    @Override
                    public void expectReturnsFrom(long l, List<Instance> list) {
                        if (list.size() == 1) {
                            assert (list.get(0).equals(instance));
                        } else {
                            TaskQueueImpl.this.handleWorkerRejectedTask(DispatchPlainTaskToWorker.this.fID);
                        }
                    }
                });
                remoteFutureAdaptor.addCancelTask(new Runnable(){

                    @Override
                    public void run() {
                        Log.LOGGER.log(DistcompLevel.THREE, "DispatchOneTaskToIdleWorker cancel task executing for ID: " + DispatchPlainTaskToWorker.this.fID);
                        TaskQueueImpl.this.sendCancellationIfNecessary(evaluationRequest.getSequenceNumber(), DispatchPlainTaskToWorker.this.fID, instance);
                    }
                });
            }
            finally {
                TaskQueueImpl.this.fSubmissionLock.unlock();
            }
            Log.LOGGER.log(DistcompLevel.FIVE, "DispatchOneTaskToIdleWorker.doDispatch() complete");
            return TaskDispatchCompletionResult.NORMAL_COMPLETION;
        }
    }

    private final class DispatchBroadcastTaskToWorkers
    extends DispatchTaskToWorker {
        private DispatchBroadcastTaskToWorkers(long l) {
            super(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TaskDispatchCompletionResult doDispatch() {
            Object object;
            Log.LOGGER.log(DistcompLevel.FIVE, "DispatchBroadcastTask.doDispatch() entering");
            final LinkedList<Instance> linkedList = new LinkedList<Instance>();
            boolean bl = false;
            while (!bl && this.workIsStillQueued()) {
                try {
                    Log.LOGGER.log(DistcompLevel.FIVE, "DispatchBroadcastTask.doDispatch() polling fAvailableWorkers");
                    object = (Instance)TaskQueueImpl.this.fAvailableWorkers.poll(1L, TimeUnit.SECONDS);
                    if (object != null) {
                        Log.LOGGER.log(DistcompLevel.FIVE, "DispatchBroadcastTask.doDispatch() acquired " + object);
                        linkedList.add((Instance)object);
                    } else {
                        Log.LOGGER.log(DistcompLevel.FIVE, "DispatchBroadcastTask.doDispatch() acquired nothing");
                    }
                    bl = TaskQueueImpl.this.checkGotAllWorkers(linkedList);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!bl) {
                TaskQueueImpl.this.makeWorkersAvailable(linkedList);
                return TaskDispatchCompletionResult.CANCELLED_WHILE_GETTING_WORKERS;
            }
            TaskQueueImpl.this.fSubmissionLock.lock();
            try {
                if (!this.workIsStillQueued()) {
                    TaskQueueImpl.this.makeWorkersAvailable(linkedList);
                    object = TaskDispatchCompletionResult.CANCELLED_AFTER_GETTING_WORKERS;
                    return object;
                }
                object = (Pair)TaskQueueImpl.this.fIncompleteRequests.get(this.fID);
                final EvaluationRequest evaluationRequest = ((Task)((DisposableObjectWrapper)((Pair)object).getFirst()).getResource()).getEvaluationRequest();
                RemoteFutureAdaptor remoteFutureAdaptor = (RemoteFutureAdaptor)((Pair)object).getSecond();
                remoteFutureAdaptor.startedRunning(linkedList);
                TaskQueueImpl.this.fCommGroup.sendTo(linkedList, (ObservableMessage)evaluationRequest, new MessageObserver(){

                    @Override
                    public void completed(ReturnMessage returnMessage, Instance instance) {
                        TaskQueueImpl.this.handleTaskReturn(DispatchBroadcastTaskToWorkers.this.fID, returnMessage, instance);
                    }

                    @Override
                    public void aborted(long l, Instance instance) {
                        TaskQueueImpl.this.handleWorkerRejectedBroadcastTask(l, DispatchBroadcastTaskToWorkers.this.fID, instance);
                    }

                    @Override
                    public void expectReturnsFrom(long l, List<Instance> list) {
                        Log.LOGGER.log(DistcompLevel.FIVE, "DispatchBroadcastTask expecting returns from  " + list.size() + " workers");
                        for (Instance instance : linkedList) {
                            if (list.contains(instance)) continue;
                            TaskQueueImpl.this.handleWorkerRejectedBroadcastTask(l, DispatchBroadcastTaskToWorkers.this.fID, instance);
                        }
                    }
                });
                remoteFutureAdaptor.addCancelTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Instance instance : linkedList) {
                            Log.LOGGER.log(DistcompLevel.THREE, "DispatchBroadcastTask cancel task executing for ID: " + DispatchBroadcastTaskToWorkers.this.fID);
                            TaskQueueImpl.this.sendCancellationIfNecessary(evaluationRequest.getSequenceNumber(), DispatchBroadcastTaskToWorkers.this.fID, instance);
                        }
                    }
                });
            }
            finally {
                TaskQueueImpl.this.fSubmissionLock.unlock();
            }
            return TaskDispatchCompletionResult.NORMAL_COMPLETION;
        }
    }

    private abstract class DispatchTaskToWorker
    implements Callable<TaskDispatchCompletionResult> {
        protected final long fID;

        private DispatchTaskToWorker(long l) {
            this.fID = l;
        }

        protected abstract TaskDispatchCompletionResult doDispatch();

        private int callAcquireWorkers() throws ResourcesUnavailableException {
            int n = -1;
            while (n == -1 && this.workIsStillQueued()) {
                try {
                    n = TaskQueueImpl.this.acquireWorkers();
                }
                catch (InterruptedException interruptedException) {}
            }
            return n;
        }

        @Override
        public final TaskDispatchCompletionResult call() {
            Log.LOGGER.log(DistcompLevel.THREE, "DispatchTaskToWorker entering for task ID: " + this.fID);
            try {
                int n = this.callAcquireWorkers();
                if (!this.workIsStillQueued()) {
                    return TaskDispatchCompletionResult.CANCELLED_WHILE_ACQUIRING_WORKERS;
                }
                assert (n > 0) : "Expect to acquire >0 workers, else throw.";
                Log.LOGGER.log(DistcompLevel.FOUR, "DispatchTaskToWorker proceeding for task ID: " + this.fID);
                return this.doDispatch();
            }
            catch (ResourcesUnavailableException resourcesUnavailableException) {
                Log.LOGGER.log(DistcompLevel.ONE, "DispatchTaskToWorker failed to acquire workers for task ID: " + this.fID);
                TaskQueueImpl.this.failAllOutstandingTasks();
                return TaskDispatchCompletionResult.RESOURCES_UNAVAILABLE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean workIsStillQueued() {
            TaskQueueImpl.this.fSubmissionLock.lock();
            try {
                boolean bl = TaskQueueImpl.this.fIncompleteRequests.containsKey(this.fID);
                return bl;
            }
            finally {
                TaskQueueImpl.this.fSubmissionLock.unlock();
            }
        }

        protected Instance chooseWorkerOrNullIfCancelled() {
            Instance instance = null;
            while (instance == null && this.workIsStillQueued()) {
                try {
                    instance = (Instance)TaskQueueImpl.this.fAvailableWorkers.poll(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            return instance;
        }
    }

    private static enum TaskDispatchCompletionResult {
        NORMAL_COMPLETION,
        INTERRUPTED,
        RESOURCES_UNAVAILABLE,
        CANCELLED_WHILE_ACQUIRING_WORKERS,
        CANCELLED_WHILE_GETTING_WORKERS,
        CANCELLED_AFTER_GETTING_WORKERS,
        OTHER_PROBLEM;

    }

    private static final class BroadcastRequestNotSentException
    extends NoSuchDestinationException {
        private final BaseMsgID fMessageID = new peermessaging.BroadcastRequestNotSent();

        private BroadcastRequestNotSentException() {
        }

        @Override
        public BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        public BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static interface RemoteFutureAdaptor {
        public void appendDiary(String var1, Instance var2);

        public boolean setResult(EvaluationResult var1, Instance var2);

        public Collection<Instance> getWorkers();

        public void startedRunning(List<Instance> var1);

        public void addCancelTask(Runnable var1);

        public void setQueued();
    }
}

