/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FileSystemManipulatorFuture;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesCommand;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesFuture;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.MakeDirectoryCommand;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.ProtocolFulfillmentException;
import com.mathworks.toolbox.distcomp.remote.RemoveFileCommand;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.CouldNotConnectJSchChannelException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.FilePermissions;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchDirectoryMissingException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchFutureHelper;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SftpExtraBytesFromShellException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class JSchSFTPCopyFuture
implements FileSystemManipulatorFuture,
Runnable {
    private static final int BUFFER_SIZE = 16384;
    private final Command fCommand;
    private final JSchFutureHelper fHelper;
    private int fFileCounter = 0;
    private final Lock fLock = new ReentrantLock();
    private final Map<String, ListFileAttributesFuture.FileAttributes> fFileNamesToAttributes = new LinkedHashMap<String, ListFileAttributesFuture.FileAttributes>();
    private final Set<String> fMissingFiles = new LinkedHashSet<String>();
    private final Set<String> fRemovedFiles = new LinkedHashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSchSFTPCopyFuture createJschSFTPCopyFuture(Command command, String string, ParameterMap parameterMap, String string2) throws DispatchException {
        boolean bl = false;
        Lease<JSchLeasableSession> lease = null;
        try {
            lease = JSchSessionLeaseSource.INSTANCE.getLease(string, parameterMap);
            JSchSFTPCopyFuture jSchSFTPCopyFuture = new JSchSFTPCopyFuture(command, lease, string2);
            JSchFutureHelper.startThread(jSchSFTPCopyFuture, string2);
            bl = true;
            JSchSFTPCopyFuture jSchSFTPCopyFuture2 = jSchSFTPCopyFuture;
            return jSchSFTPCopyFuture2;
        }
        finally {
            if (!bl && lease != null) {
                lease.release();
            }
        }
    }

    private JSchSFTPCopyFuture(Command command, Lease<JSchLeasableSession> lease, String string) throws ProtocolDispatchException {
        try {
            this.fCommand = command;
            ChannelSftp channelSftp = this.createChannel(lease.getLeasedConnection().getSession());
            this.fHelper = new JSchFutureHelper(lease, (Channel)channelSftp, string);
        }
        catch (JSchException jSchException) {
            throw new CouldNotConnectJSchChannelException(string, jSchException);
        }
    }

    private ChannelSftp createChannel(Session session) throws JSchException {
        return (ChannelSftp)session.openChannel("sftp");
    }

    @Override
    public void cancel() {
        this.fHelper.cancel();
    }

    @Override
    public boolean isRunning() {
        return this.fHelper.isRunning();
    }

    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
    }

    public boolean isExitStatusOfRemoteCommand() {
        return true;
    }

    public int getExitStatus() throws InterruptedException, FulfillmentException {
        return this.fHelper.getExitStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ListFileAttributesFuture.FileAttributes> getFileAttributes() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
        this.fLock.lock();
        try {
            Map<String, ListFileAttributesFuture.FileAttributes> map = Collections.unmodifiableMap(this.fFileNamesToAttributes);
            return map;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getMissingFileNames() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
        this.fLock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.fMissingFiles);
            return set;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRemovedFileNames() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
        this.fLock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.fRemovedFiles);
            return set;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                try {
                    if (!this.fHelper.hasBeenCancelled()) {
                        this.fHelper.connectToChannel();
                        this.interpretCommand();
                        Logger.LOGGER.fine(this.fHelper.getLogIDString() + ": completed ");
                    }
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
                finally {
                    this.fHelper.disconnectFromChannel();
                }
            }
            finally {
                this.fHelper.releaseLease();
            }
        }
        finally {
            this.fHelper.signalCompleted();
        }
    }

    private void interpretCommand() throws ProtocolFulfillmentException {
        if (this.fCommand instanceof CopyToRemoteCommand) {
            CopyToRemoteCommand copyToRemoteCommand = (CopyToRemoteCommand)this.fCommand;
            this.copyFilesTo(copyToRemoteCommand.getLocalFile(), copyToRemoteCommand.getRemoteFile());
        } else if (this.fCommand instanceof CopyFromRemoteCommand) {
            CopyFromRemoteCommand copyFromRemoteCommand = (CopyFromRemoteCommand)this.fCommand;
            this.copyFilesFrom(copyFromRemoteCommand.getLocalFile(), copyFromRemoteCommand.getRemoteFile());
        } else if (this.fCommand instanceof ListFileAttributesCommand) {
            ListFileAttributesCommand listFileAttributesCommand = (ListFileAttributesCommand)this.fCommand;
            this.listFilePaths(listFileAttributesCommand.getRemotePaths());
        } else if (this.fCommand instanceof RemoveFileCommand) {
            RemoveFileCommand removeFileCommand = (RemoveFileCommand)this.fCommand;
            this.removeFilePaths(removeFileCommand.getRemotePaths());
        } else if (this.fCommand instanceof MakeDirectoryCommand) {
            MakeDirectoryCommand makeDirectoryCommand = (MakeDirectoryCommand)this.fCommand;
            this.makeRemoteDirectory(makeDirectoryCommand.getRemotePath(), makeDirectoryCommand.getMakeMissingParentDirectories());
        } else {
            throw new UnsupportedOperationException(this.fCommand.getClass().getName() + " is not supported by " + this.getClass().getName());
        }
    }

    private void handleException(Exception exception) {
        try {
            String string;
            if (exception instanceof JSchException && SftpExtraBytesFromShellException.isExtraBytesMessage(string = exception.getMessage())) {
                throw new SftpExtraBytesFromShellException(exception);
            }
            this.fHelper.handleException(exception);
        }
        catch (Exception exception2) {
            this.fHelper.handleException(exception2);
        }
    }

    private ChannelSftp getChannel() {
        return (ChannelSftp)this.fHelper.getChannel();
    }

    private void copyFilesTo(File file, String string) throws ProtocolFulfillmentException {
        try {
            if (!this.fHelper.hasBeenCancelled()) {
                Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": started copying from " + file + " to " + string);
                CopyToRemoteCommand copyToRemoteCommand = (CopyToRemoteCommand)this.fCommand;
                if (!copyToRemoteCommand.isExcluded(file)) {
                    if (file.isFile()) {
                        this.copyFileTo(file, string);
                        this.setRemoteFilePermissions(file, string);
                        long l = file.length();
                        this.putInResults(string, l, 0L, file.isDirectory(), "localhost");
                    } else if (file.isDirectory()) {
                        this.makeRemoteDirectory(string);
                        this.setRemoteFilePermissions(file, string);
                        long l = file.length();
                        this.putInResults(string, l, 0L, file.isDirectory(), "localhost");
                        for (File file2 : file.listFiles()) {
                            this.copyFilesTo(file2, string + "/" + file2.getName());
                        }
                    } else {
                        if (!this.isMagicDotFileName(file.toString())) {
                            throw new LocalFileMissingException(file.toString());
                        }
                        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": will not copy .. or . , was asked to copy " + file);
                    }
                    Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": finished copying from " + file + " to " + string);
                } else {
                    Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": " + file + " was excluded");
                }
            }
        }
        catch (SftpException sftpException) {
            throw new JSchSFTPException(this.fHelper.getLogIDString(), file.toString(), string, sftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileTo(File file, String string) throws SftpException, ProtocolFulfillmentException {
        block15: {
            this.incrementCounterAndPossiblyReplaceChannel();
            OutputStream outputStream = this.getChannel().put(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 16384);
            InputStream inputStream = null;
            ProtocolFulfillmentException protocolFulfillmentException = null;
            try {
                boolean bl;
                int n;
                inputStream = new BufferedInputStream(new FileInputStream(file), 16384);
                byte[] byArray = new byte[16384];
                do {
                    if ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    bl = this.fHelper.hasBeenCancelled();
                } while (n > 0 && !bl);
                bufferedOutputStream.flush();
                if (bl) {
                    Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled part way through sending " + file);
                }
            }
            catch (IOException iOException) {
                protocolFulfillmentException = new JSchIOException(this.fHelper.getLogIDString(), file.toString(), string, iOException);
            }
            finally {
                block16: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            if (protocolFulfillmentException != null) break block16;
                            protocolFulfillmentException = new CouldNotCloseInputStreamException(this.fHelper.getLogIDString(), file.toString(), string, iOException);
                        }
                    }
                }
                if (protocolFulfillmentException == null) break block15;
                throw protocolFulfillmentException;
            }
        }
    }

    private void incrementCounterAndPossiblyReplaceChannel() throws ProtocolFulfillmentException {
        try {
            ++this.fFileCounter;
            if (this.fFileCounter % 100 == 0) {
                this.fHelper.replaceCommandAndChannel((Channel)this.createChannel(this.fHelper.getSession()));
            }
        }
        catch (JSchException jSchException) {
            throw new CouldNotReplaceChannelException(this.fHelper.getLogIDString(), jSchException);
        }
    }

    private void setRemoteFilePermissions(File file, String string) throws ProtocolFulfillmentException {
        int n = this.findLocalFilePermissions(file);
        try {
            this.getChannel().chmod(n, string);
            Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": completed chmod " + Integer.toOctalString(n) + " " + string);
        }
        catch (SftpException sftpException) {
            throw new CouldNotChmodException(this.fHelper.getLogIDString(), Integer.toOctalString(n), string, sftpException);
        }
    }

    private int findLocalFilePermissions(File file) {
        int n = 0;
        if (file.isDirectory() || file.canExecute()) {
            n += 64;
        }
        if (file.canWrite()) {
            n += 128;
        }
        if (file.canRead()) {
            n += 256;
        }
        return n;
    }

    private void copyFilesFrom(File file, String string) throws ProtocolFulfillmentException {
        try {
            SftpATTRS sftpATTRS = this.getAttributes(string);
            this.copyFilesFrom(file, string, sftpATTRS);
        }
        catch (SftpException sftpException) {
            throw new RemoteFileLsException(this.fHelper.getLogIDString(), string, sftpException);
        }
    }

    private void copyFilesFrom(File file, String string, SftpATTRS sftpATTRS) throws ProtocolFulfillmentException {
        try {
            if (!this.fHelper.hasBeenCancelled()) {
                Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": started copying from " + string + " to " + file);
                CopyFromRemoteCommand copyFromRemoteCommand = (CopyFromRemoteCommand)this.fCommand;
                if (!copyFromRemoteCommand.isExcluded(string)) {
                    if (this.isFile(sftpATTRS)) {
                        this.copyFileFrom(file, string, sftpATTRS);
                        this.putInResults(string, sftpATTRS, this.fHelper.getHostname());
                    } else if (this.isDir(sftpATTRS)) {
                        File file2 = this.localFileForRemote(file, string);
                        Logger.LOGGER.finest("localDir is " + file2);
                        this.createLocalDirectoryIfNeeded(file2, sftpATTRS);
                        this.putInResults(string, sftpATTRS, this.fHelper.getHostname());
                        List<ChannelSftp.LsEntry> list = this.getRemoteLsEntries(string);
                        for (ChannelSftp.LsEntry lsEntry : list) {
                            String string2 = lsEntry.getFilename();
                            if (!this.shouldRecurse(string2, lsEntry.getAttrs())) continue;
                            this.copyFilesFrom(file2, string + "/" + lsEntry.getFilename(), lsEntry.getAttrs());
                        }
                    }
                    Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": finished copying from " + string + " to " + file);
                } else {
                    Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": " + string + " was excluded.");
                }
            }
        }
        catch (SftpException sftpException) {
            throw new CopyToRemoteException(this.fHelper.getLogIDString(), string, sftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileFrom(File file, String string, SftpATTRS sftpATTRS) throws SftpException, ProtocolFulfillmentException {
        File file2;
        block15: {
            file2 = this.getFileToCopyInto(file, string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getChannel().get(string), 16384);
            ProtocolFulfillmentException protocolFulfillmentException = null;
            OutputStream outputStream = null;
            try {
                boolean bl;
                int n;
                outputStream = new BufferedOutputStream(new FileOutputStream(file2), 16384);
                byte[] byArray = new byte[16384];
                do {
                    if ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) > 0) {
                        outputStream.write(byArray, 0, n);
                    }
                    bl = this.fHelper.hasBeenCancelled();
                } while (n > 0 && !bl);
                outputStream.flush();
                if (bl) {
                    Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled part way through sending " + file);
                }
            }
            catch (IOException iOException) {
                protocolFulfillmentException = new JSchIOException(this.fHelper.getLogIDString(), string, file.toString(), iOException);
            }
            finally {
                block16: {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            if (protocolFulfillmentException != null) break block16;
                            protocolFulfillmentException = new CouldNotCloseOutputStreamException(this.fHelper.getLogIDString(), string, file.toString(), iOException);
                        }
                    }
                }
                if (protocolFulfillmentException == null) break block15;
                throw protocolFulfillmentException;
            }
        }
        this.setLocalFilePermissions(file2, sftpATTRS);
    }

    private File getFileToCopyInto(File file, String string) {
        if (file.isDirectory()) {
            int n = string.lastIndexOf(47);
            String string2 = n == -1 ? string : string.substring(n + 1);
            return new File(file, string2);
        }
        return file;
    }

    private void setLocalFilePermissions(File file, SftpATTRS sftpATTRS) {
        int n = sftpATTRS.getPermissions();
        boolean bl = (n & 0x40) != 0;
        boolean bl2 = (n & 0x80) != 0;
        boolean bl3 = (n & 0x100) != 0;
        boolean bl4 = (n & 1) != 0;
        boolean bl5 = (n & 2) != 0;
        boolean bl6 = (n & 4) != 0;
        FilePermissions filePermissions = new FilePermissions(bl, bl3, bl2, bl4, bl6, bl5);
        filePermissions.setPermisions(file, this.fHelper.getLogIDString());
    }

    private File localFileForRemote(File file, String string) {
        CopyCommand copyCommand = (CopyCommand)this.fCommand;
        String string2 = string.replaceFirst(copyCommand.getRemoteFile(), "");
        String[] stringArray = string2.split("/");
        String string3 = stringArray[stringArray.length - 1];
        return new File(file, string3);
    }

    private void createLocalDirectoryIfNeeded(File file, SftpATTRS sftpATTRS) throws ProtocolFulfillmentException {
        boolean bl = file.exists() && file.isDirectory();
        boolean bl2 = file.mkdir();
        if (!bl && !bl2) {
            throw new JSchDirectoryMissingException(this.fHelper.getLogIDString(), file);
        }
        if (bl2) {
            Logger.LOGGER.finest("created directory " + file + " " + file.exists());
        }
        this.setLocalFilePermissions(file, sftpATTRS);
    }

    private void listFilePaths(Set<String> set) throws ProtocolFulfillmentException {
        if (!this.fHelper.hasBeenCancelled()) {
            for (String string : set) {
                this.listFilePath(string);
            }
        }
    }

    private void listFilePath(String string) throws ProtocolFulfillmentException {
        if (!this.fHelper.hasBeenCancelled()) {
            try {
                SftpATTRS sftpATTRS = this.getAttributes(string);
                this.putInResults(string, sftpATTRS, this.fHelper.getHostname());
                if (this.isDir(sftpATTRS)) {
                    this.listDirPath(string);
                }
            }
            catch (SftpException sftpException) {
                if (sftpException.id == 2) {
                    this.addMissingFile(string);
                }
                throw new RemoteFilePathException(this.fHelper.getLogIDString(), string, sftpException);
            }
        }
    }

    private void listDirPath(String string) throws ProtocolFulfillmentException {
        try {
            List<ChannelSftp.LsEntry> list = this.getRemoteLsEntries(string);
            for (ChannelSftp.LsEntry lsEntry : list) {
                String string2 = string + "/" + lsEntry.getFilename();
                if (this.isFile(lsEntry.getAttrs())) {
                    this.putInResults(string2, lsEntry.getAttrs(), this.fHelper.getHostname());
                    continue;
                }
                if (this.isDir(lsEntry.getAttrs())) {
                    if (!this.shouldRecurse(lsEntry.getFilename(), lsEntry.getAttrs())) continue;
                    this.putInResults(string2, lsEntry.getAttrs(), this.fHelper.getHostname());
                    this.listDirPath(string2);
                    continue;
                }
                Logger.LOGGER.warning(lsEntry.toString() + " is not a file or a directory.");
            }
        }
        catch (SftpException sftpException) {
            throw new RemoteDirectoryPathException(this.fHelper.getLogIDString(), string, sftpException);
        }
    }

    private SftpATTRS getAttributes(String string) throws SftpException {
        return this.getChannel().stat(string);
    }

    private boolean isFile(SftpATTRS sftpATTRS) {
        return !sftpATTRS.isDir();
    }

    private boolean isDir(SftpATTRS sftpATTRS) {
        return sftpATTRS.isDir();
    }

    private boolean isLink(SftpATTRS sftpATTRS) {
        return sftpATTRS.isLink();
    }

    private List<ChannelSftp.LsEntry> getRemoteLsEntries(String string) throws SftpException {
        return this.getChannel().ls(string);
    }

    private boolean shouldRecurse(String string, SftpATTRS sftpATTRS) {
        if (this.isMagicDotFileName(string)) {
            return false;
        }
        return !this.isLink(sftpATTRS);
    }

    private boolean isMagicDotFileName(String string) {
        if (".".equals(string)) {
            return true;
        }
        return "..".equals(string);
    }

    private void putInResults(String string, SftpATTRS sftpATTRS, String string2) {
        this.putInResults(string, sftpATTRS.getSize(), sftpATTRS.getMTime(), sftpATTRS.isDir(), string2);
    }

    private void putInResults(String string, long l, long l2, boolean bl, String string2) {
        ListFileAttributesFuture.FileAttributes fileAttributes = new ListFileAttributesFuture.FileAttributes(string, l, l2, bl, string2);
        ListFileAttributesFuture.FileAttributes fileAttributes2 = this.fFileNamesToAttributes.put(string, fileAttributes);
        if (fileAttributes2 != null) {
            Logger.LOGGER.warning("An extra call to getAttributes() may have been made for " + string);
        }
    }

    private void removeFilePaths(Set<String> set) throws ProtocolFulfillmentException {
        if (!this.fHelper.hasBeenCancelled()) {
            for (String string : set) {
                this.removeFilePath(string);
            }
        }
    }

    private void removeFilePath(String string) throws ProtocolFulfillmentException {
        if (!this.fHelper.hasBeenCancelled()) {
            try {
                SftpATTRS sftpATTRS = this.getAttributes(string);
                if (this.isFile(sftpATTRS)) {
                    this.removeFile(string);
                }
                if (this.isDir(sftpATTRS) && this.shouldRecurse(string, sftpATTRS)) {
                    this.removeDirPath(string);
                }
            }
            catch (SftpException sftpException) {
                if (sftpException.id == 2) {
                    this.addMissingFile(string);
                }
                throw new RemoteFilePathException(this.fHelper.getLogIDString(), string, sftpException);
            }
        }
    }

    private void removeDirPath(String string) throws ProtocolFulfillmentException {
        try {
            List<ChannelSftp.LsEntry> list = this.getRemoteLsEntries(string);
            for (ChannelSftp.LsEntry lsEntry : list) {
                String string2 = string + "/" + lsEntry.getFilename();
                if (this.isFile(lsEntry.getAttrs())) {
                    this.removeFile(string2);
                    continue;
                }
                if (this.isDir(lsEntry.getAttrs()) && this.shouldRecurse(lsEntry.getFilename(), lsEntry.getAttrs())) {
                    this.removeDirPath(string2);
                    continue;
                }
                Logger.LOGGER.warning(lsEntry.toString() + " is not a file or a directory.");
            }
            this.removeDir(string);
        }
        catch (SftpException sftpException) {
            throw new RemoteDirectoryPathException(this.fHelper.getLogIDString(), string, sftpException);
        }
    }

    private void removeFile(String string) throws ProtocolFulfillmentException {
        try {
            this.getChannel().rm(string);
            this.addRemovedFile(string);
        }
        catch (SftpException sftpException) {
            throw new CouldNotRemoveFileException(this.fHelper.getLogIDString(), string, sftpException);
        }
    }

    private void removeDir(String string) throws ProtocolFulfillmentException {
        try {
            this.getChannel().rmdir(string);
            this.addRemovedFile(string);
        }
        catch (SftpException sftpException) {
            throw new CouldNotRemoveDirectoryException(this.fHelper.getLogIDString(), string, sftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemovedFile(String string) {
        this.fLock.lock();
        try {
            this.fRemovedFiles.add(string);
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": removed " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMissingFile(String string) {
        this.fLock.lock();
        try {
            this.fMissingFiles.add(string);
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": missing " + string);
    }

    private void makeRemoteDirectory(String string, boolean bl) throws ProtocolFulfillmentException {
        if (!this.fHelper.hasBeenCancelled()) {
            try {
                if (!bl) {
                    this.makeRemoteDirectory(string);
                } else {
                    this.recursiveMakeRemoteDirectory(string);
                }
            }
            catch (SftpException sftpException) {
                throw new RemoteDirectoryPathException(this.fHelper.getLogIDString(), string, sftpException);
            }
        }
    }

    private void recursiveMakeRemoteDirectory(String string) throws SftpException, ProtocolFulfillmentException {
        if (!this.remoteDirectoryExists(string)) {
            int n = string.lastIndexOf("/");
            if (n == -1 || n == 0) {
                throw new RemoteDirectoryNoPathException(this.fHelper.getLogIDString());
            }
            String string2 = string.substring(0, n);
            this.recursiveMakeRemoteDirectory(string2);
            this.makeRemoteDirectory(string);
        }
    }

    private void makeRemoteDirectory(String string) throws SftpException, ProtocolFulfillmentException {
        if (!this.remoteDirectoryExists(string)) {
            this.getChannel().mkdir(string);
            Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": remote mkdir " + string + " completed");
        }
    }

    private boolean remoteDirectoryExists(String string) throws SftpException, ProtocolFulfillmentException {
        try {
            SftpATTRS sftpATTRS = this.getAttributes(string);
            if (!sftpATTRS.isDir()) {
                throw new RemoteDirectoryExistsException(this.fHelper.getLogIDString(), string);
            }
            return true;
        }
        catch (SftpException sftpException) {
            if (sftpException.id == 2) {
                return false;
            }
            throw sftpException;
        }
    }

    private static final class RemoteDirectoryExistsException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        RemoteDirectoryExistsException(String string, String string2) {
            this.fBaseMsgID = new remote.RemoteDirectoryExists(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class RemoteDirectoryNoPathException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        RemoteDirectoryNoPathException(String string) {
            this.fBaseMsgID = new remote.RemoteDirNoPath(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotRemoveDirectoryException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        CouldNotRemoveDirectoryException(String string, String string2, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.CouldNotRemoveDirectory(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotRemoveFileException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        CouldNotRemoveFileException(String string, String string2, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.CouldNotRemoveFile(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class RemoteDirectoryPathException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        RemoteDirectoryPathException(String string, String string2, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.RemoteDirPath(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class RemoteFilePathException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        RemoteFilePathException(String string, String string2, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.RemoteFilePath(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotCloseOutputStreamException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        CouldNotCloseOutputStreamException(String string, String string2, String string3, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.CouldNotCloseOutputStream(string, string2, string3);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CopyToRemoteException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        CopyToRemoteException(String string, String string2, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.CopyToRemote(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class RemoteFileLsException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        RemoteFileLsException(String string, String string2, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.RemoteFileLs(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotChmodException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        CouldNotChmodException(String string, String string2, String string3, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.CouldNotChmod(string, string2, string3);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotReplaceChannelException
    extends ProtocolFulfillmentException {
        private final String fLogIDString;

        CouldNotReplaceChannelException(String string, JSchException jSchException) {
            super(jSchException);
            this.fLogIDString = string;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.ReplacementChannel(this.fLogIDString, this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.ReplacementChannel(this.fLogIDString, this.getCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotCloseInputStreamException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        CouldNotCloseInputStreamException(String string, String string2, String string3, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.CouldNotCloseInputStream(string, string2, string3);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchIOException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        JSchIOException(String string, String string2, String string3, IOException iOException) {
            super(iOException);
            this.fBaseMsgID = new remote.JSchIO(string, string2, string3);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSFTPException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        JSchSFTPException(String string, String string2, String string3, SftpException sftpException) {
            super((Throwable)sftpException);
            this.fBaseMsgID = new remote.JSchSFTP(string, string2, string3);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class LocalFileMissingException
    extends ProtocolFulfillmentException {
        private final BaseMsgID fBaseMsgID;

        LocalFileMissingException(String string) {
            this.fBaseMsgID = new remote.LocalFileMissing(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

