/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.io.I18nStreamInterruptedIOException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class SignalingBufferedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 16384;
    private final Lock fInLock = new ReentrantLock();
    private final Condition fInSet = this.fInLock.newCondition();
    private final Condition fDoneReadingFIn = this.fInLock.newCondition();
    private boolean fisDoneReadingFIn = false;
    private BufferedInputStream fIn;
    private final String fLogPrefix;

    SignalingBufferedInputStream(String string) {
        this.fLogPrefix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputStreamAndStart(InputStream inputStream) throws IOException {
        this.fInLock.lock();
        try {
            if (this.fIn != null) {
                throw new IllegalStateException("setInputStreamAndStart() can only be called once");
            }
            this.fIn = new BufferedInputStream(inputStream, 16384);
            this.signalInputStreamAvailable();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitInputStreamAvailable() throws InterruptedException {
        this.fInLock.lock();
        try {
            if (this.fIn == null) {
                Logger.LOGGER.finest(this.fLogPrefix + ": Waiting for stream");
                this.fInSet.await();
                Logger.LOGGER.finest(this.fLogPrefix + ": Finished waiting for stream " + (this.fIn != null));
            }
            boolean bl = this.isInputStreamAvailable();
            return bl;
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalInputStreamAvailable() {
        this.fInLock.lock();
        try {
            this.fInSet.signalAll();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInputStreamAvailable() {
        this.fInLock.lock();
        try {
            boolean bl = this.fIn != null;
            return bl;
        }
        finally {
            this.fInLock.unlock();
        }
    }

    @Override
    public int read() throws IOException {
        BufferedInputStream bufferedInputStream;
        block8: {
            bufferedInputStream = null;
            this.fInLock.lock();
            try {
                if (this.awaitInputStreamAvailable()) {
                    bufferedInputStream = this.fIn;
                    break block8;
                }
                throw new IOException(this.fLogPrefix + ": fIn stream never set");
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedReadException(this.fLogPrefix, interruptedException);
            }
            finally {
                this.fInLock.unlock();
            }
        }
        assert (bufferedInputStream != null) : "localIn should have been set";
        int n = ((InputStream)bufferedInputStream).read();
        if (n == -1) {
            this.signalDoneReading();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.fInLock.lock();
        try {
            this.closeInput();
            this.signalInputStreamAvailable();
            this.signalDoneReading();
            super.close();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInput() {
        this.fInLock.lock();
        try {
            if (this.fIn != null) {
                this.fIn.close();
            }
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fLogPrefix + ": exception while closing input", iOException);
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalDoneReading() {
        this.fInLock.lock();
        try {
            this.fisDoneReadingFIn = true;
            this.fDoneReadingFIn.signalAll();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitReachedEndOfInput() throws InterruptedException {
        this.fInLock.lock();
        try {
            while (!this.fisDoneReadingFIn) {
                Logger.LOGGER.finest(this.fLogPrefix + ": Waiting to finish reading");
                this.fDoneReadingFIn.await();
                Logger.LOGGER.finest(this.fLogPrefix + ": Finished reading " + this.fisDoneReadingFIn);
            }
        }
        finally {
            this.fInLock.unlock();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.isInputStreamAvailable()) {
            return this.fIn.available();
        }
        Logger.LOGGER.finest(this.fLogPrefix + ": returning 0 because fIn is null");
        return 0;
    }

    private static final class InterruptedReadException
    extends I18nStreamInterruptedIOException {
        private final String fLogPrefix;

        InterruptedReadException(String string, InterruptedException interruptedException) {
            this.fLogPrefix = string;
            this.initCause(interruptedException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.InterruptedRead(this.fLogPrefix, this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.InterruptedRead(this.fLogPrefix, this.getCause().getLocalizedMessage());
        }
    }
}

