/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.SecurityModuleProvider;
import com.mathworks.toolbox.distcomp.auth.TrustModule;
import com.mathworks.toolbox.distcomp.control.ParentWatchdog;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.distcompobjects.Identifiable;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.mjs.security.SharedSecret;
import com.mathworks.toolbox.distcomp.service.DistcompService;
import com.mathworks.toolbox.distcomp.service.DistcompServiceRemote;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.service.PersistentServiceConfiguration;
import com.mathworks.toolbox.distcomp.service.PersistentServiceID;
import com.mathworks.toolbox.distcomp.service.ServiceExporterFactory;
import com.mathworks.toolbox.distcomp.util.ConfigurationFileServiceStarterException;
import com.mathworks.toolbox.distcomp.util.LocalNetworkInfo;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import com.mathworks.toolbox.distcomp.util.PersistenceDirServiceStarterException;
import com.mathworks.toolbox.distcomp.util.PortUnavailableException;
import com.mathworks.toolbox.distcomp.util.ServiceExportException;
import com.mathworks.toolbox.distcomp.util.ServiceStarterException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompConsoleHandler;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.server.ExportException;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupLocatorDiscovery;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.lookup.JoinManager;
import net.jini.security.BasicProxyPreparer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public abstract class DistcompServiceImpl
implements DistcompServiceRemote,
Identifiable,
ProxyAccessor {
    private final PersistentServiceID fPersistentServiceID;
    private String fHostName;
    private String fComputerMLType;
    private String[] fAllHostAddresses;
    private DistcompService fStub;
    private String fName;
    private ActivationID fActivationID;
    private ServiceExporterFactory fExporterFactory;
    private ExporterFactory fNonTrustingExporterFactory;
    private Exporter fServiceExporter;
    private JoinManager fJoinManager;
    private long fStartTime = -1L;
    private Handler fLogHandler;
    protected ParentWatchdog fParentWatchdog;
    protected boolean fUnitTesting = false;
    protected PersistentServiceConfiguration fServiceConfig;
    private CryptoModule fStorageCryptoModule;
    private CryptoModule fTransferCryptoModule;
    private CryptoModule.Hasher fHasher;
    private TrustModule fTrustModule;
    private static final String COMPUTERMLTYPE;
    private static final int SALT_LENGTH = 32;
    private byte[] fCurrentSalt;

    protected DistcompServiceImpl(ActivationID activationID, MarshalledObject marshalledObject, String string) throws DistcompException {
        Object object = Logger.getLogger("net.jini");
        Logger logger = Logger.getLogger("com.sun.jini.reggie");
        ((Logger)object).setLevel(Level.SEVERE);
        logger.setLevel(Level.SEVERE);
        this.fCurrentSalt = new byte[0];
        this.fPersistentServiceID = DistcompServiceImpl.createPersistentServiceID(activationID, marshalledObject, string);
        if (activationID == null) {
            this.fUnitTesting = true;
        }
        this.fActivationID = activationID;
        try {
            this.initPersistentServiceConfig(marshalledObject, string);
        }
        catch (ServiceStarterException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
        try {
            this.fHostName = this.findHostName();
        }
        catch (NetworkConfigException networkConfigException) {
            throw new DistcompException(networkConfigException);
        }
        this.fAllHostAddresses = LocalNetworkInfo.findAllHostAddresses();
        this.fName = this.fServiceConfig.getServiceName();
        this.fStartTime = System.currentTimeMillis();
        try {
            this.initDistcompLoggerAndHandlers();
        }
        catch (IOException iOException) {
            throw new DistcompException(iOException);
        }
        this.initExporterFactory();
        this.initCertificateStore();
        try {
            this.initSecurity();
        }
        catch (CryptoException cryptoException) {
            throw new DistcompException(cryptoException);
        }
        this.fParentWatchdog = new ParentWatchdog();
        this.fComputerMLType = COMPUTERMLTYPE;
        try {
            object = this.getMatlabRoot();
            XMLMessageSystem.initializeXMLMessageSystem((String)object);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    @Override
    public Uuid getID() {
        return this.fPersistentServiceID.getServiceID();
    }

    private static PersistentServiceID createPersistentServiceID(ActivationID activationID, MarshalledObject marshalledObject, String string) throws DistcompException {
        try {
            boolean bl = activationID == null;
            Configuration configuration = DistcompServiceImpl.createConfig(bl, marshalledObject);
            return new PersistentServiceID(configuration, string);
        }
        catch (ConfigurationException configurationException) {
            throw new DistcompException(new ConfigurationFileServiceStarterException(configurationException));
        }
        catch (PersistenceDirException persistenceDirException) {
            throw new DistcompException(new PersistenceDirServiceStarterException(persistenceDirException));
        }
        catch (ServiceStarterException serviceStarterException) {
            throw new DistcompException(serviceStarterException);
        }
    }

    private void initSecurity() throws CryptoException {
        this.fStorageCryptoModule = SecurityModuleProvider.createStorageCryptoModule(this.getSecurityLevel(), this.requireWebLicensing(), this.getSecurityDir());
        this.fTransferCryptoModule = SecurityModuleProvider.createTransferCryptoModule(this.getSecurityLevel(), this.getSecurityDir());
        this.fHasher = SecurityModuleProvider.createHasher(this.getSecurityLevel());
        this.fTrustModule = SecurityModuleProvider.createTrustModule(this.getSecurityLevel(), this.getTransferCryptoModule(), this.getNonTrustingExporterFactory());
    }

    protected boolean requireWebLicensing() {
        return this.fServiceConfig.requireWebLicensing();
    }

    protected CryptoModule getStorageCryptoModule() {
        return this.fStorageCryptoModule;
    }

    protected CryptoModule getTransferCryptoModule() {
        return this.fTransferCryptoModule;
    }

    protected CryptoModule.Hasher getHasher() {
        return this.fHasher;
    }

    protected TrustModule getTrustModule() {
        return this.fTrustModule;
    }

    @Override
    public Object provideEvidence(Object object) {
        return this.getTrustModule().getRemoteTrustModule().provideEvidence(object);
    }

    protected byte[] getSalt() {
        byte[] byArray = new byte[this.fCurrentSalt.length];
        System.arraycopy(this.fCurrentSalt, 0, byArray, 0, this.fCurrentSalt.length);
        return byArray;
    }

    private void setSalt(byte[] byArray) {
        this.fCurrentSalt = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fCurrentSalt, 0, byArray.length);
    }

    @Override
    public byte[] createSalt() {
        this.setSalt(this.getTransferCryptoModule().createSalt(32));
        return this.getSalt();
    }

    @Override
    public String[] getAllHostAddresses() {
        return this.fAllHostAddresses;
    }

    @Override
    public String getHostName() {
        return this.fHostName;
    }

    @Override
    public String getComputerMLType() {
        return this.fComputerMLType;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public Object getProxy() {
        return this.fStub;
    }

    @Override
    public int getLogLevel() {
        Level level = this.fLogHandler.getLevel();
        return DistcompLevel.getValueFromLevel((Level)level);
    }

    public void setLogLevel(int n) throws RemoteException, MJSException {
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Cluster log level changed for " + this.fName + ". New level: " + n);
        this.fServiceConfig.setLogLevel(n);
    }

    @Override
    public boolean isUsingSecureCommunication() {
        return this.fServiceConfig.isUsingSecureCommunication();
    }

    @Override
    public int getSecurityLevel() {
        return this.fServiceConfig.getSecurityLevel();
    }

    @Override
    public String getMatlabRoot() throws RemoteException {
        return this.fServiceConfig.getMatlabRoot();
    }

    private String getSecurityDir() {
        return this.fServiceConfig.getSecurityDirectory();
    }

    protected String getPersistentSessionID() {
        return this.getID().toString();
    }

    protected DistcompService getStub() {
        return this.fStub;
    }

    protected void destroyForUnitTests() throws Exception {
        Handler[] handlerArray;
        Logger logger = PackageInfo.LOGGER.getParent();
        for (Handler handler : handlerArray = logger.getHandlers()) {
            handler.close();
            logger.removeHandler(handler);
        }
        this.fServiceExporter.unexport(true);
        this.fPersistentServiceID.destroy();
    }

    protected abstract PersistentServiceConfiguration createServiceConfiguration(Configuration var1, String var2) throws ConfigurationException, PersistenceDirException;

    protected void registerWithLookupServices(DistcompService distcompService) throws ServiceStarterException {
        if (!this.fUnitTesting) {
            try {
                LookupLocator[] lookupLocatorArray = this.fServiceConfig.getLookupLocators();
                Object object = lookupLocatorArray != null && lookupLocatorArray.length > 0 ? new LookupLocatorDiscovery(lookupLocatorArray) : new LookupDiscoveryManager(DiscoveryGroupManagement.ALL_GROUPS, null, null);
                ServiceID serviceID = new ServiceID(this.getID().getMostSignificantBits(), this.getID().getLeastSignificantBits());
                this.fJoinManager = new JoinManager((Object)distcompService, this.fServiceConfig.getLookupAttributes(), serviceID, (DiscoveryManagement)object, null);
            }
            catch (IOException iOException) {
                throw new ServiceStarterException((BaseMsgID)new mjs.LookupServiceDiscoveryNotStarted(), (Throwable)iOException);
            }
        }
    }

    public abstract DistcompService getDistcompProxy();

    protected void setDistcompServiceNodeInfo(NodeInfo nodeInfo) {
        String[] stringArray = this.getCurrentLookupServices();
        String[] stringArray2 = this.getLookupServicesInConfiguration();
        Date date = this.fStartTime == -1L ? null : new Date(this.fStartTime);
        nodeInfo.setNodeInfo(this.fHostName, this.fAllHostAddresses, this.fServiceExporter.getExportPort(), this.fName, stringArray, stringArray2, date);
    }

    private void initExporterFactory() {
        int n = this.fServiceConfig.getMinExportPort();
        int n2 = n + 1000;
        boolean bl = this.fServiceConfig.isUsingSecureCommunication();
        boolean bl2 = this.fServiceConfig.isTrustingClients();
        int n3 = this.fServiceConfig.getDefaultRmiClientConnectTimeoutSecs() * 1000;
        this.fExporterFactory = new ServiceExporterFactory(n, n2, bl, bl2, n3);
        this.fNonTrustingExporterFactory = bl2 ? new ServiceExporterFactory(n, n2, bl, false, n3) : this.fExporterFactory;
    }

    protected ExporterFactory getExporterFactory() {
        return this.fExporterFactory;
    }

    protected ExporterFactory getNonTrustingExporterFactory() {
        return this.fNonTrustingExporterFactory;
    }

    protected void exportDistcompService() throws NetworkConfigException, ServiceExportException {
        if (this.fActivationID != null && this.fServiceConfig.isUsingActivatableExporter()) {
            try {
                this.fActivationID = (ActivationID)new BasicProxyPreparer().prepareProxy((Object)this.fActivationID);
                new BasicProxyPreparer().prepareProxy((Object)ActivationGroup.getSystem());
            }
            catch (RemoteException | ActivationException throwable) {
                throw new ServiceExportException(throwable);
            }
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Using an activatable service exporter with ActivationID: " + this.fActivationID.toString());
            this.fServiceExporter = this.fExporterFactory.createExporter(this.fActivationID);
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Using a non-activatable service exporter.");
            this.fServiceExporter = this.fExporterFactory.createExporter();
        }
        try {
            this.fStub = (DistcompService)((Object)this.fServiceExporter.export(this));
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Successfully exported " + this.serviceTypeForPrinting() + " service on port " + this.fServiceExporter.getExportPort());
        }
        catch (ExportException exportException) {
            throw new NetworkConfigException(new PortUnavailableException(exportException));
        }
    }

    public Certificate getSharedSecretCertificate() {
        return this.isUsingSecureCommunication() ? SharedSecret.getInstance().getSharedSecretCertificate() : null;
    }

    protected SSLContext createSharedSecretSSLContext() {
        return this.isUsingSecureCommunication() ? SharedSecret.getInstance().createServerSSLContext() : null;
    }

    private void initCertificateStore() {
        Certificate certificate = this.getSharedSecretCertificate();
        if (certificate != null) {
            PackageInfo.LOGGER.info("Adding shared secret to ClientCertificateStore.");
            ClientCertificateStore.getInstance().setCertificateEntry("SharedSecret", certificate);
        }
    }

    protected abstract String serviceTypeForPrinting();

    private void initDistcompLoggerAndHandlers() throws IOException {
        Logger logger = PackageInfo.LOGGER.getParent();
        this.initConsoleHandler(logger);
        this.initLogHandler(logger);
    }

    private void initConsoleHandler(Logger logger) {
        logger.addHandler((Handler)new DistcompConsoleHandler(0));
    }

    private void initLogHandler(Logger logger) {
        this.fLogHandler = this.fServiceConfig.getServiceHandler();
        logger.addHandler(this.fLogHandler);
    }

    protected Collection<File> listLogs() {
        File file = new File(this.fServiceConfig.getLogDirectory());
        NotFileFilter notFileFilter = new NotFileFilter((IOFileFilter)new SuffixFileFilter(".lck"));
        return FileUtils.listFiles((File)file, (IOFileFilter)notFileFilter, (IOFileFilter)FalseFileFilter.FALSE);
    }

    private String[] getCurrentLookupServices() {
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[]{};
        if (this.fJoinManager != null) {
            serviceRegistrarArray = this.fJoinManager.getJoinSet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ServiceRegistrar serviceRegistrar : serviceRegistrarArray) {
            try {
                LookupLocator lookupLocator = serviceRegistrar.getLocator();
                hashSet.add(lookupLocator.getHost() + ":" + lookupLocator.getPort());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private String[] getLookupServicesInConfiguration() {
        LookupLocator[] lookupLocatorArray = this.fServiceConfig.getLookupLocators();
        HashSet<String> hashSet = new HashSet<String>();
        for (LookupLocator lookupLocator : lookupLocatorArray) {
            hashSet.add(lookupLocator.getHost() + ":" + lookupLocator.getPort());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private void initPersistentServiceConfig(MarshalledObject marshalledObject, String string) throws ServiceStarterException {
        try {
            Configuration configuration = DistcompServiceImpl.createConfig(this.fUnitTesting, marshalledObject);
            this.fServiceConfig = this.createServiceConfiguration(configuration, string);
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationFileServiceStarterException(configurationException);
        }
        catch (PersistenceDirException persistenceDirException) {
            throw new PersistenceDirServiceStarterException(persistenceDirException);
        }
    }

    private static Configuration createConfig(boolean bl, MarshalledObject marshalledObject) throws ServiceStarterException {
        Configuration configuration;
        try {
            String[] stringArray = (String[])marshalledObject.get();
            if (bl) {
                configuration = ConfigurationProvider.getInstance((String[])stringArray);
            } else {
                String string = stringArray[0];
                configuration = ConfigurationProvider.getInstance((String[])new String[]{string});
                for (int i = 1; i < stringArray.length; i += 2) {
                    System.setProperty(stringArray[i], stringArray[i + 1]);
                }
            }
        }
        catch (IOException | ClassNotFoundException | ConfigurationException throwable) {
            throw new ConfigurationFileServiceStarterException(throwable);
        }
        return configuration;
    }

    private String findHostName() throws NetworkConfigException {
        return LocalNetworkInfo.findHostName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Identifiable) {
            Identifiable identifiable = (Identifiable)object;
            return this.getID().equals((Object)identifiable.getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    static {
        if (PlatformInfo.isLinux()) {
            COMPUTERMLTYPE = PlatformInfo.isLinux64() ? "GLNXA64" : "GLNX86";
        } else if (PlatformInfo.isWindows()) {
            COMPUTERMLTYPE = PlatformInfo.isWindows64() ? "PCWIN64" : "PCWIN";
        } else if (PlatformInfo.isIntelMac()) {
            COMPUTERMLTYPE = PlatformInfo.isIntelMac64() ? "MACI64" : "MACI";
        } else if (PlatformInfo.isSolaris64()) {
            COMPUTERMLTYPE = "SOL64";
        } else {
            throw new RuntimeException("Unknown platform.");
        }
    }
}

