/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.service.ActivatableExporterFactory;
import com.mathworks.toolbox.distcomp.service.DistcompActivatableExporter;
import com.mathworks.toolbox.distcomp.service.DistcompJrmpExporter;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import com.mathworks.toolbox.distcomp.service.SecureRMISocketFactoryProvider;
import com.mathworks.toolbox.distcomp.util.security.KeyStoreFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.rmi.activation.ActivationID;
import java.security.KeyStore;
import java.util.UUID;

public class SecureServiceExporterFactory
implements ExporterFactory,
ActivatableExporterFactory {
    private final int fMinPort;
    private final int fMaxPort;
    private final RMISocketFactoryProvider fProvider;

    private SecureServiceExporterFactory(int n, int n2, RMISocketFactoryProvider rMISocketFactoryProvider) {
        this.fMinPort = n;
        this.fMaxPort = n2;
        this.fProvider = rMISocketFactoryProvider;
    }

    @Override
    public Exporter createExporter() {
        return new DistcompJrmpExporter(this.fMinPort, this.fMaxPort, this.fProvider);
    }

    @Override
    public Exporter createExporter(ActivationID activationID) {
        return new DistcompActivatableExporter(activationID, this.fMinPort, this.fMaxPort, this.fProvider);
    }

    public static SecureServiceExporterFactory create(int n, int n2, String string) {
        UUID uUID = UUID.randomUUID();
        char[] cArray = uUID.toString().toCharArray();
        String string2 = "CN=" + string;
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating key store factory with alias: " + string);
            int n3 = 90;
            KeyStore keyStore = new KeyStoreFactory().createKeyStore(string, cArray, string2, n3);
            return new SecureServiceExporterFactory(n, n2, new SecureRMISocketFactoryProvider(keyStore, cArray, string));
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to create key store", iOException);
            throw new IllegalStateException(iOException);
        }
    }
}

