/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileErrorCode;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.Log;
import com.mathworks.toolbox.distcomp.storage.fileblobs.RandomAccessFilePool;
import com.mathworks.toolbox.distcomp.storage.fileblobs.RandomAccessFilePoolException;
import com.mathworks.toolbox.distcomp.util.BufferedStreamCopier;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;

public class BlobFile {
    private static final int MIN_SIZE = 4096;
    private final File fFile;
    private final RandomAccessFilePool fRandomAccessFilePool;
    private long fDataSize = 0L;
    private final Lock fLock = new ReentrantLock();

    public BlobFile(File file, RandomAccessFilePool randomAccessFilePool) {
        this.fFile = file;
        this.fRandomAccessFilePool = randomAccessFilePool;
    }

    public BlobFile(File file, long l, RandomAccessFilePool randomAccessFilePool) {
        this.fFile = file;
        this.fDataSize = l;
        this.fRandomAccessFilePool = randomAccessFilePool;
    }

    public boolean exists() {
        return this.fFile.exists();
    }

    File getParentFile() {
        return this.fFile.getParentFile();
    }

    boolean delete() {
        return this.fFile.delete();
    }

    public String getPath() {
        return this.fFile.getPath();
    }

    public long getDataSize() {
        return this.fDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobFile copy(File file) throws IOException, BlobFileException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.fFile));){
            this.fLock.lock();
            try {
                BlobFile blobFile = new BlobFile(file, this.fDataSize, this.fRandomAccessFilePool);
                blobFile.write(bufferedInputStream, this.fDataSize);
                BlobFile blobFile2 = blobFile;
                this.fLock.unlock();
                return blobFile2;
            }
            catch (Throwable throwable) {
                this.fLock.unlock();
                throw throwable;
            }
        }
    }

    public long read(OutputStream outputStream) throws IOException {
        return this.read(outputStream, this.fDataSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(OutputStream outputStream, long l) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.fFile));){
            this.fLock.lock();
            try {
                Log.LOGGER.log(DistcompLevel.FIVE, "Reading " + l + " bytes from " + this.fFile);
                long l2 = BufferedStreamCopier.copyStreams(bufferedInputStream, outputStream, l);
                this.fLock.unlock();
                return l2;
            }
            catch (Throwable throwable) {
                this.fLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte[] byArray) throws IOException, BlobFileException {
        this.fLock.lock();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            long l = this.write(byteArrayInputStream, byArray.length, this.fDataSize);
            this.fDataSize += l;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(InputStream inputStream, long l) throws IOException, BlobFileException {
        this.fLock.lock();
        try {
            long l2 = this.write(inputStream, l, this.fDataSize);
            this.fDataSize += l2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) throws IOException, BlobFileException {
        this.fLock.lock();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.fDataSize = this.write(byteArrayInputStream, byArray.length, 0L);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream inputStream, long l) throws IOException, BlobFileException {
        this.fLock.lock();
        try {
            this.fDataSize = this.write(inputStream, l, 0L);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write(InputStream inputStream, long l, long l2) throws IOException, BlobFileException {
        RandomAccessOutputStream randomAccessOutputStream = new RandomAccessOutputStream(this.fFile, this.fRandomAccessFilePool);
        try {
            randomAccessOutputStream.seek(l2);
            randomAccessOutputStream.resizeFile(l2 + l);
            long l3 = BufferedStreamCopier.copyStreams(inputStream, randomAccessOutputStream, l);
            randomAccessOutputStream.close();
            return l3;
        }
        catch (Throwable throwable) {
            try {
                randomAccessOutputStream.close();
                throw throwable;
            }
            catch (RandomAccessFilePoolException randomAccessFilePoolException) {
                throw new WriteBlobFileException(randomAccessFilePoolException);
            }
        }
    }

    private static class RandomAccessOutputStream
    extends OutputStream {
        private RandomAccessFile iRandomAccessFile;
        private RandomAccessFilePool iRandomAccessFilePool;

        RandomAccessOutputStream(File file, RandomAccessFilePool randomAccessFilePool) throws RandomAccessFilePoolException {
            this.iRandomAccessFile = randomAccessFilePool.getFile(file);
            this.iRandomAccessFilePool = randomAccessFilePool;
        }

        public void seek(long l) throws IOException {
            this.iRandomAccessFile.seek(l);
        }

        @Override
        public void write(int n) throws IOException {
            this.iRandomAccessFile.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.iRandomAccessFile.write(byArray, n, n2);
        }

        @Override
        public void close() {
            this.iRandomAccessFilePool.returnFile(this.iRandomAccessFile);
        }

        public void resizeFile(long l) throws IOException {
            long l2 = this.iRandomAccessFile.length();
            if (l2 < 4096L) {
                this.iRandomAccessFile.setLength(4096L);
            }
            if (l >= l2) {
                this.iRandomAccessFile.setLength(2L * l);
            }
        }
    }

    private static final class WriteBlobFileException
    extends BlobFileException {
        WriteBlobFileException(StorageException storageException) {
            super(BlobFileErrorCode.WriteBlobFileError, (Throwable)storageException, new Object[0]);
        }
    }
}

