/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileErrorCode;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.RandomAccessFilePool;
import java.io.File;
import java.io.IOException;

public class BlobFileFactory {
    private RandomAccessFilePool fRandomAccessFilePool;

    public BlobFileFactory(int n) {
        this.fRandomAccessFilePool = new RandomAccessFilePool(n);
    }

    public BlobFile createBlobFile(File file) throws BlobFileException {
        this.createFile(file);
        return new BlobFile(file, this.fRandomAccessFilePool);
    }

    public BlobFile createBlobFile(File file, long l) throws BlobFileException {
        if (!file.exists()) {
            throw new RecreateBlobFileException(file.toString());
        }
        return new BlobFile(file, l, this.fRandomAccessFilePool);
    }

    private void createFile(File file) throws BlobFileException {
        try {
            boolean bl = file.createNewFile();
            if (!bl) {
                throw new BlobFileExistsException(file.toString());
            }
        }
        catch (IOException iOException) {
            throw new CreateBlobFileException(iOException);
        }
    }

    private static final class CreateBlobFileException
    extends BlobFileException {
        CreateBlobFileException(IOException iOException) {
            super(BlobFileErrorCode.CreateBlobFileError, (Throwable)iOException, new Object[0]);
        }
    }

    private static final class BlobFileExistsException
    extends BlobFileException {
        BlobFileExistsException(String string) {
            super(BlobFileErrorCode.BlobFileExistsError, string);
        }
    }

    private static final class RecreateBlobFileException
    extends BlobFileException {
        RecreateBlobFileException(String string) {
            super(BlobFileErrorCode.RecreateBlobFileError, string);
        }
    }
}

