/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.discover;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.mathworks.jmi.Callback;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.distcomp.ui.discover.ClusterTablePage;
import com.mathworks.toolbox.distcomp.ui.discover.PageActionProvider;
import com.mathworks.toolbox.distcomp.ui.discover.SelectLocationPage;
import com.mathworks.toolbox.distcomp.ui.discover.SetDefaultProfilePage;
import com.mathworks.toolbox.distcomp.ui.discover.model.DiscoverClusterWizardModel;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;

public final class DiscoverClusterWizard
extends WizardDialog {
    private Callback fStartDiscoveryCallback;
    private Callback fCreateProfileCallback;
    private Callback fSetDefaultProfileCallback;
    private Callback fCloseCallback;
    private static final int UI_HEIGHT = 375;
    private static final int UI_WIDTH = 650;
    private static final String LAUNCH_WIZARD_FUNCTION = "parallel.internal.ui.DiscoverClusterWizardController.launchWizard";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    public DiscoverClusterWizard(JFrame jFrame, DiscoverClusterWizardModel discoverClusterWizardModel) {
        super((Frame)jFrame, false);
        this.initialize(discoverClusterWizardModel);
    }

    public DiscoverClusterWizard(JDialog jDialog, DiscoverClusterWizardModel discoverClusterWizardModel) {
        super((Dialog)jDialog, false);
        this.initialize(discoverClusterWizardModel);
    }

    private void initialize(DiscoverClusterWizardModel discoverClusterWizardModel) {
        SelectLocationPage selectLocationPage = new SelectLocationPage(discoverClusterWizardModel);
        ClusterTablePage clusterTablePage = new ClusterTablePage(discoverClusterWizardModel);
        SetDefaultProfilePage setDefaultProfilePage = new SetDefaultProfilePage(discoverClusterWizardModel);
        PageList pageList = new PageList();
        pageList.append((AbstractDialogPage)selectLocationPage);
        pageList.append((AbstractDialogPage)clusterTablePage);
        pageList.append((AbstractDialogPage)setDefaultProfilePage);
        this.setPageList(pageList);
        this.fStartDiscoveryCallback = selectLocationPage.getCallback();
        this.fCreateProfileCallback = clusterTablePage.getCallback();
        this.fSetDefaultProfileCallback = setDefaultProfilePage.getCallback();
        this.fCloseCallback = new Callback();
        this.setNextAction((AbstractAction)new MJAbstractAction(sRes.getString("DiscoverDialog.NextButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                ((PageActionProvider)DiscoverClusterWizard.this.getCurrentPage()).doNext();
                DiscoverClusterWizard.this.nextPage();
            }
        });
        this.setCancelAction((AbstractAction)new MJAbstractAction(sRes.getString("DiscoverDialog.CancelButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                ((PageActionProvider)DiscoverClusterWizard.this.getCurrentPage()).doCancel();
                DiscoverClusterWizard.this.setVisible(false);
                DiscoverClusterWizard.this.fCloseCallback.postCallback();
            }
        });
        this.setFinishAction((AbstractAction)new MJAbstractAction(sRes.getString("DiscoverDialog.FinishButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                ((PageActionProvider)DiscoverClusterWizard.this.getCurrentPage()).doFinish();
                DiscoverClusterWizard.this.setVisible(false);
                DiscoverClusterWizard.this.fCloseCallback.postCallback();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                ((PageActionProvider)DiscoverClusterWizard.this.getCurrentPage()).doCancel();
                DiscoverClusterWizard.this.fCloseCallback.postCallback();
            }
        });
        this.setModal(false);
        this.setTitle(sRes.getString("DiscoverDialog.Title"));
        this.setSize(650, 375);
        this.setResizable(true);
        this.setName("DiscoverClusterDialog");
    }

    private void nextPage() {
        this.setCurrentPage((AbstractDialogPage)((AbstractWizardPage)null), false);
    }

    public Callback getCreateProfileCallback() {
        return this.fCreateProfileCallback;
    }

    public Callback getSetDefaultProfileCallback() {
        return this.fSetDefaultProfileCallback;
    }

    public Callback getStartDiscoveryCallback() {
        return this.fStartDiscoveryCallback;
    }

    public Callback getCloseCallback() {
        return this.fCloseCallback;
    }

    public static void launchWizard(final Window window) {
        new MatlabWorker<Object>(){

            public Object runOnMatlabThread() throws Exception {
                return 5.feval((String)DiscoverClusterWizard.LAUNCH_WIZARD_FUNCTION, (Object[])new Object[]{window}, (int)0);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }
}

