/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile.model;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationEventData;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationListener;
import com.mathworks.widgets.login.LoginDialogConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ValidationManager {
    private AtomicBoolean fHasUserCancelledValidation;
    private MLArrayRef fValidatorWrapperRef;
    private LoginDialogConsumer fLoginDialogConsumer;
    private List<ValidationListener> fValidationListenerList = new ArrayList<ValidationListener>();
    private static final String VALIDATION_MANAGER_HELPER = "parallel.internal.ui.ValidationManager";
    private static final String VALIDATE_METHOD = "validate";

    public ValidationManager(LoginDialogConsumer loginDialogConsumer) {
        this.fHasUserCancelledValidation = new AtomicBoolean(false);
        this.fLoginDialogConsumer = loginDialogConsumer;
    }

    public void initialize() {
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 1.feval((String)ValidationManager.VALIDATION_MANAGER_HELPER, (Object[])new Object[]{ValidationManager.this}, (int)1);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                ValidationManager.this.fValidatorWrapperRef = (MLArrayRef)object;
            }
        }.start();
    }

    public void addValidationListener(ValidationListener validationListener) {
        this.fValidationListenerList.add(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.fValidationListenerList.remove(validationListener);
    }

    public void fireValidationStarted(ValidationEventData validationEventData) {
        for (ValidationListener validationListener : this.fValidationListenerList) {
            validationListener.handleValidationStarted(validationEventData);
        }
    }

    public void fireValidationFinished(ValidationEventData validationEventData) {
        for (ValidationListener validationListener : this.fValidationListenerList) {
            validationListener.handleValidationFinished(validationEventData);
        }
    }

    public void fireValidationStageUpdated(ValidationEventData validationEventData) {
        for (ValidationListener validationListener : this.fValidationListenerList) {
            validationListener.handleValidationStageUpdated(validationEventData);
        }
    }

    public void validate(final Profile profile) {
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 2.feval((String)ValidationManager.VALIDATE_METHOD, (Object[])new Object[]{ValidationManager.this.fValidatorWrapperRef, profile.getName(), ValidationManager.this.fLoginDialogConsumer}, (int)0);
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    public void stopValidate() {
        this.fHasUserCancelledValidation.set(true);
    }

    public void resetUserCancelledValidation() {
        this.fHasUserCancelledValidation.set(false);
    }

    public boolean hasUserCancelledValidation() {
        return this.fHasUserCancelledValidation.get();
    }
}

