/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.remote;

import com.mathworks.mwswing.AdjacentButton;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.remote.AbstractCredentialUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class IdentityFileCredentialUI
extends AbstractCredentialUI {
    private MJTextField fUsernameTextField;
    private MJTextField fIdentityFileTextField;
    private JPasswordField fPassPhraseTextField;
    private JButton fBrowseIdentityFileButton;
    private static String sLastUsedUserName;
    private static final String DEFAULT_USERNAME = "root";
    private static String sLastUsedIdentityFile;
    private String fUsername;
    private String fIdentityFile;
    private Password fPassPhrase;
    private final DocumentListener fIdentityFileDocumentListener;

    IdentityFileCredentialUI() {
        MJLabel mJLabel = new MJLabel(sRes.getString("remote.identityfilecredential.username.label"));
        this.fUsernameTextField = new MJTextField(this.getUsername());
        this.fUsernameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdentityFileCredentialUI.this.setUsername(IdentityFileCredentialUI.this.fUsernameTextField.getText());
            }
        });
        this.fUsernameTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)this.fUsernameTextField, new Runnable(){

            @Override
            public void run() {
                IdentityFileCredentialUI.this.setUsername(IdentityFileCredentialUI.this.fUsernameTextField.getText());
            }
        }));
        this.fUsernameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IdentityFileCredentialUI.this.setUsername(IdentityFileCredentialUI.this.fUsernameTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IdentityFileCredentialUI.this.setUsername(IdentityFileCredentialUI.this.fUsernameTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        MJLabel mJLabel2 = new MJLabel(sRes.getString("remote.identityfilecredential.identityfile.label"));
        this.fIdentityFileTextField = new MJTextField(this.getIdentityFile());
        this.fIdentityFileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdentityFileCredentialUI.this.setIdentityFile(IdentityFileCredentialUI.this.fIdentityFileTextField.getText());
            }
        });
        this.fIdentityFileDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IdentityFileCredentialUI.this.setIdentityFile(IdentityFileCredentialUI.this.fIdentityFileTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IdentityFileCredentialUI.this.setIdentityFile(IdentityFileCredentialUI.this.fIdentityFileTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.fIdentityFileTextField.getDocument().addDocumentListener(this.fIdentityFileDocumentListener);
        this.fIdentityFileTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)this.fIdentityFileTextField, new Runnable(){

            @Override
            public void run() {
                IdentityFileCredentialUI.this.setIdentityFile(IdentityFileCredentialUI.this.fIdentityFileTextField.getText());
            }
        }));
        this.fBrowseIdentityFileButton = new AdjacentButton("...", (Component)this.fIdentityFileTextField);
        this.fBrowseIdentityFileButton.addActionListener(new BrowseButtonActionListener());
        MJLabel mJLabel3 = new MJLabel(sRes.getString("remote.identityfilecredential.passphrase.label"));
        this.fPassPhraseTextField = new JPasswordField();
        this.fPassPhraseTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdentityFileCredentialUI.this.setPassphrase(new Password(IdentityFileCredentialUI.this.fPassPhraseTextField.getPassword()));
            }
        });
        this.fPassPhraseTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IdentityFileCredentialUI.this.setPassphrase(new Password(IdentityFileCredentialUI.this.fPassPhraseTextField.getPassword()));
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IdentityFileCredentialUI.this.setPassphrase(new Password(IdentityFileCredentialUI.this.fPassPhraseTextField.getPassword()));
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.fPassPhraseTextField.addFocusListener(new ClickAwayFocusListener(this.fPassPhraseTextField, new Runnable(){

            @Override
            public void run() {
                IdentityFileCredentialUI.this.setPassphrase(new Password(IdentityFileCredentialUI.this.fPassPhraseTextField.getPassword()));
            }
        }));
        this.addLine(new JComponent[][]{{mJLabel, this.fUsernameTextField}});
        this.addLine((JComponent[][])new JComponent[][]{{mJLabel2, this.fIdentityFileTextField, this.fBrowseIdentityFileButton}}, 0, 1);
        this.addLine(new JComponent[][]{{mJLabel3, this.fPassPhraseTextField}});
        this.fUsernameTextField.setName("IdentityFileCredentialUI.UsernameTextField");
        this.fIdentityFileTextField.setName("IdentityFileCredentialUI.IdentityFileTextField");
        this.fBrowseIdentityFileButton.setName("IdentityFileCredentialUI.BrowseButton");
        this.fPassPhraseTextField.setName("IdentityFileCredentialUI.PassphraseTextField");
    }

    @Override
    Credential getCredential() {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.put(IdentityFileCredentialDescription.USERNAME, this.getUsername());
        parameterMap.put(IdentityFileCredentialDescription.IDENTITY_FILE, new File(this.getIdentityFile()));
        if (this.getPassphrase().getPassword().length != 0) {
            parameterMap.put(IdentityFileCredentialDescription.PASSPHRASE, this.getPassphrase());
        }
        return IdentityFileCredentialDescription.INSTANCE.create(parameterMap);
    }

    @Override
    String getLabel() {
        return sRes.getString("remote.identityfilecredential.usernameidentityfile.label");
    }

    private String getUsername() {
        if (this.fUsername == null) {
            this.fUsername = IdentityFileCredentialUI.getLastUsedUserName();
        }
        return this.fUsername;
    }

    private void setUsername(String string) {
        String string2 = this.fUsername;
        this.fUsername = string;
        sLastUsedUserName = string;
        this.firePropertyChange(CREDENTIAL_CHANGED_PROPERTY, string2, this.fUsername);
    }

    private String getIdentityFile() {
        if (this.fIdentityFile == null) {
            this.fIdentityFile = IdentityFileCredentialUI.getLastUsedIdentityFile();
        }
        return this.fIdentityFile;
    }

    private void setIdentityFile(String string) {
        String string2 = this.fIdentityFile;
        this.fIdentityFile = string;
        sLastUsedIdentityFile = string;
        this.fIdentityFileTextField.getDocument().removeDocumentListener(this.fIdentityFileDocumentListener);
        this.fIdentityFileTextField.setText(this.fIdentityFile);
        this.fIdentityFileTextField.getDocument().addDocumentListener(this.fIdentityFileDocumentListener);
        this.firePropertyChange(CREDENTIAL_CHANGED_PROPERTY, string2, this.fIdentityFile);
    }

    private Password getPassphrase() {
        if (this.fPassPhrase == null) {
            this.fPassPhrase = new Password("");
        }
        return this.fPassPhrase;
    }

    private void setPassphrase(Password password) {
        Password password2 = this.fPassPhrase;
        this.fPassPhrase = password;
        this.firePropertyChange(CREDENTIAL_CHANGED_PROPERTY, password2, this.fPassPhrase);
    }

    private static String getLastUsedUserName() {
        if (sLastUsedUserName == null) {
            sLastUsedUserName = DEFAULT_USERNAME;
        }
        return sLastUsedUserName;
    }

    private static String getLastUsedIdentityFile() {
        if (sLastUsedIdentityFile == null) {
            sLastUsedIdentityFile = "";
        }
        return sLastUsedIdentityFile;
    }

    private class BrowseButtonActionListener
    implements ActionListener {
        private MJFileChooserPerPlatform iFileChooser;

        private BrowseButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iFileChooser == null) {
                this.iFileChooser = new MJFileChooserPerPlatform();
                this.iFileChooser.setDialogTitle(AbstractCredentialUI.sRes.getString("remote.identityfilecredential.identityfilebrowse.title"));
            }
            this.iFileChooser.showOpenDialog((Component)IdentityFileCredentialUI.this.fBrowseIdentityFileButton);
            if (this.iFileChooser.getState() == 0 && this.iFileChooser.getSelectedFile() != null) {
                IdentityFileCredentialUI.this.setIdentityFile(this.iFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

