/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ProxiedJobManagerClient;
import com.mathworks.toolbox.distcomp.util.AdminCredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.util.AutomatedAdminConsumerFactory;
import com.mathworks.toolbox.distcomp.util.JobManagerFinder;
import java.rmi.RemoteException;
import javax.swing.JFrame;

public final class AdminUserRegistrar {
    private final JobManagerFinder fJobManagerFinder;
    private final SignatureModule.Signer fSigner;
    private char[] fAdminPassword = null;
    private boolean fGraphical = false;

    public AdminUserRegistrar(String string, String string2, SignatureModule.Signer signer) {
        this.fJobManagerFinder = new JobManagerFinder(string, string2);
        this.fSigner = signer;
        this.setAdminPasswordFromEnvironment();
    }

    public void setAdminPassword(char[] cArray) {
        this.fAdminPassword = cArray;
    }

    public void setGraphical(boolean bl) {
        this.fGraphical = bl;
    }

    public void findJobManagerAndAddAdmin() throws RegistrationException {
        JobManagerLocal jobManagerLocal;
        try {
            jobManagerLocal = this.fJobManagerFinder.findJobManager();
        }
        catch (JobManagerFinder.JobManagerFindException jobManagerFindException) {
            throw new RegistrationException(jobManagerFindException);
        }
        ProxiedJobManagerClient proxiedJobManagerClient = new ProxiedJobManagerClient(jobManagerLocal, this.createCredentialConsumerFactory(), new SingleUserCredentialStore<AuthenticationToken>());
        try {
            proxiedJobManagerClient.addAdminUser(this.fSigner);
        }
        catch (AuthorisationFailedException authorisationFailedException) {
            throw new RegistrationException(authorisationFailedException);
        }
        catch (RemoteException remoteException) {
            throw new RegistrationException(remoteException);
        }
        catch (MJSException mJSException) {
            throw new RegistrationException(mJSException);
        }
    }

    private CredentialConsumerFactory createCredentialConsumerFactory() {
        if (this.fAdminPassword != null) {
            return new AutomatedAdminConsumerFactory(this.fAdminPassword);
        }
        JFrame jFrame = null;
        return new AdminCredentialConsumerFactory(this.fGraphical, jFrame);
    }

    private void setAdminPasswordFromEnvironment() {
        String string = System.getenv("MDCEQE_JOBMANAGER_ADMIN_PASSWORD");
        if (string != null && !string.isEmpty()) {
            this.fAdminPassword = string.toCharArray();
        }
    }

    public static final class RegistrationException
    extends Exception {
        RegistrationException(Throwable throwable) {
            super(throwable);
        }
    }
}

