/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.i18n;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;

public abstract class I18nRuntimeException
extends RuntimeException
implements I18nMatlabIdentifiedException {
    private final I18nMessageCreator fMessageCreator;
    private final BaseMsgID fMessageID;

    public I18nRuntimeException(BaseMsgID baseMsgID) {
        this.fMessageID = baseMsgID;
        this.fMessageCreator = new XMLMessageCreator();
    }

    public I18nRuntimeException(BaseMsgID baseMsgID, Throwable throwable) {
        this(baseMsgID, throwable, (I18nMessageCreator)new XMLMessageCreator());
    }

    public I18nRuntimeException(BaseMsgID baseMsgID, Throwable throwable, I18nMessageCreator i18nMessageCreator) {
        super(throwable);
        this.fMessageID = baseMsgID;
        this.fMessageCreator = i18nMessageCreator;
    }

    public String getMessageID() {
        return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
    }

    @Override
    public String getMessage() {
        return this.fMessageCreator.createMessage(this.fMessageID);
    }

    @Override
    public String getLocalizedMessage() {
        return this.fMessageCreator.createLocalizedMessage(this.fMessageID);
    }
}

