/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;

public class KeyboardPrefs {
    public static final int UNDERLINE = 1;
    public static final int HIGHLIGHT = 2;
    public static final int BALANCE = 3;
    public static final int BEEP = 4;
    public static final int STRIKETHRU = 5;
    public static final int NONE = 6;
    private static final String DELIMITER_OPTIONS = "DelimiterOptions";
    private static final String DELIMITER_MATCHING_TYPING = "DelimiterOptionsTyping";
    private static final String DELIMITER_MATCHING_MOVING = "DelimiterOptionsMoving";
    private static final String DELIMITER_MATCHING_TYPING_MATCH_TYPE = "DelimiterOptionsTypingMatchType";
    private static final String DELIMITER_MATCHING_TYPING_MISMATCH_TYPE = "DelimiterOptionsTypingMisMatchType";
    private static final String DELIMITER_MATCHING_MOVING_MATCH_TYPE = "DelimiterOptionsMovingMatchType";
    private static final String DELIMITER_MATCHING_MOVING_MISMATCH_TYPE = "DelimiterOptionsMovingMisMatchType";
    public static final int DEFAULT_MATCH_TYPE_TYPING = 3;
    public static final int DEFAULT_MISMATCH_TYPE_TYPING = 4;
    public static final int DEFAULT_MATCH_TYPE_MOUSING = 1;
    public static final int DEFAULT_MISMATCH_TYPE_MOUSING = 5;

    private KeyboardPrefs() {
    }

    public static boolean isCmdWinTabCompletionEnabled() {
        return Prefs.getBooleanPref("CommandWindowTabCompletion", true);
    }

    public static boolean isCmdWinFunctionHintsEnabled() {
        return Prefs.getBooleanPref("CommandWindowFunctionHints", true);
    }

    public static void setCmdWinTabCompletionEnabled(boolean bl) {
        Prefs.setBooleanPref("CommandWindowTabCompletion", bl);
    }

    public static void setCmdWinFunctionHintsEnabled(boolean bl) {
        Prefs.setBooleanPref("CommandWindowFunctionHints", bl);
    }

    public static boolean isEditorFunctionHintsEnabled() {
        return Prefs.getBooleanPref("EditorFunctionHints", true);
    }

    public static void setEditorFunctionHintsEnabled(boolean bl) {
        Prefs.setBooleanPref("EditorFunctionHints", bl);
    }

    public static boolean isEditorTabCompletionEnabled() {
        return Prefs.getBooleanPref("EditorTabCompletion", true);
    }

    public static void setEditorTabCompletionEnabled(boolean bl) {
        Prefs.setBooleanPref("EditorTabCompletion", bl);
    }

    public static boolean isTabCompletionNarrowing() {
        return Prefs.getBooleanPref("CommandWindowTabNarrows", false);
    }

    public static void setTabNarrows(boolean bl) {
        Prefs.setBooleanPref("CommandWindowTabNarrows", bl);
    }

    public static boolean isDelimMatchingWhileTyping() {
        return Prefs.getBooleanPref(DELIMITER_MATCHING_TYPING, true);
    }

    public static void setDelimMatchingWhileTyping(boolean bl) {
        Prefs.setBooleanPref(DELIMITER_MATCHING_TYPING, bl);
    }

    public static boolean isDelimMatchingWhileMousing() {
        return Prefs.getBooleanPref(DELIMITER_MATCHING_MOVING, true);
    }

    public static void setDelimMatchingWhileMousing(boolean bl) {
        Prefs.setBooleanPref(DELIMITER_MATCHING_MOVING, bl);
    }

    public static int getDelimMatchTypeWhileTyping() {
        return Prefs.getIntegerPref(DELIMITER_MATCHING_TYPING_MATCH_TYPE, 3);
    }

    public static void setDelimMatchTypeWhileTyping(int n) {
        if (n != 3 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Must be BALANCE, UNDERLINE, or HIGHLIGHT");
        }
        Prefs.setIntegerPref(DELIMITER_MATCHING_TYPING_MATCH_TYPE, n);
    }

    public static int getDelimMismatchTypeWhileTyping() {
        return Prefs.getIntegerPref(DELIMITER_MATCHING_TYPING_MISMATCH_TYPE, 4);
    }

    public static void setDelimMismatchTypeWhileTyping(int n) {
        if (n != 4 && n != 5 && n != 6) {
            throw new IllegalArgumentException("Must be BEEP, STRIKETHRU, or NONE");
        }
        Prefs.setIntegerPref(DELIMITER_MATCHING_TYPING_MISMATCH_TYPE, n);
    }

    public static int getDelimMatchTypeWhileMousing() {
        return Prefs.getIntegerPref(DELIMITER_MATCHING_MOVING_MATCH_TYPE, 1);
    }

    public static void setDelimMatchTypeWhileMousing(int n) {
        if (n != 3 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Must be BALANCE, UNDERLINE, or HIGHLIGHT");
        }
        Prefs.setIntegerPref(DELIMITER_MATCHING_MOVING_MATCH_TYPE, n);
    }

    public static int getDelimMismatchTypeWhileMousing() {
        return Prefs.getIntegerPref(DELIMITER_MATCHING_MOVING_MISMATCH_TYPE, 5);
    }

    public static void setDelimMismatchTypeWhileMousing(int n) {
        if (n != 4 && n != 5 && n != 6) {
            throw new IllegalArgumentException("Must be BEEP, STRIKETHRU, or NONE");
        }
        Prefs.setIntegerPref(DELIMITER_MATCHING_MOVING_MISMATCH_TYPE, n);
    }

    public static void registerForDelimMatchingPrefs(PrefListener prefListener) {
        Prefs.addListener(prefListener, DELIMITER_MATCHING_TYPING);
        Prefs.addListener(prefListener, DELIMITER_MATCHING_MOVING);
        Prefs.addListener(prefListener, DELIMITER_MATCHING_TYPING_MATCH_TYPE);
        Prefs.addListener(prefListener, DELIMITER_MATCHING_TYPING_MISMATCH_TYPE);
        Prefs.addListener(prefListener, DELIMITER_MATCHING_MOVING_MATCH_TYPE);
        Prefs.addListener(prefListener, DELIMITER_MATCHING_MOVING_MISMATCH_TYPE);
    }

    public static boolean didDelimMatchingPrefChange(PrefEvent prefEvent) {
        String string = prefEvent.getPrefKey();
        return string.equals(DELIMITER_MATCHING_TYPING) || string.equals(DELIMITER_MATCHING_MOVING) || string.equals(DELIMITER_MATCHING_TYPING_MATCH_TYPE) || string.equals(DELIMITER_MATCHING_TYPING_MISMATCH_TYPE) || string.equals(DELIMITER_MATCHING_MOVING_MATCH_TYPE) || string.equals(DELIMITER_MATCHING_MOVING_MISMATCH_TYPE);
    }
}

