/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.Prefs;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class PrefsAWT {
    public static Color getColorPref(String string) {
        return PrefsAWT.getColorPref(string, null);
    }

    public static Font getFontPref(String string) {
        return PrefsAWT.getFontPref(string, null);
    }

    public static Rectangle getRectanglePref(String string) {
        return PrefsAWT.getRectanglePref(string, null);
    }

    public static Color getColorPref(String string, Color color) {
        if (color == null) {
            return new Color(Prefs.getRGBColorPref(string));
        }
        return new Color(Prefs.getRGBColorPref(string, color.getRGB()));
    }

    public static Font getFontPref(String string, Font font) {
        Prefs.FontString fontString = font == null ? null : PrefsAWT._fontToFontString(font);
        Prefs.FontString fontString2 = Prefs.getFontStringPref(string, fontString);
        Font font2 = fontString2.equals(fontString) ? font : PrefsAWT.fontStringToFont(fontString2.toString());
        return font2;
    }

    public static Rectangle getRectanglePref(String string, Rectangle rectangle) {
        Prefs.RectString rectString = rectangle == null ? null : PrefsAWT._rectangleToRectString(rectangle);
        Prefs.RectString rectString2 = Prefs.getRectStringPref(string, rectString);
        Rectangle rectangle2 = rectString2.equals(rectString) ? rectangle : PrefsAWT.rectStringToRectangle(rectString2.toString());
        return rectangle2;
    }

    public static void setColorPref(String string, Color color) {
        if (color != null) {
            Prefs.setRGBColorPref(string, color.getRGB());
        }
    }

    public static void setFontPref(String string, Font font) {
        if (font != null) {
            Prefs.FontString fontString = PrefsAWT._fontToFontString(font);
            Prefs.setFontStringPref(string, fontString);
        }
    }

    public static void setRectanglePref(String string, Rectangle rectangle) {
        if (rectangle != null) {
            Prefs.RectString rectString = PrefsAWT._rectangleToRectString(rectangle);
            Prefs.setRectStringPref(string, rectString);
        }
    }

    public static String fontToString(Font font) {
        String string = null;
        if (font != null) {
            StringBuffer stringBuffer = new StringBuffer(6 + font.getName().length());
            stringBuffer.append('F');
            PrefsAWT.intToStringBuffer(stringBuffer, font.getStyle());
            stringBuffer.append(' ');
            PrefsAWT.intToStringBuffer(stringBuffer, font.getSize());
            stringBuffer.append(' ');
            stringBuffer.append(font.getName());
            string = stringBuffer.toString();
        }
        return string;
    }

    public static Font fontStringToFont(String string) {
        Font font = null;
        if (string != null && string.length() > 0) {
            int n = string.charAt(0) == 'F' ? 1 : 0;
            n = PrefsAWT.findToken(string, n);
            int n2 = PrefsAWT.parseInt(string, n);
            n = PrefsAWT.findToken(string, n);
            int n3 = PrefsAWT.parseInt(string, n);
            n &= 0xFFFF;
            while (n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                ++n;
            }
            if (n == string.length() || n3 <= 0) {
                return PrefsAWT.fontStringToFont(Prefs.sDefaultFontStr.toString());
            }
            String string2 = string.substring(n);
            font = new Font(string2, n2, n3);
        }
        return font;
    }

    private static Prefs.FontString _fontToFontString(Font font) {
        return new Prefs.FontString(PrefsAWT.fontToString(font));
    }

    public static String rectangleToString(Rectangle rectangle) {
        String string = null;
        if (rectangle != null) {
            StringBuffer stringBuffer = new StringBuffer(18);
            stringBuffer.append('R');
            PrefsAWT.intToStringBuffer(stringBuffer, rectangle.x);
            stringBuffer.append(' ');
            PrefsAWT.intToStringBuffer(stringBuffer, rectangle.y);
            stringBuffer.append(' ');
            PrefsAWT.intToStringBuffer(stringBuffer, rectangle.width);
            stringBuffer.append(' ');
            PrefsAWT.intToStringBuffer(stringBuffer, rectangle.height);
            string = stringBuffer.toString();
        }
        return string;
    }

    private static Prefs.RectString _rectangleToRectString(Rectangle rectangle) {
        return new Prefs.RectString(PrefsAWT.rectangleToString(rectangle));
    }

    public static Rectangle rectStringToRectangle(String string) {
        Rectangle rectangle = null;
        if (string != null && string.length() > 0) {
            int n = string.charAt(0) == 'R' ? 1 : 0;
            n = PrefsAWT.findToken(string, n);
            int n2 = PrefsAWT.parseInt(string, n);
            n = PrefsAWT.findToken(string, n);
            int n3 = PrefsAWT.parseInt(string, n);
            n = PrefsAWT.findToken(string, n);
            int n4 = PrefsAWT.parseInt(string, n);
            n = PrefsAWT.findToken(string, n);
            int n5 = PrefsAWT.parseInt(string, n);
            rectangle = new Rectangle(n2, n3, n4, n5);
        }
        return rectangle;
    }

    private static int findToken(String string, int n) {
        int n2 = string.length();
        if ((n &= 0xFFFF) < n2) {
            char c = string.charAt(n++);
            while (n < n2 && (c == ' ' || c == '\t')) {
                c = string.charAt(n++);
            }
            int n3 = n;
            while (n < n2 && c != ' ' && c != '\t') {
                c = string.charAt(n++);
            }
            if (n == n2) {
                ++n;
            }
            n |= n3 << 16;
            n -= 65537;
        }
        return n;
    }

    private static int parseInt(String string, int n) {
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        return Prefs.parseInt(string, n2, n3 - n2, 10);
    }

    private static int intToStringBuffer(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        int n3 = n < 0 ? -n : n;
        do {
            stringBuffer.append((char)(n3 % 10 + 48));
        } while ((n3 /= 10) > 0);
        if (n < 0) {
            stringBuffer.append('-');
        }
        int n4 = n2 + (stringBuffer.length() - n2 >> 1);
        for (n3 = n2; n3 < n4; ++n3) {
            int n5 = stringBuffer.length() - n3 + n2 - 1;
            char c = stringBuffer.charAt(n3);
            stringBuffer.setCharAt(n3, stringBuffer.charAt(n5));
            stringBuffer.setCharAt(n5, c);
        }
        return stringBuffer.length() - n2;
    }
}

