/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.binding;

import com.mathworks.services.binding.MatlabKeyBindingPreferenceUtils;
import com.mathworks.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PreferenceState {
    private final List<File> fCustomSetFiles = MatlabKeyBindingPreferenceUtils.readCustomSetFilesFromPrefs();
    private final String fCurrentSet = MatlabKeyBindingPreferenceUtils.readCurrentSetFromPrefs();
    private final Map<File, File> fModifiedDefaultSets = new HashMap<File, File>();

    PreferenceState(List<File> list) throws IOException {
        for (File file : list) {
            File file2 = File.createTempFile(file.getName(), ".test");
            file2.deleteOnExit();
            FileUtils.copyFile((File)file, (File)file2);
            this.fModifiedDefaultSets.put(file, file2);
        }
    }

    void restore() throws IOException {
        MatlabKeyBindingPreferenceUtils.setCustomSetFilesInPrefs(this.fCustomSetFiles);
        MatlabKeyBindingPreferenceUtils.setCurrentSetInPrefs(this.fCurrentSet);
        for (File file : this.fModifiedDefaultSets.keySet()) {
            FileUtils.copyFile((File)this.fModifiedDefaultSets.get(file), (File)file);
        }
    }

    public final boolean isEqual(PreferenceState preferenceState) {
        return this.fCustomSetFiles.equals(preferenceState.fCustomSetFiles) && this.fCurrentSet.equals(preferenceState.fCurrentSet) && this.fModifiedDefaultSets.keySet().equals(preferenceState.fModifiedDefaultSets.keySet());
    }
}

