/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.editordataservice;

import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.services.editordataservice.EditorDataServiceImpl;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class EditorDataServiceManager {
    private static EditorDataServiceManager sDataServiceManager;
    private List<EditorDataServiceImpl> fEditorDataServices = new LinkedList<EditorDataServiceImpl>();
    private final MessageService fMessageService = MessageServiceFactory.getMessageService();
    private boolean fInitialized;
    private static boolean sLoggingErrors;

    private EditorDataServiceManager() {
    }

    private void createNewEditorDataService(String string) {
        this.fEditorDataServices.add(new EditorDataServiceImpl(string));
    }

    public void initialize() {
        if (!this.fInitialized) {
            this.fMessageService.subscribe("/editordataservice/start", new Subscriber(){

                public void handle(Message message) {
                    EditorDataServiceManager.this.createNewEditorDataService(EditorDataServiceManager.getNameSpaceFromMessage(message));
                }
            });
            EditorDataServiceManager.initializeSingletonEditorFeatures();
        }
        this.fInitialized = true;
    }

    private static void initializeSingletonEditorFeatures() {
        List<String> list = EditorDataServiceManager.createSingleTonFeaturesLibrary();
        if (list != null) {
            for (String string : list) {
                try {
                    Class<?> clazz = Class.forName(string);
                    clazz.newInstance();
                }
                catch (Exception exception) {
                    if (!sLoggingErrors) continue;
                    exception.printStackTrace();
                }
            }
        }
    }

    private static List<String> createSingleTonFeaturesLibrary() {
        return Arrays.asList("com.mathworks.mde.editor.plugins.editordataservice.MatlabExecutionService");
    }

    private static String getNameSpaceFromMessage(Message message) {
        assert (message.getData() instanceof String) : "Incorrect format of /editordataservice/start message";
        return "/editordataservice/" + message.getData();
    }

    public static EditorDataServiceManager getInstance() {
        if (sDataServiceManager == null) {
            sDataServiceManager = new EditorDataServiceManager();
        }
        return sDataServiceManager;
    }

    static {
        sLoggingErrors = false;
    }
}

