/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.editordataservice;

import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNode;
import java.lang.reflect.Constructor;
import java.util.Map;

public class EditorNodeUtilities {
    public static final String FEATURE_REGISTRATION_EVENT_ID = "registerFeature";
    public static final String DOCUMENT_CHANGED_EVENT_ID = "documentChanged";

    private EditorNodeUtilities() {
    }

    static boolean isFeatureRegisterEvent(Event event) {
        return FEATURE_REGISTRATION_EVENT_ID.equals(event.getData().get("type"));
    }

    static boolean isDocumentChanged(Event event) {
        return DOCUMENT_CHANGED_EVENT_ID.equals(event.getData().get("type"));
    }

    static String getFeatureIdFromEvent(Event event) {
        return (String)event.getData().get("featureId");
    }

    static String getDocumentTextFromEvent(Event event) {
        return (String)event.getData().get("data");
    }

    static String getUniqueIdFromNode(PeerNode peerNode) {
        Map map = (Map)peerNode.getProperty("backingStore");
        return (String)map.get("uniqueId");
    }

    public static EditorFeature constructEditorFeatureInstance(EditorNode editorNode, String string) throws Exception {
        Class[] classArray = new Class[]{EditorNode.class};
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(classArray);
        Object[] objectArray = new Object[]{editorNode};
        return (EditorFeature)constructor.newInstance(objectArray);
    }
}

