/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.mathworks.hg.peer.GraphicsImageListener;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.SwingUtilities;

public class GraphicsImageGrabber {
    public static boolean MGG_CLASS = true;
    private GLAutoDrawable fDrawable = null;
    private AWTGLReadBufferUtil fAWTGLReadBufferUtil = null;
    private GraphicsImageListener fImageListener = null;
    private GLEventListener fGLEventListener = null;
    private boolean fEnabled = false;
    private BufferedImage fLastImage = null;

    public GraphicsImageGrabber(GLAutoDrawable drawable) {
        this.fDrawable = drawable;
        this.fGLEventListener = new GrabberGLEventListener();
        this.fEnabled = false;
    }

    public void setGraphicsImageListener(GraphicsImageListener listener) {
        this.fImageListener = listener;
        this.fDrawable.addGLEventListener(this.fGLEventListener);
        this.fDrawable.setAutoSwapBufferMode(false);
        if (this.fEnabled) {
            this.fDrawable.display();
        }
    }

    public void removeGraphicsImageListener() {
        this.fDrawable.removeGLEventListener(this.fGLEventListener);
        this.fImageListener = null;
        this.fDrawable.setAutoSwapBufferMode(true);
    }

    public void setEnabled(boolean enabled) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.fEnabled && enabled) {
            this.fEnabled = enabled;
            if (this.fImageListener != null) {
                if (this.fLastImage != null) {
                    this.fImageListener.acceptImage(this.fLastImage);
                } else {
                    this.fDrawable.display();
                }
            }
        } else {
            this.fEnabled = enabled;
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    private class GrabberGLEventListener
    implements GLEventListener {
        private GrabberGLEventListener() {
        }

        public void display(GLAutoDrawable d) {
            if (GraphicsImageGrabber.this.fAWTGLReadBufferUtil == null) {
                GraphicsImageGrabber.this.fAWTGLReadBufferUtil = new AWTGLReadBufferUtil(d.getGLProfile(), false);
            }
            boolean awtOrientation = true;
            if (d instanceof GLJPanel) {
                GLJPanel gljp = (GLJPanel)d;
                awtOrientation = !d.isGLOriented() || !gljp.getSkipGLOrientationVerticalFlip();
            }
            d.swapBuffers();
            BufferedImage outputImage = GraphicsImageGrabber.this.fAWTGLReadBufferUtil.readPixelsToBufferedImage(d.getGL(), awtOrientation);
            if (GraphicsImageGrabber.this.fEnabled && GraphicsImageGrabber.this.fImageListener != null) {
                GraphicsImageGrabber.this.fImageListener.acceptImage(outputImage);
                GraphicsImageGrabber.this.fLastImage = null;
            } else {
                GraphicsImageGrabber.this.fLastImage = outputImage;
            }
        }

        public void init(GLAutoDrawable d) {
        }

        public void dispose(GLAutoDrawable d) {
        }

        public void reshape(GLAutoDrawable d, int i, int i1, int i2, int i3) {
        }
    }
}

