/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.DefaultCellHandler;
import com.mathworks.matlabserver.jcp.utils.ImageUtils;
import com.mathworks.matlabserver.jcp.utils.TextUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JLabelHandler<R>
extends DefaultCellHandler<R, JLabel> {
    public JLabelHandler(String type) {
        super(type);
    }

    @Override
    public Map<String, Object> getProperties(JComponent component, R renderer, JLabel cell) {
        Map<String, Object> props = super.getProperties(component, renderer, cell);
        if (props != null) {
            props.put("textAlign", TextUtils.getAlignmentText(cell.getHorizontalAlignment()));
            TextUtils.setFontProperties(cell.getFont(), props);
            return props;
        }
        return null;
    }

    @Override
    public Object getCellValue(JComponent component, R renderer, JLabel cell, Object value) {
        HashMap<String, Object> props = null;
        if (cell.getIcon() != null) {
            props = new HashMap<String, Object>();
            props.put("icon", ImageUtils.getImageFromIcon(cell.getIcon(), cell));
        }
        if (cell.isBackgroundSet() && cell.getClass().getName().contains("ViewExclude")) {
            if (props == null) {
                props = new HashMap();
            }
            props.put("background", new int[]{cell.getBackground().getRed(), cell.getBackground().getGreen(), cell.getBackground().getBlue()});
        }
        if (props != null) {
            props.put("value", cell.getText());
            return props;
        }
        return cell.getText();
    }
}

