/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractSpinnerHandler
extends AbstractComponentHandler {
    protected SpinnerModel spinnerModel;
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractSpinnerHandler.this.markDirty();
        }
    };
    private Observer propertySetListener = new Observer(){

        public void handle(Event event) {
            String key = event.getData().get("key").toString();
            if (key.equals("currentValue") && !AbstractSpinnerHandler.this.updatingPeerNode) {
                final Number currentValue = (Number)event.getTarget().getProperty("currentValue");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractSpinnerHandler.this.spinnerModel.getValue() instanceof Integer && currentValue instanceof Integer) {
                            AbstractSpinnerHandler.this.spinnerModel.setValue(currentValue);
                        } else if (AbstractSpinnerHandler.this.spinnerModel.getValue() instanceof Integer && currentValue instanceof Double) {
                            AbstractSpinnerHandler.this.spinnerModel.setValue(currentValue.intValue());
                        } else if (AbstractSpinnerHandler.this.spinnerModel.getValue() instanceof Double && currentValue instanceof Double) {
                            AbstractSpinnerHandler.this.spinnerModel.setValue(currentValue);
                        } else {
                            throw new IllegalArgumentException("Unsupported data type");
                        }
                    }
                });
            }
        }
    };
    private PropertyChangeListener propertychangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractSpinnerHandler.this.spinnerModel.removeChangeListener(AbstractSpinnerHandler.this.changeListener);
            AbstractSpinnerHandler.this.spinnerModel = (SpinnerModel)evt.getNewValue();
            AbstractSpinnerHandler.this.spinnerModel.addChangeListener(AbstractSpinnerHandler.this.changeListener);
            AbstractSpinnerHandler.this.markDirty();
        }
    };

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.spinnerModel = ((JSpinner)component).getModel();
        super.handle(parentHandler, component, parentNode);
        this.peerNode.addEventListener("propertySet", this.propertySetListener);
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.spinnerModel.addChangeListener(this.changeListener);
        this.component.addPropertyChangeListener("model", this.propertychangeListener);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.spinnerModel.removeChangeListener(this.changeListener);
        this.component.removePropertyChangeListener("model", this.propertychangeListener);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("propertySet", this.propertySetListener);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("propertySet", this.propertySetListener);
    }
}

