/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.MasterCellHandler;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.utils.MouseHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JComboBoxHandler
extends AbstractComponentHandler
implements ListDataListener,
DocumentListener,
ItemListener {
    protected JComboBox comboBox;
    private MouseHandler mouseHandler;
    private static MasterCellHandler cellHandler = new MasterCellHandler();
    private boolean gettingOptions = false;
    private ComboBoxModel model;
    private boolean updating = false;
    private Observer propSetObserver = new Observer(){

        public void handle(Event event) {
            if (JComboBoxHandler.this.updatingPeerNode) {
                return;
            }
            final Map newValues = (Map)event.getData().get("newValues");
            Object obj = newValues.get("selectedIndex");
            int index = -1;
            if (newValues.containsKey("selectedIndex")) {
                if (obj instanceof Double) {
                    index = ((Double)obj).intValue();
                } else if (obj instanceof Integer) {
                    index = (Integer)obj;
                }
            }
            final int newIndex = index;
            if (newValues.containsKey("displayedValue") && newIndex < 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JComboBoxHandler.this.updating = true;
                        try {
                            String newValue = (String)newValues.get("displayedValue");
                            JComboBoxHandler.this.comboBox.setSelectedIndex(-1);
                            Component editor = JComboBoxHandler.this.comboBox.getEditor().getEditorComponent();
                            if (editor instanceof JTextField) {
                                editor.requestFocus();
                                ((JTextField)editor).setText(newValue);
                                ((JTextField)editor).postActionEvent();
                            }
                        }
                        finally {
                            JComboBoxHandler.this.updating = false;
                            JComboBoxHandler.this.markDirty();
                        }
                    }
                });
            } else if (newValues.containsKey("selectedIndex")) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JComboBoxHandler.this.updating = true;
                        try {
                            if (newIndex > -1) {
                                if (JComboBoxHandler.this.comboBox.isShowing()) {
                                    if (JComboBoxHandler.this.comboBox.getClass().getName().contains("hg.peer")) {
                                        JComboBoxHandler.this.comboBox.requestFocus();
                                        Dimension size = JComboBoxHandler.this.comboBox.getPreferredSize();
                                        JComboBoxHandler.this.mouseHandler.click(new Point(size.width / 2, size.height / 2));
                                    } else {
                                        JComboBoxHandler.this.comboBox.showPopup();
                                    }
                                }
                                JComboBoxHandler.this.comboBox.setSelectedIndex(newIndex);
                                if (JComboBoxHandler.this.comboBox.isShowing()) {
                                    JComboBoxHandler.this.comboBox.hidePopup();
                                }
                            } else {
                                JComboBoxHandler.this.comboBox.setSelectedIndex(newIndex);
                            }
                        }
                        finally {
                            JComboBoxHandler.this.updating = false;
                            JComboBoxHandler.this.markDirty();
                        }
                    }
                });
            }
        }
    };

    @Override
    public String getType() {
        return "Dropdown";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.comboBox = (JComboBox)component;
        this.mouseHandler = new MouseHandler(this.comboBox);
        super.handle(parentHandler, component, parent);
    }

    @Override
    public Map<String, Object> doGetProperties(Component component) {
        if (!this.updating) {
            Object[] getOptionsObject;
            Map<String, Object> properties = super.doGetProperties(component);
            if (this.model != this.comboBox.getModel()) {
                this.removeModelListListeners();
                this.addModelListListeners();
            }
            properties.put("renderer", cellHandler.getProperties((JComponent)this.comboBox, this.comboBox.getRenderer(), (Object)null));
            if (!this.gettingOptions && (getOptionsObject = this.getOptions(this.getPopupList(this.comboBox, this.comboBox.getClass()), this.comboBox)) != null) {
                properties.put("options", getOptionsObject);
            }
            properties.put("selectedIndex", this.comboBox.getSelectedIndex());
            properties.put("editable", this.comboBox.isEditable());
            if (this.comboBox.isEditable()) {
                properties.put("displayedValue", cellHandler.getCellValue((JComponent)this.comboBox, this.comboBox.getEditor(), this.comboBox.getEditor().getEditorComponent(), this.comboBox.getSelectedItem()));
            }
            return properties;
        }
        return new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getOptions(JList popupList, JComboBox comboBox) {
        this.gettingOptions = true;
        Object[] options = null;
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                Object item = comboBox.getItemAt(i);
                if (item == null || item instanceof String && ((String)item).equalsIgnoreCase("More Plot Types...")) continue;
                list.add(cellHandler.getCellValue((JComponent)comboBox, comboBox.getRenderer(), comboBox.getRenderer().getListCellRendererComponent(popupList, item, i, false, false), item));
            }
            options = new Object[list.size()];
            list.toArray(options);
            Object[] objectArray = options;
            return objectArray;
        }
        catch (Exception ignore) {
        }
        finally {
            this.gettingOptions = false;
        }
        return options;
    }

    private JList getPopupList(JComboBox comboBox, Class aClass) {
        try {
            Field popupField = aClass.getDeclaredField("popupList");
            popupField.setAccessible(true);
            return (JList)popupField.get(comboBox);
        }
        catch (Exception e) {
            if (!aClass.equals(Object.class)) {
                return this.getPopupList(comboBox, aClass.getSuperclass());
            }
            return new JList();
        }
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.addModelListListeners();
        if (this.comboBox.getEditor() != null && this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.comboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.removeModelListListeners();
        if (this.comboBox.getEditor() != null && this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.comboBox.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this);
        }
    }

    private void addModelListListeners() {
        this.model = this.comboBox.getModel();
        this.model.addListDataListener(this);
    }

    private void removeModelListListeners() {
        if (this.model != null) {
            this.model.removeListDataListener(this);
        }
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("propertiesSet", this.propSetObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("propertiesSet", this.propSetObserver);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }
}

