/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.ListDataModelHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.PathBrowserListDataModelHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.CellHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.MasterCellHandler;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.utils.BorderUtils;
import com.mathworks.matlabserver.jcp.utils.KeyboardUtils;
import com.mathworks.matlabserver.jcp.utils.MouseUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.impl.PagedDataImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JListTableHandler
extends AbstractComponentHandler
implements ListSelectionListener {
    private JList list = null;
    private CellHandler cellHandler = new MasterCellHandler();
    private ListDataModelHandler handler;
    protected Observer peerListener = new Observer(){

        public void handle(final Event event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (event.getData().get("type").equals("contextMenu")) {
                        Point pos = JListTableHandler.this.list.indexToLocation(JListTableHandler.this.handler.convertClientRowToListRow(JListTableHandler.this.list.getSelectedIndex()));
                        if (pos != null) {
                            MouseUtils.performClick(JListTableHandler.this.list, pos.x, pos.y, 0, 4, 1);
                        }
                    } else if (event.getData().get("type").equals("doubleClick")) {
                        JListTableHandler.this.listClick(JListTableHandler.this.list.getSelectedIndex(), 0, 2);
                    }
                    KeyboardUtils.handleKeyEvent(JListTableHandler.this.list, event.getData());
                }
            });
        }
    };
    private boolean updating = false;
    private Observer propSetListener = new Observer(){

        public void handle(Event event) {
            if (JListTableHandler.this.updatingPeerNode) {
                return;
            }
            if (event.getData().get("key").equals("selectedIndices")) {
                Map data = event.getData();
                if (data.get("newValue") instanceof int[]) {
                    int[] selections = (int[])data.get("newValue");
                    JListTableHandler.this.setSelectedIndices(JListTableHandler.this.list, selections);
                } else {
                    Object[] newObjs = (Object[])data.get("newValue");
                    int[] selections = new int[newObjs.length];
                    for (int i = 0; i < newObjs.length; ++i) {
                        selections[i] = newObjs[i] instanceof Double ? ((Double)newObjs[i]).intValue() : ((Integer)newObjs[i]).intValue();
                    }
                    JListTableHandler.this.setSelectedIndices(JListTableHandler.this.list, selections);
                }
            }
        }
    };

    @Override
    public String getType() {
        return "List";
    }

    @Override
    public String getComponentName() {
        return this.list.getName();
    }

    @Override
    public String getComponentSwingType() {
        return this.list.getClass().getSimpleName();
    }

    @Override
    public boolean ownsComponent(Component component) {
        return super.ownsComponent(component) || this.list.equals(component);
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode, Container parentContainer) {
        this.list = component instanceof JScrollPane ? (JList)((JScrollPane)component).getViewport().getComponent(0) : (JList)component;
        super.handle(parentHandler, component, parentNode, parentContainer);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        BorderUtils.addBorderProperties(component, ((JComponent)component).getBorder(), props);
        if (this.list.getFixedCellHeight() > 0) {
            props.put("rowHeight", this.list.getFixedCellHeight());
        } else if (this.list.getModel().getSize() > 0) {
            props.put("rowHeight", this.list.getCellRenderer().getListCellRendererComponent(this.list, this.list.getModel().getElementAt(0), 0, false, false).getPreferredSize().getHeight());
        }
        props.put("selectedIndices", this.list.getSelectedIndices());
        props.put("selectionMode", this.list.getSelectionMode() == 2 || this.list.getSelectionMode() == 1 ? "extended" : "single");
        props.put("renderer", this.cellHandler.getProperties(this.list, this.list.getCellRenderer(), null));
        if (this.list.getBackground() != null) {
            props.put("background", new int[]{this.list.getBackground().getRed(), this.list.getBackground().getGreen(), this.list.getBackground().getBlue()});
        }
        return props;
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.list.addListSelectionListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JListTableHandler.this.list.getClass().getName().contains("PathBrowser$PathList")) {
                    JListTableHandler.this.handler = new PathBrowserListDataModelHandler(JListTableHandler.this.list);
                } else {
                    JListTableHandler.this.handler = new ListDataModelHandler(JListTableHandler.this.list);
                }
                JListTableHandler.this.peerNode.setProperty("dataModel", (Object)new PagedDataImpl(JListTableHandler.this.peerNode, "dataModel", (DataModelHandler)JListTableHandler.this.handler));
            }
        });
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.list.removeListSelectionListener(this);
        if (this.peerNode.hasProperty("dataModel")) {
            ((PagedDataImpl)this.peerNode.getProperty("dataModel")).destroy();
        }
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.peerListener);
        this.peerNode.addEventListener("propertySet", this.propSetListener);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.peerListener);
        this.peerNode.removeEventListener("propertySet", this.propSetListener);
    }

    private void setSelectedIndices(final JList list, final int[] selections) {
        if (list == null || selections == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JListTableHandler.this.updating = true;
                try {
                    Arrays.sort(selections);
                    int[] oldSelections = list.getSelectedIndices();
                    int selectionAnchor = list.getAnchorSelectionIndex();
                    if (selections.length == 0) {
                        for (int selected : selections) {
                            JListTableHandler.this.click(selected, 130);
                        }
                    } else if (selections.length == 1) {
                        JListTableHandler.this.click(selections[0], 0);
                    } else if ((selectionAnchor == selections[0] || selectionAnchor == selections[selections.length - 1]) && JListTableHandler.this.isSequential(selections)) {
                        int index = selectionAnchor == selections[0] ? selections[selections.length - 1] : selections[0];
                        int modifiers = 65;
                        JListTableHandler.this.click(index, modifiers);
                    } else {
                        for (int oldSelected : oldSelections) {
                            if (Arrays.binarySearch(selections, oldSelected) >= 0) continue;
                            JListTableHandler.this.click(oldSelected, 130);
                        }
                        for (int selected : selections) {
                            if (Arrays.binarySearch(oldSelections, selected) >= 0) continue;
                            JListTableHandler.this.click(selected, 130);
                        }
                    }
                }
                finally {
                    JListTableHandler.this.updating = false;
                }
            }
        });
    }

    private void click(int index, int modifiers) {
        this.click(this.handler.convertClientRowToListRow(index), modifiers, 1);
    }

    private void click(int index, int modifiers, int count) {
        this.listClick(this.handler.convertClientRowToListRow(index), modifiers, count);
    }

    private void listClick(int index, int modifiers, int count) {
        Point point;
        if (index >= 0 && (point = this.list.indexToLocation(index)) != null) {
            int buttons = 1040;
            MouseUtils.pressed(this.list, point.x, point.y, modifiers, buttons, count);
            MouseUtils.released(this.list, point.x, point.y, modifiers, buttons, count);
            MouseUtils.clicked(this.list, point.x, point.y, modifiers, buttons, count);
        }
    }

    private boolean isSequential(int[] selections) {
        int last = selections[0];
        for (int i = 1; i < selections.length; ++i) {
            if (selections[i] != last + 1) {
                return false;
            }
            last = selections[i];
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.updating) {
            this.markDirty();
        }
    }
}

