/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers.variableeditor;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.pageddata.ClientPagedData;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.PagedDataFactory;
import com.mathworks.peermodel.pageddata.ServerPagedData;
import com.mathworks.peermodel.pageddata.impl.PagedDataImpl;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class GridEditorHandler {
    protected PeerNode fGridNode;
    protected ArrayHandler fArrayHandler;
    protected PeerNode fViewModelNode;
    protected UDDObject fViewModelMCOS;
    protected UDDListener fViewModelNodeObserver;
    protected String fVarName;
    protected volatile boolean fAsyncUpdateQueued = false;
    protected int fMatlabTimeout = 3000;

    public void init(String varName, PeerNode viewModelPeerNode, UDDObject viewModelMCOS) {
        this.fViewModelNode = viewModelPeerNode;
        this.fViewModelMCOS = viewModelMCOS;
        this.fArrayHandler = new ArrayHandler();
        this.fVarName = varName;
        if (this.fViewModelMCOS.isValid()) {
            this.fViewModelNodeObserver = new UDDListener(this.fViewModelMCOS, "DataChange"){

                public void execute(UDDObject eventSource, UDDObject eventData) {
                    try {
                        if (((MLArrayRef)eventData.getPropertyValue("Range")).getM() == 1) {
                            double[] cellCoordinates = (double[])((MLArrayRef)eventData.getPropertyValue("Range")).getData();
                            String cellValue = (String)((MLArrayRef)eventData.getPropertyValue("Values")).getData();
                            GridEditorHandler.this.workspaceCellChange((int)cellCoordinates[0] - 1, (int)cellCoordinates[1] - 1, cellValue);
                        } else {
                            double[] dims = (double[])Matlab.mtFeval((String)"getSize", (Object[])new Object[]{GridEditorHandler.this.fViewModelMCOS}, (int)1);
                            GridEditorHandler.this.workspaceChange((int)dims[0], (int)dims[1]);
                        }
                    }
                    catch (Exception e) {
                        GridEditorHandler.this.sendExceptionToClient(e);
                        System.out.println(e);
                    }
                }
            };
            if (FactoryUtils.isMatlabThread()) {
                this.getSizeFromMatlab();
            } else {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GridEditorHandler.this.getSizeFromMatlab();
                    }
                });
            }
        }
    }

    private void getSizeFromMatlab() {
        try {
            double[] dims = (double[])Matlab.mtFeval((String)"getSize", (Object[])new Object[]{this.fViewModelMCOS}, (int)1);
            this.workspaceChange((int)dims[0], (int)dims[1]);
        }
        catch (Exception e) {
            this.sendExceptionToClient(e);
            System.out.println(e);
        }
    }

    public PeerNode getGridNode() {
        return this.fGridNode;
    }

    public ArrayHandler getArrayHandler() {
        return this.fArrayHandler;
    }

    public PeerNode getViewModelPeerNode() {
        return this.fViewModelNode;
    }

    public UDDObject getViewModelMCOS() {
        return this.fViewModelMCOS;
    }

    protected abstract void buildTableProps();

    public void refresh() {
        ((PagedDataImpl)this.fGridNode.getProperty("dataModel")).update();
    }

    public void resetDataModel() {
        if (this.fGridNode.getProperty("dataModel") == null) {
            ClientPagedData pagedData = PagedDataFactory.createPagedData((PeerNode)this.fGridNode, (String)"dataModel", (DataModelHandler)this.fArrayHandler);
            this.fGridNode.setProperty("dataModel", (Object)pagedData);
        }
        ((PagedDataImpl)this.fGridNode.getProperty("dataModel")).update();
    }

    public static Class<? extends ClientPagedData> getImpl() {
        return PagedDataImpl.class;
    }

    public void workspaceCellChange(int row, int col, String data) throws Exception {
        if (this.fArrayHandler != null && this.fArrayHandler.iArrayBlock != null) {
            this.fArrayHandler.iArrayBlock.setValueAt(row, col, data);
        }
        this.refresh();
    }

    public void workspaceChange(int rowCount, int columnCount) throws Exception {
        this.fArrayHandler.workspaceChange(rowCount, columnCount);
        if (this.fGridNode == null) {
            this.fGridNode = this.fViewModelNode.addChild("DataGrid", new HashMap());
            this.fGridNode.addEventListener("propertySet", new Observer(){

                public void handle(final Event event) {
                    if (event.getData().get("key").equals("Selection") && GridEditorHandler.this.fViewModelMCOS.isValid()) {
                        Matlab.whenMatlabIdle((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Matlab.mtFeval((String)"handleClientSelection", (Object[])new Object[]{GridEditorHandler.this.fViewModelMCOS, event.getData()}, (int)0);
                                }
                                catch (Exception e) {
                                    GridEditorHandler.this.sendExceptionToClient(e);
                                    System.out.println(e);
                                }
                            }
                        });
                    }
                }
            });
            this.fViewModelNode.addEventListener("propertySet", new Observer(){

                public void handle(final Event event) {
                    if (event.getData().get("key").equals("Selection")) {
                        Matlab.whenMatlabIdle((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GridEditorHandler.this.fGridNode.setProperty("Selection", event.getData().get("newValue"));
                                }
                                catch (Exception e) {
                                    GridEditorHandler.this.sendExceptionToClient(e);
                                    System.out.println(e);
                                }
                            }
                        });
                    }
                }
            });
        }
        this.resetDataModel();
        this.refresh();
        this.buildTableProps();
    }

    protected static String[][] reshapeRenderedData(String[] renderedVector, double[] dims) {
        String[][] renderedData = new String[(int)dims[0]][(int)dims[1]];
        for (int row = 0; row < (int)dims[0]; ++row) {
            for (int col = 0; col < (int)dims[1]; ++col) {
                if (row + col * (int)dims[0] >= renderedVector.length) continue;
                renderedData[row][col] = renderedVector[row + col * (int)dims[0]];
            }
        }
        return renderedData;
    }

    public void sendExceptionToClient(Exception e) {
        try {
            HashMap<String, String> replyMap = new HashMap<String, String>();
            replyMap.put("type", "errormsg");
            replyMap.put("message", GridEditorHandler.getStackTrace(e));
            this.getGridNode().dispatchPeerEvent("errormsg", this.getGridNode(), replyMap);
            Log.logException((Exception)e);
        }
        catch (Exception ex) {
            Log.logException((Exception)ex);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.write(throwable.getMessage());
        pw.write(10);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public void setDataToMatlab(String newValue, int row, int column) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("row", row + 1);
        map.put("column", column + 1);
        map.put("data", newValue);
        if (this.fViewModelMCOS.isValid()) {
            Matlab.mtFeval((String)"handleClientSetData", (Object[])new Object[]{this.fViewModelMCOS, map}, (int)1);
        }
    }

    public String[][] getRenderedDataFromMatlab(int startRow, int endRow, int startColumn, int endColumn) throws Exception {
        String[][] result = null;
        if (this.fViewModelMCOS.isValid()) {
            Object[] outArgs = (Object[])Matlab.mtFeval((String)"getRenderedData", (Object[])new Object[]{this.fViewModelMCOS, startRow + 1, endRow + 1, startColumn + 1, endColumn + 1}, (int)2);
            result = GridEditorHandler.reshapeRenderedData((String[])outArgs[0], (double[])outArgs[1]);
        }
        return result;
    }

    public int getMatlabTimeout() {
        return this.fMatlabTimeout;
    }

    public void setMatlabTimeout(int fMatlabTimeout) {
        this.fMatlabTimeout = fMatlabTimeout;
    }

    public static class ArrayBlock {
        public int iStartRow;
        public int iStartColumn;
        public String[][] iArray;

        private ArrayBlock(int startRow, int startColumn, String[][] array) {
            this.iStartRow = startRow;
            this.iStartColumn = startColumn;
            this.iArray = array;
        }

        public boolean containsCell(int row, int col) {
            if (this.iArray == null) {
                return false;
            }
            return row >= this.iStartRow && row < this.iStartRow + this.iArray.length && col >= this.iStartColumn && col < this.iStartColumn + this.iArray[row - this.iStartRow].length;
        }

        public String valueAt(int row, int col) {
            return this.iArray[row - this.iStartRow][col - this.iStartColumn];
        }

        private void setValueAt(int row, int col, String value) {
            if (this.containsCell(row, col)) {
                this.iArray[row - this.iStartRow][col - this.iStartColumn] = value;
            }
        }
    }

    public class ArrayHandler
    implements DataModelHandler {
        private ArrayBlock iArrayBlock;
        private int iRowCount = -1;
        private int iColumnCount = -1;
        private Object iLastSetCellValue;
        private int iLastSelCellRow = -1;
        private int iLastSelCellColumn = -1;

        public void workspaceChange(int rowCount, int columnCount) throws Exception {
            this.iArrayBlock = null;
            this.iRowCount = rowCount;
            this.iColumnCount = columnCount;
            this.iLastSetCellValue = null;
            this.iLastSelCellRow = -1;
            this.iLastSelCellColumn = -1;
        }

        public void update(ServerPagedData serverPagedData) {
        }

        public void destroy() {
            System.out.println("destroyed");
        }

        public int getRowCount() {
            return this.iRowCount;
        }

        public int getColumnCount() {
            return this.iColumnCount;
        }

        public boolean is2D() {
            return true;
        }

        public Object getValueAt(int i) {
            return "";
        }

        public <T> T synchronouslyCallMATLAB(final Callable<T> callable) throws Exception {
            block5: {
                if (GridEditorHandler.this.fViewModelMCOS.isValid()) {
                    Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<T>(){

                        public void callOnEdt(T result, boolean completedNormally) {
                        }

                        public T call() {
                            try {
                                return callable.call();
                            }
                            catch (Exception e) {
                                System.out.println(e);
                                return null;
                            }
                        }
                    });
                    try {
                        return (T)future.get(GridEditorHandler.this.fMatlabTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        System.out.println(e);
                        break block5;
                    }
                    catch (InterruptedException e) {
                        System.out.println(e);
                        break block5;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        GridEditorHandler.this.sendExceptionToClient(e);
                        break block5;
                    }
                }
                return callable.call();
            }
            return null;
        }

        public Object getValueAt(int i, int j) {
            PagedDataImpl data = (PagedDataImpl)GridEditorHandler.this.fGridNode.getProperty("dataModel");
            if (this.iArrayBlock != null && this.iArrayBlock.containsCell(i, j)) {
                return this.iArrayBlock.valueAt(i, j);
            }
            try {
                final int startRow = data.getCurrentStartRow() < 0 ? 0 : data.getCurrentStartRow();
                final int endRow = data.getCurrentEndRow();
                final int startColumn = data.getCurrentStartCol() < 0 ? 0 : data.getCurrentStartCol();
                final int endColumn = data.getCurrentEndCol();
                String[][] renderedData = this.synchronouslyCallMATLAB(new Callable<String[][]>(){

                    @Override
                    public String[][] call() throws Exception {
                        return GridEditorHandler.this.getRenderedDataFromMatlab(startRow, endRow, startColumn, endColumn);
                    }
                });
                if (renderedData != null) {
                    this.iArrayBlock = new ArrayBlock(startRow, startColumn, renderedData);
                    return this.iArrayBlock.valueAt(i, j);
                }
                this.requestAsyncRefresh();
                return "";
            }
            catch (Exception e) {
                System.out.println(e);
                this.requestAsyncRefresh();
                return "";
            }
        }

        protected synchronized void requestAsyncRefresh() {
            if (!GridEditorHandler.this.fAsyncUpdateQueued) {
                GridEditorHandler.this.fAsyncUpdateQueued = true;
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            double[] dims = (double[])Matlab.mtFeval((String)"getSize", (Object[])new Object[]{GridEditorHandler.this.fViewModelMCOS}, (int)1);
                            ArrayHandler.this.workspaceChange((int)dims[0], (int)dims[1]);
                            GridEditorHandler.this.fAsyncUpdateQueued = false;
                        }
                        catch (Exception e) {
                            GridEditorHandler.this.fAsyncUpdateQueued = false;
                            ArrayHandler.this.requestAsyncRefresh();
                        }
                    }
                });
            }
        }

        public void setValueAt(Object o, int i) {
            System.out.println(o);
        }

        public void setValueAt(final Object o, final int i, final int j) {
            if (i == this.iLastSelCellRow && j == this.iLastSelCellColumn && o.equals(this.iLastSetCellValue)) {
                return;
            }
            this.iLastSetCellValue = o;
            this.iLastSelCellRow = i;
            this.iLastSelCellColumn = j;
            String cachedCellText = null;
            if (this.iArrayBlock != null) {
                cachedCellText = this.iArrayBlock.valueAt(i, j);
                if (this.iArrayBlock.containsCell(i, j) && o instanceof String) {
                    this.iArrayBlock.setValueAt(i, j, (String)o);
                }
            }
            try {
                String matlabReply = this.synchronouslyCallMATLAB(new Callable<String>(){

                    @Override
                    public String call() {
                        try {
                            GridEditorHandler.this.setDataToMatlab(o.toString(), i, j);
                            return null;
                        }
                        catch (Exception e) {
                            return e.getMessage();
                        }
                    }
                });
                if (matlabReply != null) {
                    if (cachedCellText != null) {
                        this.iArrayBlock.setValueAt(i, j, cachedCellText);
                    }
                    HashMap<String, String> replyMap = new HashMap<String, String>();
                    replyMap.put("type", "errormsg");
                    replyMap.put("message", matlabReply);
                    GridEditorHandler.this.getGridNode().dispatchPeerEvent("errormsg", GridEditorHandler.this.getGridNode(), replyMap);
                }
            }
            catch (Exception e) {
                GridEditorHandler.this.sendExceptionToClient(e);
                System.out.println(e);
            }
        }

        public void dispatchCellEvent(int row, int column, Map<String, Object> data) {
        }

        public ArrayBlock getCurrentArrayBlock() {
            return this.iArrayBlock;
        }
    }
}

