/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.windowHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerFactory;
import com.mathworks.matlabserver.jcp.handlers.RootHandler;
import com.mathworks.matlabserver.jcp.handlers.containerHandlers.AbstractContainerHandler;
import com.mathworks.matlabserver.jcp.utils.WindowUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public abstract class AbstractWindowHandler
extends AbstractContainerHandler {
    private Handler menuBarHandler;
    private ContainerListener menuBarListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            Component previousMenuBar = null;
            if (AbstractWindowHandler.this.menuBarHandler != null) {
                previousMenuBar = AbstractWindowHandler.this.menuBarHandler.getComponent();
            }
            if (previousMenuBar != AbstractWindowHandler.this.getMenuBar()) {
                if (AbstractWindowHandler.this.menuBarHandler != null) {
                    AbstractWindowHandler.this.menuBarHandler.destroy();
                    AbstractWindowHandler.this.menuBarHandler = null;
                }
                AbstractWindowHandler.this.handleMenuBar();
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (AbstractWindowHandler.this.menuBarHandler != null && AbstractWindowHandler.this.getMenuBar() == null) {
                AbstractWindowHandler.this.menuBarHandler.destroy();
                AbstractWindowHandler.this.menuBarHandler = null;
            }
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractWindowHandler.this.markDirty();
        }
    };
    private Container rootContainer;
    private WindowUtils windowUtils;
    private int defaultX;
    private int defaultY;
    private Observer windowObserver = new Observer(){

        public void handle(final Event event) {
            AbstractWindowHandler.this.invokeLaterEDT(new Runnable(){

                @Override
                public void run() {
                    if (event.getData().get("type").equals("windowClosing")) {
                        if (AbstractWindowHandler.this.getWindow() != null && AbstractWindowHandler.this.getWindow().isVisible()) {
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(AbstractWindowHandler.this.getWindow(), 201));
                        } else {
                            RootHandler.cleanupHandler(AbstractWindowHandler.this.getWindow(), AbstractWindowHandler.this);
                        }
                    } else if (event.getData().get("type").equals("resize")) {
                        Insets insets = AbstractWindowHandler.this.getInsets();
                        int contentWidth = (int)Math.round((Double)event.getData().get("width"));
                        int contentHeight = (int)Math.round((Double)event.getData().get("height"));
                        Rectangle newDims = AbstractWindowHandler.this.windowUtils.getWindowBounds(AbstractWindowHandler.this.getLeft(), AbstractWindowHandler.this.getTop(), new Dimension(contentWidth += insets.left + insets.right, contentHeight += insets.top + insets.bottom));
                        AbstractWindowHandler.this.updateWindowSizeAndPosition(newDims);
                    }
                }
            });
        }
    };
    private Observer propertySetObserver = new Observer(){

        public void handle(Event event) {
            String key = event.getData().get("key").toString();
            if (key.equals("minimized")) {
                Boolean value = (Boolean)event.getData().get("newValue");
                if (value.booleanValue()) {
                    AbstractWindowHandler.this.invokeLaterEDT(new Runnable(){

                        @Override
                        public void run() {
                            Window w = AbstractWindowHandler.this.getWindow();
                            if (w instanceof Frame) {
                                Frame f = (Frame)w;
                                f.setExtendedState(1);
                            }
                        }
                    });
                } else {
                    AbstractWindowHandler.this.invokeLaterEDT(new Runnable(){

                        @Override
                        public void run() {
                            Window w = AbstractWindowHandler.this.getWindow();
                            if (w instanceof Frame) {
                                Frame f = (Frame)w;
                                f.setExtendedState(0);
                            }
                        }
                    });
                }
            }
        }
    };

    @Override
    public String getType() {
        return "GUIContainer";
    }

    public Window getWindow() {
        return (Window)SwingUtilities.getRoot(this.component);
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.windowUtils = new WindowUtils(parent);
        Window window = (Window)component;
        Rectangle dims = this.windowUtils.getNewWindowBounds(window);
        window.setSize(dims.getSize());
        window.validate();
        this.defaultX = dims.x;
        this.defaultY = dims.y;
        this.rootContainer = (Container)component;
        super.handle(parentHandler, WindowUtils.getWindowContent(this.rootContainer), parent);
        this.handleMenuBar();
    }

    protected void handleMenuBar() {
        JMenuBar menuBar = this.getMenuBar();
        if (menuBar != null) {
            this.menuBarHandler = HandlerFactory.getHandler(menuBar);
            if (this.menuBarHandler != null) {
                this.menuBarHandler.handle(this, menuBar, this.peerNode, this.container);
            }
        }
    }

    protected abstract String getTitle();

    protected abstract JMenuBar getMenuBar();

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> properties = super.doGetProperties(component);
        String title = this.getTitle() != null ? this.getTitle() : "";
        properties.put("title", title);
        properties.put("dockable", this.isDockable());
        properties.put("docked", this.isDocked());
        properties.put("resizable", this.isResizable());
        properties.put("modal", WindowUtils.isModal(this.getWindow()));
        properties.put("left", this.getLeft());
        properties.put("top", this.getTop());
        this.setFiltered(title.matches("^Figure ?$"));
        return properties;
    }

    public boolean isDockable() {
        if (this.peerNode == null) {
            return WindowUtils.isDockable(this.getWindow());
        }
        return (Boolean)this.peerNode.getProperty("dockable");
    }

    public boolean isDocked() {
        if (this.peerNode == null) {
            return WindowUtils.isDefaultDocked(this.getWindow()) && this.isDockable();
        }
        return (Boolean)this.peerNode.getProperty("docked") != false && this.isDockable();
    }

    protected boolean isResizable() {
        return true;
    }

    public void resize() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.getWindow() != null) {
            Rectangle newDims = this.windowUtils.getWindowBounds(this.getLeft(), this.getTop(), new Dimension(this.getWindow().getWidth(), this.getWindow().getHeight()));
            this.updateWindowSizeAndPosition(newDims);
        }
    }

    private void updateWindowSizeAndPosition(Rectangle newDims) {
        this.setLeft(newDims.x);
        this.setTop(newDims.y);
        if (this.getWindow() != null) {
            this.getWindow().setSize(newDims.getSize());
        }
    }

    private int getTop() {
        return (int)(this.peerNode != null && this.peerNode.hasProperty("top") ? (Double)this.peerNode.getProperty("top") : (double)this.defaultY);
    }

    private int getLeft() {
        return (int)(this.peerNode != null && this.peerNode.hasProperty("left") ? (Double)this.peerNode.getProperty("left") : (double)this.defaultX);
    }

    public void setTop(int top) {
        this.peerNode.setProperty("top", (Object)top);
    }

    public void setLeft(int left) {
        this.peerNode.setProperty("left", (Object)left);
    }

    protected Insets getInsets() {
        Insets insets = this.windowUtils.getInsets(this.getWindow());
        if (this.getWindow() == null) {
            this.invokeLaterEDT(new Runnable(){

                @Override
                public void run() {
                    if (AbstractWindowHandler.this.getWindow() != null && AbstractWindowHandler.this.getWindow().isVisible()) {
                        AbstractWindowHandler.this.markDirty();
                    }
                }
            });
        }
        return insets;
    }

    @Override
    public void destroy() {
        if (this.menuBarHandler != null) {
            this.menuBarHandler.destroy();
            this.menuBarHandler = null;
        }
        super.destroy();
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.rootContainer.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.rootContainer.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void addContainerListener(Container container) {
        super.addContainerListener(container);
        this.addMenuBarListener(this.menuBarListener);
        this.rootContainer.addContainerListener(this.menuBarListener);
    }

    protected abstract void addMenuBarListener(ContainerListener var1);

    @Override
    protected void removeContainerListener(Container container) {
        super.removeContainerListener(container);
        this.removeMenuBarListener(this.menuBarListener);
        this.rootContainer.removeContainerListener(this.menuBarListener);
    }

    protected abstract void removeMenuBarListener(ContainerListener var1);

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.windowObserver);
        this.peerNode.addEventListener("propertySet", this.propertySetObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.windowObserver);
        this.peerNode.removeEventListener("propertySet", this.propertySetObserver);
    }

    @Override
    public String getComponentName() {
        Window window = this.getWindow();
        if (window != null) {
            return window.getName();
        }
        return this.component.getName();
    }

    @Override
    public String getComponentSwingType() {
        Window window = this.getWindow();
        if (window != null) {
            return window.getClass().getSimpleName();
        }
        return this.component.getClass().getSimpleName();
    }

    @Override
    public boolean ownsComponent(Component component) {
        return super.ownsComponent(component) || this.rootContainer.equals(component);
    }
}

