/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.listeners;

import com.mathworks.peermodel.PeerModelManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.SwingUtilities;

public class ClipboardListener
implements FlavorListener,
ClipboardOwner {
    private static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private PeerModelManager manager;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("clipboard listener");
            thread.setDaemon(true);
            return thread;
        }
    });
    private int tries = 0;

    public ClipboardListener(PeerModelManager manager) {
        this.manager = manager;
    }

    public Map<String, Object> getClipboardProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            String value = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (value != null) {
                props.put("clipboard", value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updatePeerNode();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.updatePeerNode();
    }

    private void updatePeerNode() {
        block3: {
            ++this.tries;
            if (this.manager.hasRoot()) {
                this.manager.getRoot().setProperties(this.getClipboardProperties());
                try {
                    clipboard.removeFlavorListener(this);
                    clipboard.setContents(clipboard.getContents(this), this);
                    clipboard.addFlavorListener(this);
                    this.tries = 0;
                }
                catch (Exception e) {
                    if (this.tries >= 10) break block3;
                    this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ClipboardListener.this.updatePeerNode();
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

