/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class PlotUtils {
    public static Class plotActionClass = PlotUtils.getRefToPlotActionClass();
    public static Method getSelectionMCodeMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "getSelectionMCode");
    public static Method getExecutionStringMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "getExecutionString");
    public static Method getHasCustomExecutionFunction = PlotUtils.getPlotActionMethodRef(plotActionClass, "hasCustomExecutionFunction");
    public static Method getExecutionTextFcnMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "getExecutionTextFcn");
    public static Method getEvalCustomExecutionFunc = PlotUtils.getPlotActionMethodRef(plotActionClass, "evalCustomExecutionFunc");
    public static Method getIDMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "getID");
    public static Method getDescriptionMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "getDescription");
    public static Method getIconMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "getIcon");
    public static Method isGUIMethod = PlotUtils.getPlotActionMethodRef(plotActionClass, "isGUI");

    public static Map<String, PlotAction[]> createNoSelectionModelState(String[] licenseData) {
        LinkedHashMap<String, PlotAction[]> plotHierarchyMap = new LinkedHashMap<String, PlotAction[]>();
        String[] productName = null;
        String[] productFlexName = null;
        Class<?> prodIdentifier = null;
        Class<?> stateNode = null;
        Method valuesMethod = null;
        Method getNameMethod = null;
        Method getFlexMethod = null;
        Method getProductID = null;
        Product[] installedProducts = null;
        Object[] productEnum = new Object[]{};
        installedProducts = ProductInfoUtils.getAllProductsInfo();
        try {
            prodIdentifier = Class.forName("com.mathworks.product.util.ProductIdentifier");
            stateNode = Class.forName("com.mathworks.mlwidgets.graphics.StateNode");
        }
        catch (ClassNotFoundException e) {
            Log.log((String)e.toString());
        }
        try {
            valuesMethod = prodIdentifier.getDeclaredMethod("values", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Log.log((String)e.toString());
        }
        try {
            productEnum = (Object[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        try {
            getNameMethod = prodIdentifier.getDeclaredMethod("getName", new Class[0]);
            getFlexMethod = prodIdentifier.getDeclaredMethod("getFlexName", new Class[0]);
            getProductID = stateNode.getDeclaredMethod("getProductID", new Class[0]);
            getProductID.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            Log.log((String)e.toString());
        }
        try {
            int i;
            productName = new String[productEnum.length];
            for (i = 0; i < productEnum.length; ++i) {
                productName[i] = (String)getNameMethod.invoke(productEnum[i], new Object[0]);
            }
            productFlexName = new String[productEnum.length];
            for (i = 0; i < productEnum.length; ++i) {
                productFlexName[i] = (String)getFlexMethod.invoke(productEnum[i], new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        Method createPlotsMethod = null;
        DefaultMutableTreeNode hierarchyStateNode = null;
        try {
            createPlotsMethod = ModelStateFactory.class.getDeclaredMethod("createNoSelectionModelState", new Class[0]);
            createPlotsMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            Log.log((String)e.toString());
        }
        catch (NoSuchMethodException e) {
            Log.log((String)e.toString());
        }
        if (createPlotsMethod == null) {
            return plotHierarchyMap;
        }
        try {
            hierarchyStateNode = (DefaultMutableTreeNode)createPlotsMethod.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return plotHierarchyMap;
        }
        catch (IllegalAccessException e) {
            return plotHierarchyMap;
        }
        catch (InvocationTargetException e) {
            return plotHierarchyMap;
        }
        ArrayList<String> licenseNames = new ArrayList<String>();
        block24: for (int i = 0; i < productFlexName.length; ++i) {
            for (String licenseDataEntry : licenseData) {
                if (!productFlexName[i].equals(licenseDataEntry)) continue;
                licenseNames.add(productName[i]);
                continue block24;
            }
        }
        ArrayList<String> licenseProductIds = new ArrayList<String>();
        for (String licenseName : licenseNames) {
            for (Product installedProduct : installedProducts) {
                if (!licenseName.equals(installedProduct.getFullName())) continue;
                licenseProductIds.add(installedProduct.getName());
            }
        }
        for (int k = 0; k < hierarchyStateNode.getChildCount(); ++k) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)hierarchyStateNode.getChildAt(k);
            boolean install = false;
            if (!node.getAllowsChildren()) continue;
            try {
                String pID = (String)getProductID.invoke((Object)node, new Object[0]);
                for (String licenseProductId : licenseProductIds) {
                    if (!pID.equals(licenseProductId)) continue;
                    install = true;
                    break;
                }
            }
            catch (IllegalAccessException e) {
                Log.log((String)e.toString());
            }
            catch (InvocationTargetException e) {
                Log.log((String)e.toString());
            }
            if (!install) continue;
            PlotAction[] plotActionItems = new PlotAction[node.getChildCount()];
            for (int j = 0; j < plotActionItems.length; ++j) {
                plotActionItems[j] = (PlotAction)((DefaultMutableTreeNode)node.getChildAt(j)).getUserObject();
            }
            plotHierarchyMap.put((String)node.getUserObject(), plotActionItems);
        }
        return plotHierarchyMap;
    }

    public static String getSelectionMCode(PlotAction plotItem) {
        String result = null;
        try {
            result = (String)getSelectionMCodeMethod.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static String getExecutionString(PlotAction plotItem, String[] selectedVars, boolean createNewFigure) {
        String result = null;
        try {
            result = (String)getExecutionStringMethod.invoke((Object)plotItem, selectedVars, createNewFigure);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static String getCustomExecutionStringEvaluator(PlotAction plotItem, String[] selectedVars) {
        String result = null;
        String execFunc = null;
        try {
            execFunc = (String)getExecutionTextFcnMethod.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        result = PlotUtils.getAnonymousInputCount(execFunc) == 1 ? "feval(" + execFunc + "," + PlotUtils.getArgumentStringCellArray(selectedVars) + ")" : "feval(" + execFunc + "," + PlotUtils.getArgumentStringCellArray(selectedVars) + "," + PlotUtils.getArgumentCellArray(selectedVars) + ")";
        return result;
    }

    public static boolean hasCustomExecutionFunction(PlotAction plotItem) {
        boolean result = false;
        try {
            result = (Boolean)getHasCustomExecutionFunction.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static int getAnonymousInputCount(String funcHandle) {
        if (funcHandle == null || !funcHandle.matches("^@\\(.+\\).+")) {
            return 0;
        }
        int openParen = funcHandle.indexOf(40);
        int closeParen = funcHandle.indexOf(41);
        int commaCount = 0;
        for (int ind = openParen; ind < closeParen; ++ind) {
            if (funcHandle.charAt(ind) != ',') continue;
            ++commaCount;
        }
        return commaCount + 1;
    }

    public static String getID(PlotAction plotItem) {
        String result = null;
        try {
            result = (String)getIDMethod.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static String getDescription(PlotAction plotItem) {
        String result = null;
        try {
            result = (String)getDescriptionMethod.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static ImageIcon getIcon(PlotAction plotItem) {
        ImageIcon result = null;
        try {
            result = (ImageIcon)getIconMethod.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static String getFormattedTitle(String title) {
        title = title.toUpperCase(Locale.ENGLISH);
        return title;
    }

    public static boolean isGUI(PlotAction plotItem) {
        boolean result = false;
        try {
            result = (Boolean)isGUIMethod.invoke((Object)plotItem, new Object[0]);
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return result;
    }

    public static Class getRefToPlotActionClass() {
        Class<?> plotAction = null;
        try {
            plotAction = Class.forName("com.mathworks.mlwidgets.graphics.PlotAction");
        }
        catch (ClassNotFoundException e) {
            Log.log((String)e.toString());
        }
        return plotAction;
    }

    public static Method getPlotActionMethodRef(Class plotAction, String method) {
        Method methodRef = null;
        try {
            methodRef = method.equals("getExecutionString") ? plotAction.getDeclaredMethod(method, String[].class, Boolean.TYPE) : (method.equals("evalCustomExecutionFunc") ? plotAction.getDeclaredMethod(method, String[].class) : plotAction.getDeclaredMethod(method, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Log.log((String)e.toString());
        }
        if (methodRef != null) {
            methodRef.setAccessible(true);
        }
        return methodRef;
    }

    public static String getArgumentCellArray(String[] selectedVars) {
        if (selectedVars.length == 1 && selectedVars[0].matches("^cell2mat\\s*\\(.*\\)")) {
            String varName = selectedVars[0].replaceAll("^cell2mat\\s*\\(", "");
            varName = varName.replaceAll("\\)$", "");
            return "internal.matlab.plotpicker.inputPreProc('cell2mat',{" + varName + "})";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append(selectedVars[0]);
        for (int j = 1; j < selectedVars.length; ++j) {
            buf.append(",");
            buf.append(selectedVars[j]);
        }
        buf.append("}");
        return buf.toString();
    }

    public static String getArgumentStringCellArray(String[] selectedVars) {
        StringBuilder buf = new StringBuilder();
        buf.append("{'");
        buf.append(selectedVars[0]);
        for (int j = 1; j < selectedVars.length; ++j) {
            buf.append("','");
            buf.append(selectedVars[j]);
        }
        buf.append("'}");
        return buf.toString();
    }

    private static PlotItem createPlotItem(PlotAction plotAction) {
        Method getIDMethod;
        Method getRefPagePathMethod;
        Method getIconMethod;
        ImageIcon icon = null;
        String refPage = "";
        String id = "";
        try {
            getIconMethod = PlotAction.class.getDeclaredMethod("getIcon", new Class[0]);
            getIconMethod.setAccessible(true);
            getRefPagePathMethod = PlotAction.class.getDeclaredMethod("getRefPagePath", new Class[0]);
            getRefPagePathMethod.setAccessible(true);
            getIDMethod = PlotAction.class.getDeclaredMethod("getID", new Class[0]);
            getIDMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            icon = (ImageIcon)getIconMethod.invoke((Object)plotAction, new Object[0]);
            refPage = (String)getRefPagePathMethod.invoke((Object)plotAction, new Object[0]);
            id = (String)getIDMethod.invoke((Object)plotAction, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            Log.log((String)e.toString());
        }
        catch (IllegalAccessException e) {
            Log.log((String)e.toString());
        }
        catch (InvocationTargetException e) {
            Log.log((String)e.toString());
        }
        return new PlotItem(icon, plotAction.getPlotLabel(null), id, refPage);
    }

    public static class PlotItem {
        private ImageIcon iIcon;
        private String iDefaultText;
        private String iID;
        private String iRefPage;

        private PlotItem(ImageIcon icon, String defaultText, String id, String refPage) {
            this.iIcon = icon;
            this.iDefaultText = defaultText;
            this.iID = id;
            this.iRefPage = refPage;
        }

        public ImageIcon getIcon() {
            return this.iIcon;
        }

        public String getDefaultText() {
            return this.iDefaultText;
        }

        public String getID() {
            return this.iID;
        }

        public String getRefPage() {
            return this.iRefPage;
        }
    }
}

