/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import com.mathworks.hg.peer.FigureFrameProxy;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.DTToolBarContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class WindowUtils {
    private static final int DEFAULT_BROWSER_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width;
    private static final int DEFAULT_BROWSER_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height;
    private static final List<String> NOT_DOCKABLE_TITLES = new ArrayList<String>();
    private static boolean forceDefaultUndocked;
    private PeerNode root = null;

    public WindowUtils(PeerNode root) {
        this.root = root;
    }

    public Dimension getBrowserDimensions() {
        return new Dimension(this.getNodeIntValue("screenWidth", DEFAULT_BROWSER_WIDTH), this.getNodeIntValue("screenHeight", DEFAULT_BROWSER_HEIGHT));
    }

    private Dimension getDockedDimensions(Window window) {
        return new Dimension(this.getNodeIntValue("dockedWidth", this.getWidth(window)), this.getNodeIntValue("dockedHeight", this.getHeight(window)));
    }

    private int getNodeIntValue(String key, int defaultValue) {
        if (this.root != null && this.root.hasProperty(key)) {
            return ((Double)this.root.getProperty(key)).intValue();
        }
        return defaultValue;
    }

    public Rectangle getNewWindowBounds(Window window) {
        Rectangle undockedBounds = this.getWindowBounds(window.getBounds());
        if (WindowUtils.isDefaultDocked(window)) {
            int windowWidth = window.getWidth();
            int windowHeight = window.getHeight();
            Dimension browserDimensions = this.getDockedDimensions(window);
            int maxWidth = browserDimensions.width;
            int maxHeight = browserDimensions.height;
            float maxAspect = (float)maxWidth / (float)maxHeight;
            float aspect = (float)this.getWidth(window) / (float)this.getHeight(window);
            Insets insets = this.getInsets(window);
            if (maxAspect < aspect) {
                if (maxHeight != window.getHeight()) {
                    windowWidth = (int)((float)maxHeight * aspect) + insets.left + insets.right;
                    windowHeight = maxHeight + insets.top + insets.bottom;
                }
            } else if (maxWidth != window.getWidth()) {
                windowWidth = maxWidth + insets.left + insets.right;
                windowHeight = (int)((float)maxWidth / aspect) + insets.top + insets.bottom;
            }
            return new Rectangle(undockedBounds.x, undockedBounds.y, windowWidth, windowHeight);
        }
        return undockedBounds;
    }

    public Rectangle getWindowBounds(int clientX, int clientY, Dimension size) {
        Dimension clientSize = this.getBrowserDimensions();
        int clientWidth = Math.min(size.width, clientSize.width);
        int clientHeight = Math.min(size.height, clientSize.height + 15);
        clientX = Math.max(0, Math.min(clientX, clientSize.width - clientWidth));
        clientY = Math.max(0, Math.min(clientY, clientSize.height - clientHeight));
        return new Rectangle(clientX, clientY, clientWidth, clientHeight);
    }

    public Rectangle getWindowBounds(Rectangle bounds) {
        Dimension clientSize = this.getBrowserDimensions();
        Dimension serverSize = Toolkit.getDefaultToolkit().getScreenSize();
        int clientWidth = Math.min(bounds.width, clientSize.width);
        int clientHeight = Math.min(bounds.height, clientSize.height);
        int clientX = (int)((double)bounds.x * (double)(clientSize.width - clientWidth) / (double)(serverSize.width - bounds.width));
        int clientY = (int)((double)bounds.y * (double)(clientSize.height - clientHeight) / (double)(serverSize.height - bounds.height));
        clientX = Math.max(0, Math.min(clientX, clientSize.width - clientWidth));
        clientY = Math.max(0, Math.min(clientY, clientSize.height - clientHeight));
        return new Rectangle(clientX, clientY, clientWidth, clientHeight);
    }

    private int getWidth(Window window) {
        Insets insets = this.getInsets(window);
        return window.getWidth() - insets.left - insets.right;
    }

    private int getHeight(Window window) {
        Insets insets = this.getInsets(window);
        return window.getHeight() - insets.top - insets.bottom;
    }

    public Insets getInsets(Window window) {
        Component content = WindowUtils.getWindowContent(window);
        if (window != null && content != null) {
            int width = window.getWidth() - content.getWidth();
            int height = window.getHeight() - WindowUtils.getWindowContentHeight(WindowUtils.getWindowContent(window));
            return new Insets(height, width / 2, 0, width / 2);
        }
        return new Insets(0, 0, 0, 0);
    }

    public static int getWindowContentHeight(Component component) {
        Component toolBar = WindowUtils.getToolBarRoot(component);
        int toolBarHeight = toolBar != null && SwingUtilities.isDescendingFrom(toolBar, component) ? toolBar.getHeight() : 0;
        Rectangle rect = component.getBounds();
        return rect.height - toolBarHeight;
    }

    public static Component getWindowContent(Container window) {
        Component toolBarRoot = WindowUtils.getToolBarRoot(window);
        if (toolBarRoot != null && toolBarRoot instanceof Container) {
            Container parent;
            Container lastParent = (Container)toolBarRoot;
            for (parent = toolBarRoot.getParent(); parent != null && parent.getComponentCount() == 1; parent = parent.getParent()) {
                lastParent = parent;
            }
            if (parent == null) {
                return lastParent;
            }
            return parent;
        }
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            if (frame.getContentPane().toString().contains("Panel") && frame.getContentPane().getComponentCount() < 2) {
                return frame.getContentPane();
            }
            if (frame.getJMenuBar() != null) {
                return frame.getContentPane();
            }
            return frame;
        }
        if (window instanceof JDialog) {
            JDialog dialog = (JDialog)window;
            if (dialog.getContentPane().toString().contains("Panel") && dialog.getContentPane().getComponentCount() <= 2) {
                return dialog.getContentPane();
            }
            if (dialog.getJMenuBar() != null) {
                return dialog.getContentPane();
            }
            return dialog;
        }
        return window;
    }

    public static Component getToolBarRoot(Component component) {
        if (component instanceof DTToolBarContainer || component instanceof JToolBar) {
            return component;
        }
        if (component instanceof Container) {
            ArrayDeque fifo = new ArrayDeque();
            Collections.addAll(fifo, ((Container)component).getComponents());
            while (!fifo.isEmpty()) {
                Component child = (Component)fifo.remove();
                if (child instanceof DTToolBarContainer || child instanceof JToolBar) {
                    return child;
                }
                if (!(child instanceof Container) || ((Container)child).getComponents() == null) continue;
                Collections.addAll(fifo, ((Container)child).getComponents());
            }
        }
        return null;
    }

    public static boolean isDockable(Window window) {
        boolean dockable;
        block8: {
            dockable = true;
            if (window instanceof JDialog || window instanceof Dialog) {
                dockable = false;
            } else if (window instanceof DTSingleClientFrame) {
                DTSingleClientFrame clientFrame = (DTSingleClientFrame)window;
                try {
                    Method getClient = DTSingleClientFrame.class.getDeclaredMethod("getClient", new Class[0]);
                    getClient.setAccessible(true);
                    DTClient client = (DTClient)getClient.invoke((Object)clientFrame, new Object[0]);
                    Method isDockable = DTOccupant.class.getDeclaredMethod("isDockable", new Class[0]);
                    isDockable.setAccessible(true);
                    if (client != null) {
                        dockable = (Boolean)isDockable.invoke((Object)client, new Object[0]);
                        break block8;
                    }
                    dockable = ((JFrame)window).isResizable();
                }
                catch (Exception e) {
                    dockable = ((JFrame)window).isResizable();
                    e.printStackTrace();
                }
            } else if (window instanceof JFrame) {
                JFrame frame = (JFrame)window;
                dockable = frame.isResizable() && !WindowUtils.isModal(window) && !NOT_DOCKABLE_TITLES.contains(frame.getTitle());
            }
        }
        return dockable;
    }

    public static boolean isDefaultDocked(Component window) {
        boolean isResizable;
        String title;
        boolean isModal;
        if (forceDefaultUndocked) {
            return false;
        }
        boolean bl = isModal = !(window instanceof Window) || WindowUtils.isModal((Window)window);
        if (window instanceof JFrame) {
            title = ((JFrame)window).getTitle();
            isResizable = ((JFrame)window).isResizable();
        } else if (window instanceof JDialog) {
            title = ((JDialog)window).getTitle();
            isResizable = ((JDialog)window).isResizable();
        } else {
            return !isModal;
        }
        title = title != null ? title : "";
        String name = window.getName();
        return title.matches("^Figure [0-9]+$") && isResizable && !isModal && (name == null || name.length() == 0);
    }

    public static boolean isModal(Window window) {
        boolean awtModality = window instanceof Dialog && !((Dialog)window).getModalityType().equals((Object)Dialog.ModalityType.MODELESS);
        boolean matlabModal = false;
        try {
            Field proxyField = window.getClass().getDeclaredField("this$0");
            proxyField.setAccessible(true);
            FigureFrameProxy proxy = (FigureFrameProxy)proxyField.get(window);
            matlabModal = proxy.isModal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return awtModality || matlabModal;
    }

    public static void forceDefaultUndocked(boolean undocked) {
        forceDefaultUndocked = undocked;
    }

    static {
        NOT_DOCKABLE_TITLES.add("Control System and System Identification Toolbox Preferences");
        NOT_DOCKABLE_TITLES.add("Linear Simulation Tool");
        NOT_DOCKABLE_TITLES.add("Control and Estimation Tools Manager");
        forceDefaultUndocked = false;
    }
}

